define({"0":{y:0,u:"../Typographical_Conventions.htm",l:-1,t:"Typographical Conventions",i:0.000975280246537758,a:"Typographical Conventions The following table lists the typographical conventions used in this guide:"},"1":{y:0,u:"../install-guide/Installation_Overview.htm",l:-1,t:"Installation Overview",i:0.000975280246537758,a:"This is your starting point for planning, installing, and configuring TIBCO GridServer® for your site. This guide describes how to install, test, and uninstall the Manager, Drivers, and Engines on Windows and UNIX platforms. This guide is for a DataSynapse GridServer Manager or technology manager ..."},"2":{y:0,u:"../install-guide/Overview.htm",l:-1,t:"Preparing for Installation",i:0.000975280246537758,a:"This section lists prerequisites for a GridServer installation and outlines the installation steps. This section assists developers, system architects, and network architects in planning a GridServer production deployment. Read this section carefully to prepare for installation. Before you begin ..."},"3":{y:0,u:"../install-guide/Know_the_Basics.htm",l:-1,t:"Know the Basics",i:0.000975280246537758,a:"This guide assumes that you know GridServer concepts. If you do not, see the TIBCO GridServer® Introducing TIBCO GridServer® for information about the GridServer component architecture and principles of operation. You must also be familiar with Windows and UNIX operating systems and TCP/IP ..."},"4":{y:0,u:"../install-guide/Meet_GridServer_System_Requirements.htm",l:-1,t:"GridServer System Requirements",i:0.000975280246537758,a:"Ensure that your environment meets the minimum hardware and software system requirements for memory, disk space, and processor speed. See the readme file included in the product archive for the complete list of all hardware and software requirements, including supported operating systems, Java or ..."},"5":{y:0,u:"../install-guide/Optimize_GridServer_Manager_Architecture.htm",l:-1,t:"Optimize GridServer Manager Architecture",i:0.000975280246537758,a:"You can deploy the GridServer Manager architecture to give varying degrees of redundancy and load sharing, depending on the available computing resources. To plan an architecture that best supports your needs: Determine how your facility wants to use GridServer.  Estimate expected transaction volume ..."},"6":{y:0,u:"../install-guide/About_GridServer_Manager.htm",l:-1,t:"About GridServer Manager",i:0.000975280246537758,a:"A minimal configuration of GridServer consists of a single Manager configured with a Primary Director and a single Broker. You can add additional Managers containing more Brokers or Directors to address redundancy, volume, or other considerations. You set an initial configuration of the Manager at ..."},"7":{y:0,u:"../install-guide/Redundancy.htm",l:-1,t:"Redundancy",i:0.000975280246537758,a:"If you have a minimal configuration including a single Director and single Broker, Engines and Drivers log in to the Director. In this configuration, if the Director fails (as in the case of hardware or network failure), Drivers or Engines cannot establish new connections. To prevent this problem, ..."},"8":{y:0,u:"../install-guide/Grid_Size.htm",l:-1,t:"Grid Size",i:0.000975280246537758,a:"This GridServer configuration shows a Primary Director and a Secondary Director on separate systems and live Brokers on both systems. You can add Engines and Drivers to the cluster as desired. This configuration is redundant. In larger grids, the number of Engines in the grid can require more ..."},"9":{y:0,u:"../install-guide/Component_OS_and_Version_Interoperability.htm",l:-1,t:"Component OS and Version Interoperability",i:0.000975280246537758,a:"Running Brokers on the same OS as other components is not a requirement and gives no performance benefit. However, running the same OS for all components does simplify administration and troubleshooting. A GridServer installation typically requires that GridServer components all reflect the same ..."},"10":{y:0,u:"../install-guide/Other_Considerations.htm",l:-1,t:"Other Considerations",i:0.000975280246537758,a:"Several other factors can influence how you integrate GridServer with your computing environment: Instead of using one grid for all types of Services, you might prefer to divide different subsets of Services (for example, by size or priority) to different Directors. Your network can dictate how to ..."},"11":{y:0,u:"../install-guide/Configure_Your_Network.htm",l:-1,t:"Configure Your Network",i:0.00102095498869104,a:"Since GridServer is a distributed computing application, successful deployment depends on your network configuration. Treat GridServer Managers the same way you treat your other mission-critical file and application servers: assign GridServer Managers static IP addresses and resolvable DNS ..."},"12":{y:0,u:"../install-guide/Name_Service.htm",l:-1,t:"Name Service",i:0.000975280246537758,a:"Run GridServer Managers on systems with static IP addresses and resolvable DNS hostnames. In a pure Windows environment, it is possible to run GridServer using just WINS name resolution, but this is not recommended for larger deployments or heterogeneous environments. GridServer does not support ..."},"13":{y:0,u:"../install-guide/Director_Broker_Communication.htm",l:-1,t:"Director-Broker Communication",i:0.000975280246537758,a:"Directors and Brokers communicate using TCP on port 5635. This port is used for both initial login and further communication. If you need to specify a different port (for example, if you are running multiple instances on a single machine), you can do so at installation, or by reinstalling the ..."},"14":{y:0,u:"../install-guide/Manager_Engine_and_Driver_Manager_Communication.htm",l:-1,t:"Manager-Engine and Driver-Manager Communication",i:0.000975280246537758,a:"All communication between Engines and Managers (Directors and Brokers) and between Drivers and Managers uses the HTTP protocol. The Engine or Driver acts as HTTP client and the Manager acts as HTTP server. All communication between Engines and Managers or Drivers and Managers is with the HTTP ..."},"15":{y:0,u:"../install-guide/Using_NAT.htm",l:-1,t:"Configuring the Manager by Using NAT",i:0.000975280246537758,a:"You can configure the Manager to work with a NAT device between the Manager and the Engines or Drivers. If the untranslated site of the network has no Engines, you can configure to work with a NAT device by specifying the external (translated) address of the NAT device when referring to the Manager ..."},"16":{y:0,u:"../install-guide/Using_a_VPN.htm",l:-1,t:"Using a VPN",i:0.000975280246537758,a:"Engines and Clients can run behind a VPN, provided that the Engine Daemon or Driver can determine the correct IP address to use. If VPN client software on the Engine/Client machine handles the VPN, you can possibly specify which IP address to use. For Engines, in the Engine Configuration, use the ..."},"17":{y:0,u:"../install-guide/Resource_Synchronization.htm",l:-1,t:"Resource Synchronization",i:0.000975280246537758,a:"Normally, GridServer synchronizes resources from Directors to Brokers, then from Brokers to Engines. However, in situations when you want only to deploy resources to a subset of Engines, you can disable resource synchronization in the Engine Configuration, and then set the lib directory to point to ..."},"18":{y:0,u:"../install-guide/Direct_Data_Transfer.htm",l:-1,t:"Direct Data Transfer",i:0.000975280246537758,a:"By default, GridServer uses Direct Data Transfer, or peer-to-peer communication, to optimize data throughput between Drivers and Engines. Without Direct Data Transfer, all task input and output goes through the Manager. Sending the input and output through the Manager uses more memory and disk on ..."},"19":{y:0,u:"../install-guide/SSL.htm",l:-1,t:"SSL",i:0.000975280246537758,a:"SSL Depending on your application server, you can configure your Manager to use SSL selectively or for all component communication and administration. For information about using SSL, see  Configuring SSL ."},"20":{y:0,u:"../install-guide/Install_the_GridServer_Components.htm",l:-1,t:"Install the GridServer Components",i:0.000975280246537758,a:"Install the GridServer Components After preparing for your installation, install the GridServer components. This section introduces the components and directs you to their installation instructions."},"21":{y:0,u:"../install-guide/GridServer_Manager.htm",l:-1,t:"GridServer Manager",i:0.000975280246537758,a:"GridServer Manager To install a Manager, follow the installation procedure in the Manager Installation section. You must have a running Manager before you install an Engine. For more information about installing Managers, see  Installing DataSynapse GridServer ."},"22":{y:0,u:"../install-guide/GridServer_Engine.htm",l:-1,t:"GridServer Engine",i:0.000975280246537758,a:"GridServer Engines come in two variants: Windows Engines and UNIX Engines.  The Windows Engine is packaged as an MSI installer. It can be manually installed or network installed using a tool such as SMS. UNIX Engines are packaged as tar.gz archives.  Security Considerations On the Windows platform, ..."},"23":{y:0,u:"../install-guide/GridServer_Driver.htm",l:-1,t:"GridServer Driver",i:0.000975280246537758,a:"Application programs use the GridServer Driver to communicate with the GridServer Manager and thereby leverage the grid’s compute resources. Your application deployment usually bundles the Driver deployment. For more information about installing the GridServer SDK, which includes all Drivers, see ..."},"24":{y:0,u:"../install-guide/SpeedLink.htm",l:-1,t:"SpeedLink",i:0.000975280246537758,a:"SpeedLink SpeedLink is a high-throughput extension to GridServer, and is included in the GridServer SDK. For more information, see the  TIBCO GridServer® Speedlink. ."},"25":{y:0,u:"../install-guide/Database.htm",l:-1,t:"Database",i:0.000975280246537758,a:"Database You can also configure GridServer to use an external reporting database, on an enterprise database system. For more information about database configuration, see  Configuring a Reporting Database ."},"26":{y:0,u:"../install-guide/Manager_Installation.htm",l:-1,t:"Manager Installation",i:0.000975280246537758,a:"To begin your DataSynapse GridServer installation, you must install one or more Managers. This section describes how to install the Manager and its components such as Primary and Secondary Directors, and Standalone and Failover Brokers.  This section assumes that you are familiar with the previous ..."},"27":{y:0,u:"../install-guide/Installing_DataSynapse_GridServer.htm",l:-1,t:"Installing DataSynapse GridServer",i:0.00180427637274959,a:"Installing DataSynapse GridServer When upgrading from a previous version of GridServer, see  Upgrading GridServer  and complete all steps before beginning the installation process in this section."},"28":{y:0,u:"../install-guide/1__Copy_Files_Before_Installation.htm",l:-1,t:"Task A: Copy Files Before Installation",i:0.0101932655100385,a:"Before you install TIBCO GridServer®, you must decide where to install the Manager. TIBCO software is installed in a TIBCO home directory, which is referred to in this documentation as TIBCO_HOME and is typically c:\\TIBCO for Windows, or /opt/TIBCO for UNIX. TIBCO GridServer® is installed in an ..."},"29":{y:0,u:"../install-guide/2__Configure_Server_Settings.htm",l:-1,t:"Task B: Configure Server Settings",i:0.001228204020244,a:"If you need to make changes to any of the following, make the changes to the appropriate config file or environment variable, as required: Java Settings You must set the JAVA_HOME environment variable to the root directory of your Java installation.  Windows To set the JAVA_HOME environment ..."},"30":{y:0,u:"../install-guide/3__Start_the_Manager.htm",l:-1,t:"Task C: Start the Manager",i:0.000975280246537758,a:"Start the Manager according to instructions in the Windows or UNIX section that follows. Windows Start the Windows Manager by running the server.bat file, located in the DS_MANAGER directory of the GridServer distribution. To test, open a command window and run server.bat run to launch the Manager ..."},"31":{y:0,u:"../install-guide/4__Initialize_Your_Manager.htm",l:-1,t:"Task D: Initialize Your Manager",i:0.000975280246537758,a:"After the Manager is running for the first time, you must initialize it.  To initialize the Manager: Start the GridServer Administration Tool. Go to http://yourhost:port to open the installation page. Read and accept the End User License Agreement (EULA) to continue installation. Select Installation ..."},"32":{y:0,u:"../install-guide/Silent_Installation.htm",l:-1,t:"Silent Installation",i:0.000975280246537758,a:"The Manager also has a silent installation mode, which can be used to non-interactively install and configure the Manager for automation purposes. In silent mode, the installer does not prompt for any inputs during installation. Instead, the inputs are read from a response file that is provided as a ..."},"33":{y:0,u:"../install-guide/Configuration_Options.htm",l:-1,t:"Configuration Options",i:0.000975280246537758,a:"Configuration Options The following configuration options can be made to customize your Manager installation."},"34":{y:0,u:"../install-guide/Changing_the_HTTP_Ports.htm",l:-1,t:"Changing the HTTP Ports",i:0.00132327483793104,a:"By default, component messaging uses HTTP port 8000, and the web-based Administration Tool uses port 8080. The Tomcat server is also configured to use port 8005 for administration/shutdown. To change any of the HTTP ports: Before installation, go to the DS_MANAGER directory and run server prepare ..."},"35":{y:0,u:"../install-guide/A_Sample_Unix_rc_d_Script.htm",l:-1,t:"A Sample UNIX rc.d Script",i:0.00180427637274959,a:"The following is an example of a simple startup script for the GridServer Manager running on a RedHat Linux system: #!/bin/sh # Startup script for DataSynapse Manager # # Source function library. . /etc/rc.d/init.d/functions prog=\"server\" INSTALLDIR=/opt/TIBCO/DataSynapse/manager ..."},"36":{y:0,u:"../install-guide/A_Sample_Systemd_Unit_File.htm",l:-1,t:"A Sample Systemd Unit File",i:0.000975280246537758,a:"Starting in Red Hat Enterprise Linux 7, the systemd init daemon is used, instead of the upstart init daemon. This uses the concept of targets defined in a unit file. The following is an example of a gridserver.service unit file for the GridServer Manager running on a RedHat 7 Linux system:  [Unit]  ..."},"37":{y:0,u:"../install-guide/Grid_Component_Authentication.htm",l:-1,t:"Authentication of  Grid Components",i:0.00219536616749115,a:"Authenticating all Grid components is an additional security option provided in GridServer. To authenticate all Grid components, you must set the following properties in the Manager: Authenticate Manager Manager Token Manager UserName Manager Password You can also provide Grid authentication ..."},"38":{y:0,u:"../install-guide/Windows_Engine_Installation.htm",l:-1,t:"Windows Engine Installation",i:0.00129728703076166,a:"In the Windows environment, you can download an Engine and install it or transfer it to another computer before installation. You can also use a network installation to install Engines on many machines, or to install multiple Engine instances on different computers , or to install GridServer on a ..."},"39":{y:0,u:"../install-guide/Installing_Windows_Engines.htm",l:-1,t:"Installing Windows Engines",i:0.00216363036832909,a:"To install GridServer Engine on a Windows system: Log in to the GridServer Administration Tool, go to the top navigation bar, and click the Downloads icon. Click the link to download the 32-bit (x86) or 64-bit (x64) Engine installer. This downloads a file named DSEngineInstall.msi or ..."},"40":{y:0,u:"../install-guide/Command_Line_Unattended_Install.htm",l:-1,t:"Command Line Unattended Install",i:0.00216363036832909,a:"To install a Windows Engine from the command line: Copy the DSEngineInstall.msi or DSEngineInstall64.msi file in  DS_MANAGER/webapps/livecluster/public_html/register/install/worker/exe to the Engine machine or a shared directory. If you are using HTTPS, you might need to copy ssl.pem and ..."},"41":{y:0,u:"../install-guide/Network_Install.htm",l:-1,t:"Network Install",i:0.000975280246537758,a:"In most cases, executing the Windows Engine installation MSI across a network from a shared location works with no issues. If there are problems due to network speed, the contents of the MSI can be expanded into a network share and the installer runs from the network location. The MSI is expanded ..."},"42":{y:0,u:"../install-guide/Engine_JRE_Synchronization.htm",l:-1,t:"Engine JRE Synchronization",i:0.000975280246537758,a:"The Engine’s JRE is always kept in synchronization, by default, with its Primary Director.  For example, when the Engine is installed, it downloads a JRE from the Director with which it was configured. If the Engine is moved to another grid that has a different JRE, it synchronizes prior to login to ..."},"43":{y:0,u:"../install-guide/Engine_Permissions.htm",l:-1,t:"Engine Permissions",i:0.000975280246537758,a:"Engines installed by an administrator but run by a non-admin user can have permission issues, especially if the Engine removes a registry key and creates it on an update event. This section contains a list of keys created and used by Engines. Use this list to help determine what permissions to set ..."},"44":{y:0,u:"../install-guide/Configuring_Permissions_for_Processor_Utilization_Mode.htm",l:-1,t:"Configuring Permissions for Processor Utilization Mode",i:0.000975280246537758,a:"If you install an Engine Daemon to run as a Service and the Service logs in as another user, the Processor Utilization mode does not work correctly, because the Engine Daemon cannot retrieve performance data (such as CPU information) from the OS. To remedy this: Start regedt32 (Click Run... from the ..."},"45":{y:0,u:"../install-guide/Configuring_Run_As_for_Windows_Engines.htm",l:-1,t:"Configuring Run-As for Windows Engines",i:0.000975280246537758,a:"To configure run-as for Windows Engines: Right-click the Engine’s install directory, select Properties, and under the Security tab use Add... to add all users that you intend to run Services as. Select the Allow check box for Full Control. In Windows, select Start \u003e Control Panel \u003e Administrative ..."},"46":{y:0,u:"../install-guide/Engine_Configuration_and_Management.htm",l:-1,t:"Engine Configuration and Management",i:0.000975280246537758,a:"Engine Configuration and Management For more information about configuring and managing installed Engines, see the  TIBCO GridServer® Administration."},"47":{y:0,u:"../install-guide/Unix_Engine_Installation.htm",l:-1,t:"UNIX Engine Installation",i:0.00129728703076166,a:"UNIX Engine Installation This section describes how to install GridServer Engines for UNIX. To install Engines on UNIX systems, you must download and install an Engine on each system and run a configuration script. "},"48":{y:0,u:"../install-guide/Installing_Unix_Engines.htm",l:-1,t:"Installing UNIX Engines\n        ",i:0.00216363036832909,a:"Installing UNIX Engines\n         Installing the DataSynapse GridServer UNIX Engine comprises unpacking a gzip-compressed tar archive on a UNIX system; creating or using a profile on the Manager; and associating the Engine with that profile.  To install an Engine on a UNIX system: Log in to the ..."},"49":{y:0,u:"../install-guide/Engine_JRE_Synchronization_1.htm",l:-1,t:"Engine JRE Synchronization",i:0.000975280246537758,a:"The Engine’s JRE is always kept in synchronization, by default, with its Primary Director.  For example, when the Engine is installed, it downloads a JRE from the Director with which it was configured. If the Engine is moved to another grid that has a different JRE, it synchronizes prior to login to ..."},"50":{y:0,u:"../install-guide/Configuring_Run_As_for_Unix_Engines.htm",l:-1,t:"Configuring Run-As for UNIX Engines",i:0.000975280246537758,a:"GridServer uses engine PAM authentication service instead of system PAM authentication. Refer to your UNIX-specific PAM configuration instructions to ensure that the Run-As user is properly authenticated.  To set up the dsengine PAM service for Linux, copy the auth and account sections from the ..."},"51":{y:0,u:"../install-guide/Running_the_Engine.htm",l:-1,t:"Running the Engine",i:0.000975280246537758,a:"The engine.sh script follows the standard start/stop argument convention for system initialization scripts (“rc scripts”), so you can incorporate it in the start-up and shutdown sequence by inserting appropriate links in the /etc/rc.d files. The engine.sh arguments are as follows: By default, Engine ..."},"52":{y:0,u:"../install-guide/Engine_Configuration_and_Management_1.htm",l:-1,t:"Engine Configuration and Management",i:0.000975280246537758,a:"Engine Configuration and Management For more information about configuring and managing Engines, see the  TIBCO GridServer® Administration Guide."},"53":{y:0,u:"../install-guide/Enable_Engine_Daemon_Authentication.htm",l:-1,t:"Enabling Engine Daemon Authentication",i:0.00419411862683966,a:"You can enable Engine Daemon authentication during Engine installation. This feature is supported only for Authentication Mode, (Admin \u003e User Admin \u003e Authentication), configured as Internal DB or LDAP. Go to Admin \u003e System Admin \u003e Manager Configuration \u003e Engine and Clients and set Daemon ..."},"54":{y:0,u:"../install-guide/Verify_Installation.htm",l:-1,t:"Verify Installation",i:0.000975280246537758,a:"Verify Installation After installing a GridServer Manager and one or more Engines, you can test your installation by submitting a test Service and watching its progress in the GridServer Administration Tool."},"55":{y:0,u:"../install-guide/Submitting_a_Service_Test_.htm",l:-1,t:"Submitting a Service Test ",i:0.000975280246537758,a:" A Service Test can run a Linpack benchmark that you can use as a basic test for your Grid.  To submit a Service Test: Make sure at least one Engine is logged in to your Manager. Log in to the GridServer Administration Tool and go to Services \u003e Services \u003e Service Test. Click Submit to send the ..."},"56":{y:0,u:"../install-guide/Monitoring_a_Service_Test.htm",l:-1,t:"Monitoring a Service Test",i:0.000975280246537758,a:"After you submit the Service Test, you can monitor its progress to ensure that your Engine is taking tasks and returning results. While the Service Test is running, you can also view other pages for more information: Go to Grid Components \u003e Brokers \u003e Broker Admin. A list of available Brokers ..."},"57":{y:0,u:"../install-guide/Troubleshooting.htm",l:-1,t:"Troubleshooting",i:0.000975280246537758,a:"Troubleshooting If the Service Test does not function, or you have other issues relating to your installation, consult the TIBCO GridServer® Administration and online help in the Administration Tool."},"58":{y:0,u:"../install-guide/Uninstalling_GridServer.htm",l:-1,t:"Uninstalling GridServer",i:0.000975280246537758,a:"Uninstalling GridServer This section describes how to uninstall GridServer. The uninstall procedures for the Windows operating system and the UNIX operating system differ."},"59":{y:0,u:"../install-guide/Uninstalling_GridServer_on_Windows_Systems.htm",l:-1,t:"Uninstalling GridServer on Windows Systems",i:0.000975280246537758,a:"Uninstalling an Engine To uninstall an Engine on a Windows system, first ensure that the Engine is stopped and then go to Start \u003e Control Panel \u003e Add/Remove Programs or Start \u003e Control Panel \u003e Programs and Features. Remove the DataSynapse Engine. Follow the onscreen instructions through the ..."},"60":{y:0,u:"../install-guide/Manual_Uninstall.htm",l:-1,t:"Manual Uninstall",i:0.000975280246537758,a:"Uninstall can be done from the command line as follows:  msiexec /x DSEngineInstall.msi or msiexec /quiet /x DSEngineInstall.msi Instead of passing the name of the MSI file to msiexec, you can alternately substitute the Product Code, which is {F80D0E61-23AF-4934-A40B-190F2A1C52CE} for both 32-bit ..."},"61":{y:0,u:"../install-guide/Uninstalling_a_Manager.htm",l:-1,t:"Uninstalling a Manager",i:0.000975280246537758,a:"To uninstall a Manager installed as a service on a Windows system: In Windows, go to Start \u003e Control Panel \u003e Administrative Tools \u003e Services.  Click the Standard tab. Click DataSynapse Manager and click the Stop icon to stop the application. Stopping a Manager installed as a Windows Service Open a ..."},"62":{y:0,u:"../install-guide/Uninstalling_GridServer_on_Unix_Systems.htm",l:-1,t:"Uninstalling GridServer on UNIX Systems",i:0.000975280246537758,a:"To remove a GridServer Manager or Engines on a UNIX system: Stop the Engine or the Broker (engine.sh stop or server.sh stop). Remove any modifications you made to startup files, typically located in /etc/rc.d directories. Remove the DS_INSTALL directory and its contents. "},"63":{y:0,u:"../install-guide/Upgrading_GridServer.htm",l:-1,t:"Upgrading GridServer",i:0.00292342912892519,a:"Upgrading GridServer This section explains how to upgrade GridServer components. It contains a GridServer Upgrade Checklist, which explains what to do before, during, and after your new GridServer installation to ensure carrying over old values to the new installation, when possible. "},"64":{y:0,u:"../install-guide/Requirements_Changes.htm",l:-1,t:"Requirements Changes",i:0.000975280246537758,a:"Requirements Changes See the system requirements in the TIBCO GridServer® readme file to ensure that your software and hardware meet the minimum system requirements. Ensure to review the full list of requirements."},"65":{y:0,u:"../install-guide/GridServer_7_0_Upgrade_Checklist_.htm",l:-1,t:"GridServer 7.1.0 Upgrade Checklist ",i:0.000975280246537758,a:" You can migrate settings from your previous version of GridServer to your new version of a GridServer installation, but it’s important to not install on top of your previous installation. Instead, shut down your old Manager, and rename the old installation directory. You can then install the new ..."},"66":{y:0,u:"../install-guide/Prior_to_Upgrade_.htm",l:-1,t:"Prior to Upgrade ",i:0.000975280246537758,a:" If you have any UNIX Engines that share a common installation directory, you must migrate those installations to a local directory. A shared install point is no longer supported. To enable programmatic version control, ensure that gridLibraryStrictVersioning is set to false. If you have a Linux64 ..."},"67":{y:0,u:"../install-guide/After_Stopping_the_Manager_.htm",l:-1,t:"After Stopping the Manager ",i:0.000975280246537758,a:" When running GridServer as a Windows service, remove the service prior to upgrading. The following steps are necessary only if you set up the system by using an external database: Copy the corresponding database properties file from old  DS_MANAGER/webapps/livecluster/WEB-INF/etc/db/ directory to ..."},"68":{y:0,u:"../install-guide/During_Installation_.htm",l:-1,t:"During Installation ",i:0.000975280246537758,a:"During Installation  For Installation Type, choose Custom, Manager Upgrade. For Previous Data Directory, enter the pathname of your previous base directory."},"69":{y:0,u:"../install-guide/After_Installation.htm",l:-1,t:"After Installation",i:0.000975280246537758,a:"If Using System Classloader for Engines If you are using the system classloader in your Engine configuration and deployed the DSEngine.jar file to Engines, deploy the new DSEngine.jar to Engines after upgrade. This is now deployed in  DS_MANAGER/webapps/livecluster/engineUpdate/shared. If ..."},"70":{y:0,u:"../install-guide/Mixed_Version_Deployments.htm",l:-1,t:"Mixed-Version Deployments",i:0.000975280246537758,a:"Mixed-version deployments are grids that consist of GridServer Manager versions 7.1.0, 7.0.x, and 6.3.1. This is an allowed configuration, as a convenience for large Grids that cannot upgrade all Brokers at once. You must address the following issues when running mixed-version deployments: The ..."},"71":{y:0,u:"../install-guide/Rolling_Upgrades.htm",l:-1,t:"Rolling Upgrades",i:0.000975280246537758,a:"Use the following procedures to install an update to a large grid (a grid with a large number of Engines and several Brokers) in situations where you cannot permit grid-wide Engine restarts and interruptions in Service availability. These instructions enable Services already deployed on components ..."},"72":{y:0,u:"../install-guide/Prerequisite_Actions.htm",l:-1,t:"Prerequisite Actions",i:0.000975280246537758,a:"For all Managers: Bring all Managers up to the required hotfix level. Confirm that all GridServer Managers are at that level. On the Primary Director, you can get the versions of all Brokers on the Grid Components \u003e Brokers \u003e Broker Admin page. To find the version of the Directors, click the About ..."},"73":{y:0,u:"../install-guide/Upgrading_a_Grid.htm",l:-1,t:"Upgrading a Grid",i:0.000975280246537758,a:"Note that each Manager upgrade procedure does not make any modifications to the previous installation. If required, you can use this directory to roll back the upgrade. Primary Director Upgrade Shut down the Primary Director. The Engine Daemons move to the Secondary Director and the Engine Instances ..."},"74":{y:0,u:"../install-guide/Installing_Hotfixes.htm",l:-1,t:"Installing Hotfixes",i:0.000975280246537758,a:"Installing Hotfixes To install or uninstall a hotfix, refer to the installation instructions in the readme file distributed with the hotfix."},"75":{y:0,u:"../install-guide/Securing_Passwords.htm",l:-1,t:"Securing Passwords and Internal.script",i:0.0106362323022667,a:"You can enable or disable  the encryption of the internal database password and the reporting database password stored in the installation.properties file. You can also make the Internal.script file available in an unreadable form. The Grid Server can be installed or upgraded in the GUI installation ..."},"76":{y:0,u:"../install-guide/Configuring_SSL.htm",l:-1,t:"Configuring SSL",i:0.00495661128133887,a:"Configuring SSL This section provides information about configuring SSL to provide secure communication between GridServer components."},"77":{y:0,u:"../install-guide/About_SSL.htm",l:-1,t:"About SSL",i:0.000975280246537758,a:"SSL (Secure Socket Layer) communication can be enabled for communication at each level in the GridServer architecture depending on the security requirements of the organization and the deployment scenarios involved. SSL provides both encryption of messaging between components, and a trust ..."},"78":{y:0,u:"../install-guide/Communication_Overview_.htm",l:-1,t:"Communication Overview ",i:0.000975280246537758,a:" To understand how SSL is used for messaging, it is important to understand how components establish communication channels with each other. For the remainder of this discussion, the terms “client” and “server” are used in the traditional way, that is, a client/server relationship. An example is the ..."},"79":{y:0,u:"../install-guide/Certificate_Overview_.htm",l:-1,t:"Certificate Overview ",i:0.000975280246537758,a:" All SSL clients establish a trust relationship with their server. This is performed with a certificate on the client side, which is a public key that is associated with a private key on the server. When establishing the trust relationship, the server’s certificate must either have been signed by a ..."},"80":{y:0,u:"../install-guide/Key_and_Certificate_Location_and_Generation.htm",l:-1,t:"Key and Certificate Location and Generation",i:0.000975280246537758,a:"Key and Certificate Location and Generation The following is a list of all key and certificate files used by the Servers and Clients."},"81":{y:0,u:"../install-guide/Manager_HTTPS_Configuration.htm",l:-1,t:"Manager HTTPS Configuration",i:0.000975280246537758,a:"The HTTP and HTTPS connections are configured in the Tomcat configuration file,  DS_DATA/conf/server.xml. By default, there are four connector elements: two HTTP elements and two commented out HTTPS elements. On a Manager Install or Reinstall, this file is read; the first element is used as the ..."},"82":{y:0,u:"../install-guide/Configuring_HTTPS.htm",l:-1,t:"Configuring HTTPS",i:0.00136086170542952,a:"The following procedure is used to configure HTTPS: Task A Prepare Certificates   Create a temporary directory (such as /opt/mycerts) and execute the following commands within it. Copy the cacerts file from the JDK to the file ssl.keystore. For JDK8: cp $JAVA_HOME/jre/lib/security/cacerts ..."},"83":{y:0,u:"../install-guide/Driver_HTTPS.htm",l:-1,t:"Driver HTTPS",i:0.00136086170542952,a:"The following files are used for Driver HTTPS: JDriver: ssl.keystore — Includes the self-signed DataSynapse certificate plus CA certs. This is not needed if you are using a CA-signed certificate. The Driver looks for this in the same directory as driver.properties, or you can set this location with ..."},"84":{y:0,u:"../install-guide/Engines_and_Engine_Daemon_HTTPS.htm",l:-1,t:"Engines and Engine Daemon HTTPS",i:0.00136086170542952,a:"To enable Engines and Engine Daemons to trust the Broker: Place the ssl.pem and ssl.keystore files in the DS_DATA/engineUpdate/shared directory. Copy both files to the root directory of each Engine installation. You must copy the ssl.pem and ssl.keystore files by hand to each Engine already ..."},"85":{y:0,u:"../install-guide/Broker_and_Director_SSL.htm",l:-1,t:"Broker and Director SSL",i:0.000975280246537758,a:"The communication between Manager components (such as the connection between Brokers and Directors, and the connection between Primary Director and Secondary Director) can be configured to use SSL. Note that because they use pure sockets for communication, HTTPS does not need to be enabled on the ..."},"86":{y:0,u:"../install-guide/SSL_On_Large_Grids.htm",l:-1,t:"SSL On Large Grids",i:0.000975280246537758,a:"The Apache Tomcat AJP Connector can support many keep-alives (KA); however, the KA timeout is set to a default value of 60 seconds to reduce load on the Manager. This means that any time a new connection is necessary, the client must perform an SSL handshake to establish the HTTPS connections, which ..."},"87":{y:0,u:"../install-guide/Configuring_a_Reporting_Database.htm",l:-1,t:"Configuring a Reporting Database",i:0.00180427637274959,a:"Configuring a Reporting Database The GridServer Manager can use a reporting database to store tables containing statistics for Services, tasks, Engines, and other records."},"88":{y:0,u:"../install-guide/Reporting_Database_Requirements.htm",l:-1,t:"Reporting Database Requirements",i:0.000975280246537758,a:"Reporting Database Requirements To configure a reporting database, you must have a supported third-party database. For a list of supported databases, see the readme file included with GridServer."},"89":{y:0,u:"../install-guide/Configuring_the_Reporting_Database_.htm",l:-1,t:"Configuring the Reporting Database ",i:0.000975280246537758,a:" To configure the reporting database, first install your Manager; second, configure the database; and third, configure the Manager to use the new database. Then, restart the Manager. Install the Manager Install and configure your GridServer Manager. Restart the Manager after completing the ..."},"90":{y:0,u:"../install-guide/Deploying_With_Openshift.htm",l:-1,t:"Deploying With Openshift",i:0.000975280246537758,a:"Deploying With Openshift GridServer supports the use of the OpenShift platform for deployment and management of GridServer components in containers. The GridServer SDK provides example files to deploy Engines in OpenShift."},"91":{y:0,u:"../install-guide/Introduction.htm",l:-1,t:"Introduction",i:0.000975280246537758,a:"Introduction GridServer supports the use of the OpenShift container platform for deployment and management of GridServer components in containers. The GridServer SDK provides example files to deploy Engines in OpenShift. "},"92":{y:0,u:"../install-guide/About_OpenShift.htm",l:-1,t:"About OpenShift",i:0.000975280246537758,a:"OpenShift is an application platform built for running and managing containers using Kubernetes. OpenShift handles application lifecycle management functionality, such as automated building and deployment. Deployment can be run in different models, including products for hosted public cloud, private ..."},"93":{y:0,u:"../install-guide/About_Kubernetes.htm",l:-1,t:"About Kubernetes",i:0.000975280246537758,a:"Kubernetes is an open-source container. It handles the deployment, scaling, and maintenance of Docker containers. OpenShift uses Kubernetes for the container orchestration and management layer of its platform, using Red Hat Enterprise as the container host, and adding the application lifecycle ..."},"94":{y:0,u:"../install-guide/About_the_GridServer_Containerization.htm",l:-1,t:"About the GridServer Containerization",i:0.000975280246537758,a:"The GridServer SDK includes an example Dockerfile which shows how to containerize a GridServer Engine to run in Docker. This enables you to deploy GridServer engines to the Openshift platform. This example is in the SDK in the examples/container/gridserver directory. The Dockerfile is in the engine ..."},"95":{y:0,u:"../install-guide/Deploying_the_GridServer_Engine_Dockerfile_into_OpenShift.htm",l:-1,t:"Deploying the GridServer Engine Dockerfile into OpenShift",i:0.000975280246537758,a:"The following procedure deploys an Engine to the OpenShift environment with the OpenShift CLI using the oc command.  Prerequisites This process assumes you are familiar with OpenShift. See the OpenShift web site at https://www.openshift.com/ for more information. Obtain an OpenShift account and ..."},"96":{y:0,u:"../install-guide/Configuring_Scheduler_Instrumentation.htm",l:-1,t:"Configuring Scheduler Instrumentation",i:0.00649582427838289,a:"The GridServer Manager can use the scheduler_info table, which contains details of GridServer Scheduler operations. Scheduler Instrumentation Requirements To configure a database for Scheduler Instrumentation, you must have a supported third-party database. For a list of supported databases, see the ..."},"97":{y:0,u:"../install-guide/Configuring_Engine_Instrumentation.htm",l:-1,t:"Configuring Engine Instrumentation",i:0.00741591495035708,a:"The GridServer Manager can use the engine_ins table, which contains details of the Engine balancing process. Engine Instrumentation Requirements To configure a database for Engine Instrumentation, you must have a supported third-party database. For a list of supported databases, see the readme file ..."},"98":{y:0,u:"../introduction/GridServer_Overview.htm",l:-1,t:"GridServer Overview",i:0.000975280246537758,a:"GridServer Overview This guide is your complete introduction for learning about TIBCO GridServer® Manager concepts. It includes a complete overview of GridServer fundamentals and is meant to be read first, before installation or development."},"99":{y:0,u:"../introduction/Product_Overview.htm",l:-1,t:"Product Overview",i:0.000975280246537758,a:"GridServer is a highly scalable software infrastructure that allows application services to operate in a virtualized fashion, unattached to specific hardware resources. Client applications submit requests to the Grid environment and GridServer dynamically provisions services to respond to the ..."},"100":{y:0,u:"../introduction/Grid_Services.htm",l:-1,t:"Grid Services",i:0.000975280246537758,a:"The ability to integrate a new technology into a variety of legacy environments is a core requirement of any strategic technology. GridServer offers support for multiple languages and different integration strategies to meet this goal. With GridServer, Grid clients (applications that use the Grid) ..."},"101":{y:0,u:"../introduction/GridServer_Architecture.htm",l:-1,t:"GridServer Architecture",i:0.000975280246537758,a:"DataSynapse GridServer has four different components in its architecture: Grid Clients — The components that submit service requests to the Grid. Also called Drivers. Engines — The processes that host and run services on the Grid nodes. Brokers — The component that provides request queuing, ..."},"102":{y:0,u:"../introduction/Operating_Environment.htm",l:-1,t:"Operating Environment",i:0.000975280246537758,a:"GridServer includes a highly manageable operating environment featuring a web-based console, the GridServer Administration Tool, and a SOAP-based administration interface. Both allow you to deploy Services, manage the workloads running on the Grid, and configure the GridServer environment. The ..."},"103":{y:0,u:"../introduction/GridServer_Services.htm",l:-1,t:"GridServer Services",i:0.00180427637274959,a:"A Service is a self-contained application or business function that is distributed to remote computing resources. A client application makes requests, which are routed by GridServer to those resources, which then return results to the client. One use of a Service is to load balance an application, ..."},"104":{y:0,u:"../introduction/Services.htm",l:-1,t:"Services",i:0.000975280246537758,a:"The Service-Oriented method of defining work in GridServer is a standards-based model. It uses a thin client model, which promotes easy integration of an existing implementation. It also promotes language interoperability, as clients written in different languages can invoke methods in Service ..."},"105":{y:0,u:"../introduction/Clients.htm",l:-1,t:"Clients",i:0.000975280246537758,a:"A Service Session is created on a client for a given named Service Type. The client invokes methods using implementation resources that are distributed on Engines. You can create a Service client in different ways: A client-side API in Java, COM, C++, R, Python, or .NET.  A service proxy of Java or ..."},"106":{y:0,u:"../introduction/Service_Implementation.htm",l:-1,t:"Service Implementation",i:0.000975280246537758,a:"Service Implementations are libraries or executables that are deployed to Engines and that process requests from clients. They process data and return results back to the client. Service Implementations are associated with Service Types by registering them on the Director. When a client makes a ..."},"107":{y:0,u:"../introduction/Service_Session.htm",l:-1,t:"Service Session",i:0.000975280246537758,a:"Service Session A running service is a Service Session. This includes the Service Client, Service Implementation, and Service state on all components. After a client creates a Service and the Service Implementation is running on Engines, this is collectively called the Service Session."},"108":{y:0,u:"../introduction/Service_benefits.htm",l:-1,t:"Service benefits",i:0.000975280246537758,a:"There are many advantages to Services: Cross-language — Client and Service can be in different languages Dynamic — Method names can be determined dynamically, or use generated proxies for type safety Flexible — Use synchronous or asynchronous invocation patterns; can use client proxies generated by ..."},"109":{y:0,u:"../introduction/Binary_level_Integration.htm",l:-1,t:"Binary-level Integration",i:0.000975280246537758,a:"PDriver, or the Parametric Job Driver, is a Driver that executes existing command-line programs as a parallel processing Service using the GridServer environment without using the API, taking full advantage of the parallelism and fault tolerance of GridServer. PDriver achieves parallelism by running ..."},"110":{y:0,u:"../introduction/Managing_Engines.htm",l:-1,t:"Managing Engines",i:0.000975280246537758,a:"Managing Engines This section contains information for managing GridServer Engines. For information about installing Engines, see the TIBCO GridServer® Installation. For information about troubleshooting Engine issues, see\" Diagnosing Engine Issues\" in the TIBCO GridServer® Administration."},"111":{y:0,u:"../introduction/Engine_Routing_and_Balancing_.htm",l:-1,t:"Engine Routing and Balancing ",i:0.000975280246537758,a:" Engines are dynamically allocated resources. They can migrate among Brokers based on criteria such as load and policy. Use the Engine Balancer to manage logins and re-route Engines to maintain an optimal balance across the grid. The Engine Balancer is a component of the Director. The Primary ..."},"112":{y:0,u:"../introduction/Balancing_and_Service_Discriminators.htm",l:-1,t:"Balancing and Service Discriminators",i:0.000975280246537758,a:"When the Director polls Brokers for Engine information, it also collects information about Service discriminators and blacklisted Engines. The Director avoids a situation where Engines are at their home Broker and can’t take Services due to Service discrimination or blacklisting, but also won’t be ..."},"113":{y:0,u:"../introduction/Engine_Weight_Based_Balancer.htm",l:-1,t:"Engine Weight-Based Balancer",i:0.000975280246537758,a:"The Engine weight-based balancer allocates Engines to Brokers based on each Broker’s Engine weight value. This value is the amount of Engines allocated to the Broker relative to the other Brokers’ weights, when all Brokers are idle. The algorithm also considers session load and reallocates idle ..."},"114":{y:0,u:"../introduction/Home_Shared_Balancer.htm",l:-1,t:"Home/Shared Balancer",i:0.000975280246537758,a:"The Home/Shared Engine balancer uses an algorithm in which an Engine has a set of Home Brokers that it always works on while it has outstanding tasks, yet the Engine can be shared to other Brokers when there are no outstanding tasks on any home.  The balancer uses Broker needs and Engine preferences ..."},"115":{y:0,u:"../introduction/Engine_Balancer_Configuration.htm",l:-1,t:"Engine Balancer Configuration",i:0.000975280246537758,a:"Engine Balancer Configuration To configure Engine Balancing on the Director, go to Admin \u003e System Admin \u003e Manager Configuration \u003e Engines and Clients, and change the following properties:  These settings must be identical on all Directors."},"116":{y:0,u:"../introduction/Engine_Upper_and_Lower_Bounds.htm",l:-1,t:"Engine Upper and Lower Bounds",i:0.000975280246537758,a:"You can configure upper and lower bounds on the number of Engines that can be logged in at a given time. Set these upper and lower bounds on the Grid Components \u003e Brokers \u003e Broker Admin page. If the columns for bounds are hidden, add them using the Column control. The minimum value specifies that ..."},"117":{y:0,u:"../introduction/Failover_Brokers.htm",l:-1,t:"Failover Brokers",i:0.000975280246537758,a:"A Failover Broker temporarily takes over executing Service Sessions when the Client has no other Brokers to which it is permitted to connect. From the Client perspective, Failover Brokers become part of the pool of active Brokers when there are no other non-Failover Brokers on which the client is ..."},"118":{y:0,u:"../introduction/Example_Use_Cases.htm",l:-1,t:"Example Use Cases",i:0.000975280246537758,a:"Example Use Cases This section describes example use cases of client routing and load balancing."},"119":{y:0,u:"../introduction/N_1_Failover_with_Weighting.htm",l:-1,t:"N+1 Failover with Weighting",i:0.000975280246537758,a:"An organization has four groups using all available Engines in a grid. One group has a guaranteed allocation of at least half of the grid any time it needs it, and the other three groups share the remaining Engines.  Brokers  Set up five Brokers. Each group gets a Broker, plus one is used for ..."},"120":{y:0,u:"../introduction/Engine_Localization_with_Sharing_.htm",l:-1,t:"Engine Localization with Sharing ",i:0.000975280246537758,a:" A company has two groups, one in New York and one in London. Each has a single middleware application that has a Driver that connects to its own Broker. Each group also has a set of CPUs that it expects to always be working on their own calculations. However, there are times when one group’s Broker ..."},"121":{y:0,u:"../introduction/Engine_Configuration.htm",l:-1,t:"Engine Configuration",i:0.000975280246537758,a:"Engine and Engine Daemon behaviors are controlled by a centralized profile called an Engine Configuration. When new Engine Daemons are installed, they use the default Engine Configuration for their platform (Windows, Linux, Solaris, or other supported platforms.) Individual Engine instances take the ..."},"122":{y:0,u:"../introduction/Editing_an_Engine_Configuration.htm",l:-1,t:"Editing an Engine Configuration",i:0.000975280246537758,a:"To change an Engine’s settings (for example, to point it to a new Director), you edit the Engine Configuration used by the Engine. Settings change on all Engines using that Configuration. To change values in an Engine Configuration: In the GridServer Administration Tool, go to Grid Components \u003e ..."},"123":{y:0,u:"../introduction/Creating_a_New_Engine_Configuration.htm",l:-1,t:"Creating a New Engine Configuration",i:0.000975280246537758,a:"In some situations, you might need a subset of Engines to behave differently than other Engines on your grid. For example, you might want a large group of Engines to report to a different Director, or use a different compiler runtime. Instead of individually configuring each Engine, you can create a ..."},"124":{y:0,u:"../introduction/Copying_an_Engine_Configuration.htm",l:-1,t:"Copying an Engine Configuration",i:0.000975280246537758,a:"In a situation where you need several similar Engine Configurations, it’s often faster to make a copy of an existing Engine Configuration, rather than creating many individual Configurations. To copy an existing Engine Configuration: Go to Grid Components \u003e Engines \u003e Engine Configurations. Select an ..."},"125":{y:0,u:"../introduction/Setting_the_Engine_Configuration_Used_by_Engines.htm",l:-1,t:"Setting the Engine Configuration Used by Engines",i:0.000975280246537758,a:"To change the Engine Configuration of an Engine Daemon:   Go to Grid Components \u003e Engines \u003e Daemon Admin. In the Configuration column, select an Engine Configuration from the list next to an Engine Daemon. To change a large number of Engine Daemons’ Configuration at once:   Go to Grid Components \u003e ..."},"126":{y:0,u:"../introduction/Setting_the_Director_Used_by_Engines.htm",l:-1,t:"Setting the Director Used by Engines",i:0.000975280246537758,a:"The Primary and Secondary Directors for an Engine is set during Engine installation. You can later change the Directors to which an Engine reports, by changing the Engine Configuration used by the Engine. To configure an Engine’s Directors: Go to Grid Components \u003e Engines \u003e Engine Configurations. ..."},"127":{y:0,u:"../introduction/Configuring_Engines_With_Multiple_Network_Adapters.htm",l:-1,t:"Configuring Engines With Multiple Network Adapters",i:0.000975280246537758,a:"In some network configurations, the host running an Engine can have more than one physical or logical network interface. When the Engine starts, it checks what IP address is in use and uses it to advertise its file server location. In cases where there is more than one network interface, it\u0027s ..."},"128":{y:0,u:"../introduction/Configuring_Engine_Daemons_to_Use_SNAT.htm",l:-1,t:"Configuring Engine Daemons to Use SNAT",i:0.000975280246537758,a:"You can configure Engine Daemons for use on the other side of a NAT from the Manager and Drivers. To do this, set the environment variable DS_USE_SNAT_IP_ADDRESS on an Engine Daemon to the IP address that you want it to report to the Manager and all Drivers as its address. Additionally, you must set ..."},"129":{y:0,u:"../introduction/Using_the_System_Classloader_on_an_Engine.htm",l:-1,t:"Using the System Classloader on an Engine",i:0.000975280246537758,a:"In most situations, the default classloader is used to load client classes. In some instances however, some applications might require the use of the system classloader. This requires deploying extra files to enable the Engine to use the system classloader. To use the system classloader: Copy the  ..."},"130":{y:0,u:"../introduction/Configuring_a_Global_Shared_Grid_Library_Directory.htm",l:-1,t:"Configuring a Global Shared Grid Library Directory",i:0.000975280246537758,a:"You can configure Engines to use a shared directory for Grid Libraries instead of Engines downloading their own copies. To configure a global shared Grid Library directory: Disable Engine synchronization on the Admin \u003e System Admin \u003e Manager Configuration \u003e Resource Deployment page.  On the Grid ..."},"131":{y:0,u:"../introduction/Configuring_When_Engines_Run.htm",l:-1,t:"Configuring When Engines Run",i:0.000975280246537758,a:"You can configure GridServer to avoid conflicts between work and regular use of the machine. This is called adaptive scheduling, which you configure to adapt the Engine’s activity level to your computing environment. The following section describes the methods used to configure when an Engine Daemon ..."},"132":{y:0,u:"../introduction/Manual_Mode.htm",l:-1,t:"Manual Mode",i:0.000975280246537758,a:"When Manual Mode is enabled in an Engine Configuration, the Engine Daemon runs at all times. This is the default. You can change an individual Engine Daemon to auto mode, or clear the Enabled option under Manual Mode in the Engine Configuration page to switch all Engines using that configuration to ..."},"133":{y:0,u:"../introduction/Auto_Mode.htm",l:-1,t:"Auto Mode",i:0.000975280246537758,a:"Auto Mode lets you specify if Engines run on a computer, based on its utilization. For example, you might not want to run Engines when someone is logged in to the computer, or if its CPU utilization is above a certain percentage. For Windows Engines, there are two methods for determining ..."},"134":{y:0,u:"../introduction/Configuring_How_Many_Engines_Run.htm",l:-1,t:"Configuring How Many Engines Run",i:0.000975280246537758,a:"There are three settings in the Engine configuration that determine how many Engine instances an Engine Daemon can run. The SMP Enabled property specifies if the Engine configuration starts an Engine instance per processor core on the machine. This is set to True by default. Specifically, when SMP ..."},"135":{y:0,u:"../introduction/Running_Engines_in_Multiplexed_Mode.htm",l:-1,t:"Running Engines in Multiplexed Mode",i:0.000975280246537758,a:"On machines with multi-core processors, GridServer, by default, runs an Engine instance in its own process per logical CPU. While this enables each process to work on different Services, it also means each process runs in its own JVM, and requires its own set of application data. This can cause ..."},"136":{y:0,u:"../introduction/Communication_and_Task_Scheduling.htm",l:-1,t:"Communication and Task Scheduling",i:0.000975280246537758,a:"When Engines are configured as multiplexed, communication with the Broker is multiplexed over a single HTTP keep-alive session to reduce overhead. Also, only one heartbeat is communicated per process. Heartbeats are received by Engine instance zero and simulated to the other Engine Proxies.  To ..."},"137":{y:0,u:"../introduction/Configuration.htm",l:-1,t:"Configuration",i:0.000975280246537758,a:"To enable multiplexed mode, set the Multiplexed Mode property to true in the Engine configuration. The default value is false. To set the lease time, go to Admin \u003e System Admin \u003e Manager Configuration \u003e Services, and set the value of the Multiplexed Engine Lease property. The default time is one ..."},"138":{y:0,u:"../introduction/Configuring_64_bit_Engine_Daemons_to_run_32_bit_Services.htm",l:-1,t:"Configuring 64-bit Engine Daemons to run 32-bit Services",i:0.000975280246537758,a:"Configuring 64-bit Engine Daemons to run 32-bit Services The 64-bit Windows Engine Daemon can be configured to allow execution of 32-bit Services. If allowed, when an Engine takes such a task, it restarts, clearing all existing loaded libraries, and restarts as a 32-bit process."},"139":{y:0,u:"../introduction/Configuration_1.htm",l:-1,t:"Configuration",i:0.000975280246537758,a:"On the Windows Engine Configuration page, there is a setting called Additional Platforms under Classes, Libraries, and Paths. It is a list with two values, None and win32. By default it is None. Setting it to win32 on a Windows 64-bit configuration enables the behavior; setting it on a Windows ..."},"140":{y:0,u:"../introduction/Specifying_that_a_Service_is_win32.htm",l:-1,t:"Specifying that a Service is win32",i:0.000975280246537758,a:"Specifying that a Service is win32 Any Service for which the root Grid Library is marked as os=\"win32\" is considered to be a win32 Service. If a Service\u0027s root Grid Library is not marked as such, the Engine remains 64-bit and fails. "},"141":{y:0,u:"../introduction/Routing_32_bit_Tasks_to_64_bit_Engines.htm",l:-1,t:"Routing 32-bit Tasks to 64-bit Engines",i:0.000975280246537758,a:"By virtue of the Engine having the 32-bit Grid Library, they by default are allowed to run such Services by the scheduler. Note that existing applications might not use the OS attribute on the root Grid Library; rather they might use discrimination instead to route Services to win32 Engines. If you ..."},"142":{y:0,u:"../introduction/Configuring_a_Caching_HTTP_Proxy_Server.htm",l:-1,t:"Configuring a Caching HTTP Proxy Server",i:0.000975280246537758,a:"In a GridServer deployment where a Broker and its Engines are separated by a WAN, it can be inefficient to transfer the same data over the WAN to multiple Engines from the Broker or the Clients. One solution is to use an HTTP proxy server (such as Squid Web Cache) to cache the session’s init data, ..."},"143":{y:0,u:"../introduction/Configuring_an_External_Engine_Daemon_Admin_Tool.htm",l:-1,t:"Configuring an External Engine Daemon Admin Tool",i:0.000975280246537758,a:"It is possible to configure an external administration or management tool or system that can be opened from GridServer’s Administration Tool. When configured, you can open the tool from the Engine Daemon Admin page with an item in the Actions control. Selecting the new item opens a URL to the ..."},"144":{y:0,u:"../introduction/Quarantine_Brokers.htm",l:-1,t:"Quarantine Brokers",i:0.000975280246537758,a:"In a security-oriented environment, it can be necessary to prevent new or untrusted Engines from joining a grid and downloading potentially sensitive application data or resources until the GridServer administrator explicitly grants permission for them to join. You can exercise this control by using ..."},"145":{y:0,u:"../introduction/Quarantine_Broker_Concepts.htm",l:-1,t:"Quarantine Broker Concepts",i:0.000975280246537758,a:"To use a Quarantine Broker, there are two components: the Quarantine Broker, and a method to Set Quarantine (send Engine Daemons to the Quarantine Broker) and Clear Quarantine (change Engine Daemon status to allow Engine Daemons to log onto production Brokers.) The Quarantine Broker is specified on ..."},"146":{y:0,u:"../introduction/Quarantine_Status_on_Engines.htm",l:-1,t:"Quarantine Status on Engines",i:0.000975280246537758,a:"The Director determines if an Engine is quarantined by looking for an Engine property called QuarantineStatus. The QuarantineStatus property value is set to “New Engine” on all newly installed Engines. This ensures that all new Engines are quarantined upon installation when there is a quarantine ..."},"147":{y:0,u:"../introduction/Requirements.htm",l:-1,t:"Requirements",i:0.000975280246537758,a:"All Directors require the same Quarantine Broker setting. When failover is configured, this means the Secondary Director has the same Quarantine Broker configuration if the Primary Director fails. Although a grid might have multiple Brokers, either for redundancy or volume, you can only define one ..."},"148":{y:0,u:"../introduction/Configuring_a_Quarantine_Broker.htm",l:-1,t:"Configuring a Quarantine Broker",i:0.000975280246537758,a:"To add a Quarantine Broker: Install an additional Broker, if you don’t already have an extra one installed. Determine the name of the Broker you wish to use. Broker names are automatically given at installation, and are typically numeric. In the GridServer Administration Tool, Grid Components \u003e ..."},"149":{y:0,u:"../introduction/Setting_Quarantine_Status_on_Engines.htm",l:-1,t:"Setting Quarantine Status on Engines",i:0.000975280246537758,a:"There are two ways to set and clear quarantine status: interactively with the GridServer Administration Tool, or programmatically with the GridServer Admin API. You can also use the API to self-quarantine Engines. Each method is described below. Also, the following constraints apply when setting ..."},"150":{y:0,u:"../introduction/Quarantine_Broker_Constraints.htm",l:-1,t:"Quarantine Broker Constraints",i:0.000975280246537758,a:"There is no finer configuration to direct Engine instances to specific Brokers using this feature.  Due to the fact that there is only one quarantine Broker defined in a grid, several issues might arise as a result: Quarantined Engines that don’t collocate with the quarantine Broker need to send ..."},"151":{y:0,u:"../introduction/Inside_the_GridServer_Director.htm",l:-1,t:"Inside the GridServer Director",i:0.000975280246537758,a:"Inside the GridServer Director The GridServer Director is part of a GridServer Manager, the controlling mechanism of the Grid. Directors route Engines and Drivers to Brokers, and manage Bro-kers and Engine Daemons. Directors balance the load among their Brokers and provide Broker fault tolerance."},"152":{y:0,u:"../introduction/Director_Roles.htm",l:-1,t:"Director Roles",i:0.000975280246537758,a:"Director Roles The Director is responsible for three basic roles: routing, authentication, and load balancing."},"153":{y:0,u:"../introduction/Routing.htm",l:-1,t:"Routing",i:0.000975280246537758,a:"One of the GridServer Director’s important roles within the Manager is to serve as the routing component. Both Engines and Clients log in via the Director, and the Director routes them to the appropriate Brokers. Engines and Grid Clients log in to the Director and are authenticated; the Director ..."},"154":{y:0,u:"../introduction/Authentication.htm",l:-1,t:"Authentication",i:0.000975280246537758,a:"Authentication The Director, as part of routing, handles Client authentication."},"155":{y:0,u:"../introduction/Load_Balancing.htm",l:-1,t:"Load Balancing",i:0.000975280246537758,a:"Because Directors take a central role with both Client and Engine traffic, they are a key object in configuring the load balancing of components. Directors allocate Clients and Engines to available Brokers. The default policy for load balancing by Directors is by relative weight; essentially, a ..."},"156":{y:0,u:"../introduction/Configuration_Management.htm",l:-1,t:"Configuration Management",i:0.000975280246537758,a:"Configuration Management The Director is used to configure many settings of a GridServer Manager, including users and passwords, Driver profiles, routing properties, and Engine configurations. These settings are configured with the web-based GridServer Administration Tool."},"157":{y:0,u:"../introduction/Database_Management.htm",l:-1,t:"Database Management",i:0.000975280246537758,a:"GridServer can use an external reporting database to store data such as User, Engine, Driver, and Broker information. The reporting database is an enterprise-grade JDBC database that you provide that is used to log events and statistics. The configuration of the database used is changed on the ..."},"158":{y:0,u:"../introduction/Resource_Management.htm",l:-1,t:"Resource Management",i:0.000975280246537758,a:"Service Deployment files that are used by Engines are centrally managed, starting at the Director. The resources centrally located on the Director are then synchronized to Brokers, which then synchronize them with Engines. Resources are distributed with Grid Libraries. A Grid Library is an archive ..."},"159":{y:0,u:"../introduction/Inside_the_Broker.htm",l:-1,t:"Inside the Broker",i:0.000975280246537758,a:"Inside the Broker The GridServer Broker, like the Director, is an integral part of a GridServer Manager. Brokers schedule work requests from Drivers to Engines, and manage both types of components to ensure service and return results."},"160":{y:0,u:"../introduction/Broker_Roles.htm",l:-1,t:"Broker Roles",i:0.000975280246537758,a:"Broker Roles A Broker’s role includes scheduling, Engine and Driver management, communication, and resource management. Brokers manage Engines and Drivers, and schedule work with lightweight messages. Drivers and Engines exchange work data directly when using Direct Data Transfer."},"161":{y:0,u:"../introduction/Scheduling.htm",l:-1,t:"Scheduling",i:0.000975280246537758,a:"Brokers schedule tasks submitted by Drivers onto available Engines. To determine the scheduling of tasks to Engines, Brokers take into consideration Engine state and Service priority.  The Engine state is based on whether that Engine has loaded Grid Libraries needed by that Service, and whether that ..."},"162":{y:0,u:"../introduction/Engine_and_Driver_Management.htm",l:-1,t:"Engine and Driver Management",i:0.000975280246537758,a:"Although authentication and assignment of Engines and Drivers is handled by the Director, the Broker manages clients through the remainder of their life cycle. This involves determining the availability of clients by monitoring their connections, and coordinating these results with the scheduling ..."},"163":{y:0,u:"../introduction/Communication.htm",l:-1,t:"Communication",i:0.000975280246537758,a:"The GridServer architecture combines the central control of a hub and spoke architecture with the efficient communication of a peer-to-peer architecture. This is made possible by the flexibility in configuring communication between the Broker, Engines, and Drivers. Engines and Drivers communicate ..."},"164":{y:0,u:"../introduction/Resource_Management_1.htm",l:-1,t:"Resource Management",i:0.000975280246537758,a:"Resource Management Brokers maintain a copy of deployed resources from the Primary Director, and Engines synchronize these resources from the Broker."},"165":{y:0,u:"../introduction/Inside_GridServer_Topology.htm",l:-1,t:"Inside GridServer Topology",i:0.000975280246537758,a:"The GridServer Manager loosely consists of two entities: the GridServer Director and the GridServer Broker: A minimal configuration of DataSynapse GridServer consists of a single Manager configured with a Primary Director and a single Broker. Additional Brokers or Directors can be added to address ..."},"166":{y:0,u:"../introduction/Redundancy.htm",l:-1,t:"Redundancy",i:0.000975280246537758,a:"Given a minimal configuration of a single Director and single Broker, Engines, and Drivers log in to the Director, but failure of the Director (such as in the case of hardware or network failure) means a Driver or Engine not logged in, is no longer able to establish a connection. To prevent this, ..."},"167":{y:0,u:"../introduction/Volume.htm",l:-1,t:"Volume",i:0.000975280246537758,a:"Volume In larger Grids, the volume of Engines in the Grid might require more capability than offered by a single Broker. To distribute load, additional Brokers are added to other Managers at installation. For example, the figure below shows a two Manager system with two Brokers"},"168":{y:0,u:"../introduction/Topography.htm",l:-1,t:"Topography",i:0.000975280246537758,a:"Several other factors might influence how you integrate DataSynapse GridServer with your computing environment. These include: Instead of using one Grid for all types of Services, you might wish to divide different subsets of Services (for example, by size or priority) to different Brokers. Your ..."},"169":{y:0,u:"../introduction/Direct_Data_Transfer.htm",l:-1,t:"Direct Data Transfer",i:0.000975280246537758,a:"By default, GridServer uses Direct Data Transfer, or peer-to-peer communication, to optimize data throughput between Drivers and Engines. Without Direct Data Transfer, all task inputs and outputs must be sent through the Manager. Sending the inputs and outputs through the Manager results in higher ..."},"170":{y:0,u:"../introduction/GridCache.htm",l:-1,t:"GridCache",i:0.000975280246537758,a:"GridCache This section provides information about using GridCache, a dynamically updateable distributed object cache that any GridServer Driver or Engine can use to store data for later retrieval by other GridServer components."},"171":{y:0,u:"../introduction/Overview.htm",l:-1,t:"Overview",i:0.000975280246537758,a:"You can dynamically update GridCache. It is a distributed object cache that any GridServer Driver or Engine can use to store data for later retrieval by other GridServer components. While GridServer extensively uses object caches internally, applications can access the GridCache object cache ..."},"172":{y:0,u:"../introduction/General_Capabilities.htm",l:-1,t:"General Capabilities",i:0.000975280246537758,a:"GridCache is a general distributed cache that provides a consistent view of data to all clients (Drivers and Engines) in the Grid. Data resides in unique regions of the cache. Data can be serializable Java objects, .NET objects, strings, and byte arrays for C++. The global cache of data can be ..."},"173":{y:0,u:"../introduction/API.htm",l:-1,t:"API",i:0.000975280246537758,a:"You can access GridCache through a client API available on Drivers and Engines. The API follows the JCache specification where appropriate. The API is available in Java, .NET, and C++, and provides cross-platform access to data where appropriate. That is, C++ and Java applications can share XML ..."},});