public ExternalDigitalAsset createAsset(ExternalUploadAssetRequest request)
{
	ExternalDigitalAsset asset = new ExternalDigitalAsset();
	File googleFile = new File();
	FileResource fileResource = request.getFileResource();
	String fileName = fileResource.getFile().getName();
	googleFile.setName(fileName);
	FileContent mediaContent = new FileContent(
		new MimetypesFileTypeMap().getContentType(fileName),
		fileResource.getFile());
	try
	{
		File googleFileUploaded = this.googleDrive.files()
			.create(googleFile, mediaContent)
			.setFields("*")
			.execute();
		asset.setId(googleFileUploaded.getId());
		asset.setPhysicalName(googleFileUploaded.getOriginalFilename());
		asset.setThumbnailURL(googleFileUploaded.getThumbnailLink());
		asset.setLabelDescription(
			this.getLabelDescription(
				googleFileUploaded.getName(),
				request.getHome().getRepository().getLocales()));
	}
	catch (IOException ex)
	{
		throw new RuntimeException(ex);
	}

	return asset;
}