public ExternalDigitalAsset getAsset(ExternalSingularRequest request) throws DAMException
{
	ExternalDigitalAsset digitalAsset = new ExternalDigitalAsset();
	try
	{
		File file = this.googleDrive.files()
			.get(request.getExternalId())
			.setFields("*")
			.execute();
		String urlDownload = this
			.getUrl(file.getId(), file.getName(), file.getFileExtension(), true);
		String previewUrl = this
			.getUrl(file.getId(), file.getName(), file.getFileExtension(), false);
		digitalAsset.setId(file.getId());
		digitalAsset.setPhysicalName(file.getOriginalFilename());
		digitalAsset.setLabelDescription(
			this.getLabelDescription(
				file.getName(),
				request.getHome().getRepository().getLocales()));
		digitalAsset.setURL(previewUrl);

		boolean isImage = DigitalAssetExtension.parseExtension(file.getFileExtension())
			.getDigitalAssetContentType()
			.isImage();
		if (isImage)
		{
			digitalAsset.setThumbnailURL((previewUrl));
		}
		else
		{
			digitalAsset.setThumbnailURL(file.getThumbnailLink());
		}
		digitalAsset.setDownloadURL(urlDownload);
		digitalAsset.setAssetType(file.getFileExtension());
		digitalAsset.setExtension(file.getFileExtension());
		digitalAsset.setCreationDate(new Date(file.getCreatedTime().getValue()));
		digitalAsset.setLastUpdatedDate(new Date(file.getModifiedTime().getValue()));
		digitalAsset.setFileSize(new BigDecimal(file.getSize().longValue()));
		Map<String, String> metaDataMap = new HashMap<>();
		metaDataMap.put("mKey1", "mValue1");
		metaDataMap.put("mKey2", "mValue2");
		digitalAsset.setMetaDatas(metaDataMap);
		digitalAsset.setWidth(new Integer(300));
		digitalAsset.setHeight(new Integer(200));
	}
	catch (IOException ex)
	{
		throw new DAMException(ex);
	}

	return digitalAsset;
}

public List<ExternalDigitalAsset> getAssets(ExternalPluralRequest externalRequest)
{
	List<ExternalDigitalAsset> externalAssets = new ArrayList<>();
	for (String externalId : externalRequest.getExternalIds())
	{
		try
		{
			File file;
			try
			{
				file = this.googleDrive.files().get(externalId).setFields("*").execute();
			}
			catch (Exception ex)
			{
				continue;
			}

			ExternalDigitalAsset externalDigitalAsset = new ExternalDigitalAsset();
			externalDigitalAsset.setId(file.getId());
			externalDigitalAsset.setPhysicalName(file.getOriginalFilename());
			externalDigitalAsset.setCreationDate(new Date(file.getCreatedTime().getValue()));
			externalDigitalAsset
				.setLastUpdatedDate(new Date(file.getModifiedTime().getValue()));
			externalDigitalAsset.setLabelDescription(
				this.getLabelDescription(
					file.getName(),
					externalRequest.getHome().getRepository().getLocales()));
			String urlDownload = this
				.getUrl(file.getId(), file.getName(), file.getFileExtension(), true);
			String previewUrl = this
				.getUrl(file.getId(), file.getName(), file.getFileExtension(), false);
			externalDigitalAsset.setURL(previewUrl);
			externalDigitalAsset.setThumbnailURL(file.getThumbnailLink());
			externalDigitalAsset.setWidth(new Integer(300));
			externalDigitalAsset.setHeight(new Integer(200));
			externalDigitalAsset.setDownloadURL(urlDownload);
			externalDigitalAsset.setAssetType(file.getFileExtension());
			externalDigitalAsset.setExtension(file.getFileExtension());

			Map<String, String> metaDatas = new HashMap<>();
			metaDatas.put("metadata1", "metadata1");
			metaDatas.put("metadata2", "metadata2");
			externalDigitalAsset.setMetaDatas(metaDatas);

			externalDigitalAsset.setTags(Arrays.asList("tag1", "tag2"));

			externalAssets.add(externalDigitalAsset);
		}
		catch (IOException ex)
		{
			throw new RuntimeException(ex);
		}
	}

	return externalAssets;
}