public class MyContainsAlgorithm extends SearchDistance
{

	public MyContainsAlgorithm(SchemaNode schemaNode, Locale locale)

	{
		super(schemaNode, locale);
	}

	@Override
	public float getDistance(String keyword, String text)
	{
		if (text.contains(keyword))
		{
			return 100f;
		}
		return 0;
	}

	@Override
	public boolean isNumericSupported()
	{
		return false;
	}

	@Override
	public boolean isFullTableScanRequired()
	{
		return true;
	}

	@Override
	public SearchComparator cloneMatching(SchemaNode newNode)
	{
		return new MyContainsAlgorithm(newNode, this.getLocale());
	}

}
