import java.io.*;
import java.math.*;
import java.net.*;
import java.util.*;

import javax.activation.*;

import com.onwbp.base.text.bean.*;
import com.orchestranetworks.addon.dama.*;
import com.orchestranetworks.addon.dama.common.*;
import com.orchestranetworks.addon.dama.ext.bean.*;
import com.orchestranetworks.addon.dama.ext.exception.*;
import com.orchestranetworks.addon.dama.ext.exception.DAMException;
import com.orchestranetworks.addon.dama.ext.resource.*;
import com.orchestranetworks.addon.dama.externalmanagement.*;
import com.orchestranetworks.addon.dama.externalmanagement.bean.*;
import com.orchestranetworks.addon.dama.externalmanagement.request.*;
import com.orchestranetworks.addon.dama.externalmanagement.response.*;
import com.orchestranetworks.addon.dama.models.*;
import com.orchestranetworks.addon.utils.*;

/**
 */
public class ExternalGoogleManager implements ExternalManager
{
	//Instance variable to access the helper class for the Google Drive
	private Drive googleDrive;

	public ExternalGoogleManager()
	{
		try
		{
			this.googleDrive = GoogleDriveAPIHelper.getInstance().getDriveService();
		}
		catch (Exception ex)
		{
			throw new RuntimeException(ex);
		}
	}
	
	//Sample method used to pass asset URL information to other methods
	private String getUrl(String externalId, String fileName, String extension, boolean isDownload)
		throws UnsupportedEncodingException
	{
		//The network location where EBX is running
		String host = "localhost:8080";

		String providerLink = "http://" + host
			+ "/<your module name>/<your service dispatcher>?service=<your service name>";
		StringBuilder urlDownload = new StringBuilder(providerLink);
		urlDownload.append("&amp;external_id=").append(URLEncoder.encode(externalId, "UTF-8"));
		urlDownload.append("&amp;fileName=")
			.append(URLEncoder.encode(this.getFileName(fileName, extension), "UTF-8"));
		urlDownload.append("&amp;extension=").append(extension);
		if (isDownload)
		{
			urlDownload.append("&amp;download=").append(Boolean.TRUE.toString());
		}

		return urlDownload.toString();
	}

	private LabelDescription getLabelDescription(String name, List<Locale> locales)
	{
		if (AddonStringUtils.isEmpty(name))
		{
			name = DAMConstants.EMPTY_STRING;
		}

		List<LabelDescriptionForLocale> labelDescriptionForLocales = new ArrayList<>();
		for (Locale locale : locales)
		{
			LabelDescriptionForLocale labelDesLocale = new LabelDescriptionForLocale();
			labelDesLocale.setLocale(locale);
			labelDesLocale.setLabel(name);
			labelDesLocale.setDescription(name);
			labelDescriptionForLocales.add(labelDesLocale);
		}

		LabelDescription labelDescription = new LabelDescription();
		labelDescription.setLocalizedDocumentations(labelDescriptionForLocales);

		return labelDescription;
	}
}