import java.io.*;
import java.math.*;
import java.net.*;
import java.util.*;

import javax.activation.*;

import com.google.api.client.http.*;
import com.google.api.services.drive.*;
import com.google.api.services.drive.Drive.*;
import com.google.api.services.drive.model.*;
import com.google.api.services.drive.model.File;
import com.onwbp.base.text.bean.*;
import com.orchestranetworks.addon.dama.*;
import com.orchestranetworks.addon.dama.common.*;
import com.orchestranetworks.addon.dama.ext.bean.SearchFilter;
import com.orchestranetworks.addon.dama.ext.exception.DAMException;
import com.orchestranetworks.addon.dama.ext.exception.OperationExecutionStatus;
import com.orchestranetworks.addon.dama.ext.resource.*;
import com.orchestranetworks.addon.dama.externalmanagement.*;
import com.orchestranetworks.addon.dama.externalmanagement.bean.*;
import com.orchestranetworks.addon.dama.externalmanagement.request.*;
import com.orchestranetworks.addon.dama.externalmanagement.response.*;
import com.orchestranetworks.addon.dama.models.*;
import com.orchestranetworks.addon.utils.*;

public final class ExternalGoogleManager implements ExternalManager
{
	//Instance variable to access the helper class for the Google Drive
	private Drive googleDrive;

	public ExternalGoogleManager()
	{
		try
		{
			this.googleDrive = GoogleDriveAPIHelper.getInstance().getDriveService();
		}
		catch (Exception ex)
		{
			throw new RuntimeException(ex);
		}
	}

	//Defines the search filter 
	public ExternalSearchAssetsResult searchAssets(ExternalSearchRequest searchRequest)
	{
		ExternalSearchAssetsResult result = new ExternalSearchAssetsResult();
		SearchFilter searchFilter = searchRequest.getSearchFilter();
		String keyword = (searchFilter == null) ? DAMConstants.EMPTY_STRING
			: searchFilter.getKeyword();
		try
		{
			FileList fileList = this.googleDrive.files().list().setFields("*").execute();
			List<File> allFiles = fileList.getFiles();
			List<File> filteredFiles = new ArrayList<>();

			for (File file : allFiles)
			{
				if (AddonStringUtils.isEmpty(keyword))
				{
					filteredFiles.add(file);
				}
				else
				{
					if (file.getName().contains(keyword)
						|| file.getOriginalFilename().contains(keyword))
					{
						filteredFiles.add(file);
					}
				}
			}
			int size = filteredFiles.size();
			int pageIndex = (searchRequest.getPageIndex() < 1) ? 1 : searchRequest.getPageIndex();
			int pageSize = (searchRequest.getPageSize() < 10) ? 10 : searchRequest.getPageSize();
			int startIndex = (pageIndex - 1) * pageSize;
			int endIndex = startIndex + pageSize - 1;
			if (endIndex > size - 1)
			{
				endIndex = size - 1;
			}

			List<ExternalDigitalAsset> externalAssets = new ArrayList<>();
			for (int i = startIndex; i <= endIndex; i++)
			{
				File googleFile = filteredFiles.get(i);
				String downloadUrl = this.getUrl(
					googleFile.getId(),
					googleFile.getName(),
					googleFile.getFileExtension(),
					true);
				String previewUrl = this.getUrl(
					googleFile.getId(),
					googleFile.getName(),
					googleFile.getFileExtension(),
					false);
				ExternalDigitalAsset externalAsset = new ExternalDigitalAsset();
				externalAsset.setLabelDescription(
					this.getLabelDescription(
						googleFile.getName(),
						searchRequest.getHome().getRepository().getLocales()));
				externalAsset.setURL(previewUrl);
				externalAsset.setThumbnailURL(googleFile.getThumbnailLink());
				externalAsset.setDownloadURL(downloadUrl);
				externalAsset.setExtension(googleFile.getFileExtension());
				externalAsset.setAssetType(googleFile.getFileExtension());
				externalAsset.setId(googleFile.getId());
				externalAsset.setPhysicalName(googleFile.getName());
				externalAsset.setCreationDate(new Date(googleFile.getCreatedTime().getValue()));
				externalAsset.setLastUpdatedDate(new Date(googleFile.getModifiedTime().getValue()));
				externalAsset.setFileSize(new BigDecimal(googleFile.getSize().longValue()));
				Map<String, String> metaDataMap = new HashMap<>();
				metaDataMap.put("mKey1", "mValue1");
				metaDataMap.put("mKey2", "mValue2");
				externalAsset.setMetaDatas(metaDataMap);
				this.buildWidthHeight(externalAsset, googleFile);

				externalAssets.add(externalAsset);
			}

			result.setAssets(externalAssets);
		}
		catch (Exception ex)
		{
			throw new RuntimeException(ex);
		}

		return result;
	}

	//Defines how assets are created or uploaded to the external storage location
	public ExternalDigitalAsset createAsset(ExternalUploadAssetRequest request)
	{
		ExternalDigitalAsset asset = new ExternalDigitalAsset();
		File googleFile = new File();
		FileResource fileResource = request.getFileResource();
		String fileName = fileResource.getFile().getName();
		googleFile.setName(fileName);
		FileContent mediaContent = new FileContent(
			new MimetypesFileTypeMap().getContentType(fileName),
			fileResource.getFile());
		try
		{
			File googleFileUploaded = this.googleDrive.files()
				.create(googleFile, mediaContent)
				.setFields("*")
				.execute();
			asset.setId(googleFileUploaded.getId());
			asset.setPhysicalName(googleFileUploaded.getOriginalFilename());
			asset.setThumbnailURL(googleFileUploaded.getThumbnailLink());
			asset.setLabelDescription(
				this.getLabelDescription(
					googleFileUploaded.getName(),
					request.getHome().getRepository().getLocales()));
		}
		catch (IOException ex)
		{
			throw new RuntimeException(ex);
		}

		return asset;
	}

	public ExternalDigitalAsset createAssetVersion(ExternalUploadAssetRequest request)
	{
		return null;
	}

	public OperationExecutionStatus updateAsset(
		ExternalCommonRequest request,
		ExternalDigitalAsset digitalAsset)
	{
		return null;
	}

	public OperationExecutionStatus updateAssetVersion(
		ExternalCommonRequest request,
		ExternalDigitalAsset digitalAssetVersion)
	{
		return null;
	}

	//Defines the result from deleting an externally stored asset
	public OperationExecutionStatus deleteAsset(
		ExternalSingularRequest request,
		boolean isPhysicalDelete)
	{
		OperationExecutionStatus status = new OperationExecutionStatus();
		try
		{
			this.googleDrive.files().delete(request.getExternalId()).execute();
		}
		catch (IOException ex)
		{
			status = new OperationExecutionStatus(new DAMException(ex.getMessage()));
		}

		return status;
	}

	//Defines the result from deleting an externally stored asset version
	public OperationExecutionStatus deleteAssetVersion(ExternalSingularRequest request)
	{
		OperationExecutionStatus status = new OperationExecutionStatus();
		try
		{
			this.googleDrive.files().delete(request.getExternalId()).execute();
		}
		catch (IOException ex)
		{
			status = new OperationExecutionStatus(new DAMException(ex.getMessage()));
		}

		return status;
	}

	//Retrieves asset information from external storage. Some information such as the preview URL determines what display in the add-on's Editor
	public ExternalDigitalAsset getAsset(ExternalSingularRequest request) throws DAMException
	{
		ExternalDigitalAsset digitalAsset = new ExternalDigitalAsset();
		try
		{
			File file = this.googleDrive.files()
				.get(request.getExternalId())
				.setFields("*")
				.execute();
			String urlDownload = this
				.getUrl(file.getId(), file.getName(), file.getFileExtension(), true);
			String previewUrl = this
				.getUrl(file.getId(), file.getName(), file.getFileExtension(), false);
			digitalAsset.setId(file.getId());
			digitalAsset.setPhysicalName(file.getOriginalFilename());
			digitalAsset.setLabelDescription(
				this.getLabelDescription(
					file.getName(),
					request.getHome().getRepository().getLocales()));
			digitalAsset.setURL(previewUrl);

			boolean isImage = DigitalAssetExtension.parseExtension(file.getFileExtension())
				.getDigitalAssetContentType()
				.isImage();
			if (isImage)
			{
				digitalAsset.setThumbnailURL((previewUrl));
			}
			else
			{
				digitalAsset.setThumbnailURL(file.getThumbnailLink());
			}
			digitalAsset.setDownloadURL(urlDownload);
			digitalAsset.setAssetType(file.getFileExtension());
			digitalAsset.setExtension(file.getFileExtension());
			digitalAsset.setCreationDate(new Date(file.getCreatedTime().getValue()));
			digitalAsset.setLastUpdatedDate(new Date(file.getModifiedTime().getValue()));
			digitalAsset.setFileSize(new BigDecimal(file.getSize().longValue()));
			Map<String, String> metaDataMap = new HashMap<>();
			metaDataMap.put("mKey1", "mValue1");
			metaDataMap.put("mKey2", "mValue2");
			digitalAsset.setMetaDatas(metaDataMap);

			this.buildWidthHeight(digitalAsset, file);
		}
		catch (IOException ex)
		{
			throw new DAMException(ex);
		}

		return digitalAsset;
	}

	public ExternalDigitalAsset getAssetVersion(ExternalSingularRequest request)
	{
		return null;
	}

	public MediaContent getMediaContentOfAsset(ExternalSingularRequest request)
	{
		return null;
	}

	public MediaContent getMediaContentOfAssetVersion(ExternalSingularRequest request)
	{
		return null;
	}

	public List<ExternalDigitalAsset> getAssets(ExternalPluralRequest externalRequest)
	{
		List<ExternalDigitalAsset> externalAssets = new ArrayList<>();
		for (String externalId : externalRequest.getExternalIds())
		{
			try
			{
				File file;
				try
				{
					file = this.googleDrive.files().get(externalId).setFields("*").execute();
				}
				catch (Exception ex)
				{
					continue;
				}

				ExternalDigitalAsset externalDigitalAsset = new ExternalDigitalAsset();
				externalDigitalAsset.setId(file.getId());
				externalDigitalAsset.setPhysicalName(file.getOriginalFilename());
				externalDigitalAsset.setCreationDate(new Date(file.getCreatedTime().getValue()));
				externalDigitalAsset
					.setLastUpdatedDate(new Date(file.getModifiedTime().getValue()));
				externalDigitalAsset.setLabelDescription(
					this.getLabelDescription(
						file.getName(),
						externalRequest.getHome().getRepository().getLocales()));
				String urlDownload = this
					.getUrl(file.getId(), file.getName(), file.getFileExtension(), true);
				String previewUrl = this
					.getUrl(file.getId(), file.getName(), file.getFileExtension(), false);
				externalDigitalAsset.setURL(previewUrl);
				externalDigitalAsset.setThumbnailURL(file.getThumbnailLink());
				this.buildWidthHeight(externalDigitalAsset, file);
				externalDigitalAsset.setDownloadURL(urlDownload);
				externalDigitalAsset.setAssetType(file.getFileExtension());
				externalDigitalAsset.setExtension(file.getFileExtension());

				Map<String, String> metaDatas = new HashMap<>();
				metaDatas.put("metadata1", "metadata1");
				metaDatas.put("metadata2", "metadata2");
				externalDigitalAsset.setMetaDatas(metaDatas);

				externalDigitalAsset.setTags(Arrays.asList("tag1", "tag2"));

				externalAssets.add(externalDigitalAsset);
			}
			catch (IOException ex)
			{
				throw new RuntimeException(ex);
			}
		}

		return externalAssets;
	}

	public void buildWidthHeight(ExternalDigitalAsset digitalAsset, File googleFile)
	{
		// The following is mock data
		DigitalAssetExtension extension = DigitalAssetExtension
			.parseExtension(digitalAsset.getExtension());
		if (extension.getDigitalAssetContentType().isImage()
			&& googleFile.getImageMediaMetadata() != null)
		{
			Integer width = googleFile.getImageMediaMetadata().getWidth();
			Integer height = googleFile.getImageMediaMetadata().getHeight();
			digitalAsset.setWidth(this.validateSize(width) ? new Integer(450) : width);
			digitalAsset.setHeight(this.validateSize(height) ? new Integer(450) : height);
		}
		else if (extension.getDigitalAssetContentType().isVideo()
			&& googleFile.getVideoMediaMetadata() != null)
		{
			digitalAsset.setWidth(googleFile.getVideoMediaMetadata().getWidth());
			digitalAsset.setHeight(googleFile.getVideoMediaMetadata().getHeight());
		}
		else
		{
			digitalAsset.setWidth(new Integer(450));
			digitalAsset.setHeight(new Integer(450));
		}
	}

	private boolean validateSize(Integer size)
	{
		return size != null && (size.compareTo(new Integer(0)) == 0);
	}

	public ExternalTagResult getTags(ExternalCommonRequest request)
	{
		Random random = new Random();
		ExternalTagResult list = new ExternalTagResult();

		// handle case: list tag is not initialized in Tag()
		list.setTags(new ArrayList<>());
		for (int i = 0; i < 25; i++)
		{
			Tag tag = new Tag();
			tag.setCode("abc" + i);

			tag.setFontSize("" + (14 + random.nextInt(5)));
			list.getTags().add(tag);
		}

		return list;
	}

	public ExternalDigitalAssetVersionBean getAssetVersionByAssetId(ExternalSingularRequest request)
	{
		try
		{
			Files files = this.googleDrive.files();
			FileList fileList = files.list().setFields("*").execute();
			List<File> allFile = fileList.getFiles();

			//set current version
			ExternalDigitalAssetVersionBean versions = new ExternalDigitalAssetVersionBean(
				this.getAsset(request));
			//TODO lvh testing with fix size
			int size = 2;
			for (int i = 0; i < size; i++)
			{
				File googleFile = allFile.get(i);
				System.out.println("Id: " + googleFile.getId());
				System.out.println("ThumbnailLink: " + googleFile.getThumbnailLink());
				String urlDownload = this.getUrl(
					googleFile.getId(),
					googleFile.getName(),
					googleFile.getFileExtension(),
					true);
				String previewUrl = this.getUrl(
					googleFile.getId(),
					googleFile.getName(),
					googleFile.getFileExtension(),
					false);
				ExternalDigitalAsset asset = new ExternalDigitalAsset();
				asset.setLabelDescription(
					this.getLabelDescription(
						googleFile.getName(),
						request.getHome().getRepository().getLocales()));
				asset.setDownloadURL(urlDownload);
				asset.setURL(previewUrl);
				asset.setThumbnailURL(googleFile.getThumbnailLink());
				asset.setId(googleFile.getId());
				asset.setThumbnailURL(googleFile.getThumbnailLink());
				asset.setTags(Arrays.asList("tag1", "tag2"));
				asset.setAssetType(googleFile.getMimeType());
				asset.setFileSize(BigDecimal.valueOf(googleFile.getSize().longValue()));
				asset.setPhysicalName(googleFile.getOriginalFilename());
				Date createDate = new Date();
				createDate.setTime(googleFile.getModifiedTime().getValue());
				asset.setCreationDate(createDate);

				versions.addExternalDigitalAsset(asset);
			}
			return versions;
		}
		catch (Exception ex)
		{
			throw new RuntimeException(ex);
		}
	}

	private String getFileName(String label, String extension)
	{
		String fileName = label.replace(" ", "_");
		if (fileName.contains("." + extension))
		{
			return fileName;
		}

		return label.replace(" ", "_").concat(".").concat(extension);
	}

	private String getUrl(String externalId, String fileName, String extension, boolean isDownload)
		throws UnsupportedEncodingException
	{
		//The network location where EBX is running
		String host = "localhost:8080";

		String providerLink = "http://" + host
			+ "/ebx-addon-tests/dama-services-dispatcher?service=external_download_provider";
		StringBuilder urlDownload = new StringBuilder(providerLink);
		urlDownload.append("&external_id=").append(URLEncoder.encode(externalId, "UTF-8"));
		urlDownload.append("&fileName=")
			.append(URLEncoder.encode(this.getFileName(fileName, extension), "UTF-8"));
		urlDownload.append("&extension=").append(extension);
		if (isDownload)
		{
			urlDownload.append("&download=").append(Boolean.TRUE.toString());
		}

		return urlDownload.toString();
	}

	private LabelDescription getLabelDescription(String name, List<Locale> locales)
	{
		if (AddonStringUtils.isEmpty(name))
		{
			name = DAMConstants.EMPTY_STRING;
		}
		List<LabelDescriptionForLocale> labelDescriptionForLocales = new ArrayList<>();
		for (Locale locale : locales)
		{
			LabelDescriptionForLocale labelDesLocale = new LabelDescriptionForLocale();
			labelDesLocale.setLocale(locale);
			labelDesLocale.setLabel(name);
			labelDesLocale.setDescription(name);
			labelDescriptionForLocales.add(labelDesLocale);
		}
		LabelDescription labelDescription = new LabelDescription();
		labelDescription.setLocalizedDocumentations(labelDescriptionForLocales);

		return labelDescription;
	}
}
