public ExternalSearchAssetsResult searchAssets(ExternalSearchRequest searchRequest)
{
	ExternalSearchAssetsResult result = new ExternalSearchAssetsResult();
	SearchFilter searchFilter = searchRequest.getSearchFilter();
	String keyword = (searchFilter == null) ? DAMConstants.EMPTY_STRING
		: searchFilter.getKeyword();
	try
	{
		FileList fileList = this.googleDrive.files().list().setFields("*").execute();
		List<File> allFiles = fileList.getFiles();
		List<File> filteredFiles = new ArrayList<>();

		for (File file : allFiles)
		{
			if (AddonStringUtils.isEmpty(keyword))
			{
				filteredFiles.add(file);
			}
			else
			{
				if (file.getName().contains(keyword)
					|| file.getOriginalFilename().contains(keyword))
				{
					filteredFiles.add(file);
				}
			}
		}
		int size = filteredFiles.size();
		int pageIndex = (searchRequest.getPageIndex() < 1) ? 1 : searchRequest.getPageIndex();
		int pageSize = (searchRequest.getPageSize() < 10) ? 10 : searchRequest.getPageSize();
		int startIndex = (pageIndex - 1) * pageSize;
		int endIndex = startIndex + pageSize - 1;
		if (endIndex > size - 1)
		{
			endIndex = size - 1;
		}

		List<ExternalDigitalAsset> externalAssets = new ArrayList<>();
		for (int i = startIndex; i <= endIndex; i++)
		{
			File googleFile = filteredFiles.get(i);
			String downloadUrl = this.getUrl(
				googleFile.getId(),
				googleFile.getName(),
				googleFile.getFileExtension(),
				true);
			String previewUrl = this.getUrl(
				googleFile.getId(),
				googleFile.getName(),
				googleFile.getFileExtension(),
				false);
			ExternalDigitalAsset externalAsset = new ExternalDigitalAsset();
			externalAsset.setLabelDescription(
				this.getLabelDescription(
					googleFile.getName(),
					searchRequest.getHome().getRepository().getLocales()));
			externalAsset.setURL(previewUrl);
			externalAsset.setThumbnailURL(googleFile.getThumbnailLink());
			externalAsset.setDownloadURL(downloadUrl);
			externalAsset.setExtension(googleFile.getFileExtension());
			externalAsset.setAssetType(googleFile.getFileExtension());
			externalAsset.setId(googleFile.getId());
			externalAsset.setPhysicalName(googleFile.getName());
			externalAsset.setCreationDate(new Date(googleFile.getCreatedTime().getValue()));
			externalAsset.setLastUpdatedDate(new Date(googleFile.getModifiedTime().getValue()));
			externalAsset.setFileSize(new BigDecimal(googleFile.getSize().longValue()));
			Map<String, String> metaDataMap = new HashMap<>();
			metaDataMap.put("mKey1", "mValue1");
			metaDataMap.put("mKey2", "mValue2");
			externalAsset.setMetaDatas(metaDataMap);
			externalAsset.setWidth(new Integer(300));
			externalAsset.setHeight(new Integer(200));

			externalAssets.add(externalAsset);
		}

		result.setAssets(externalAssets);
	}
	catch (Exception ex)
	{
		throw new RuntimeException(ex);
	}

	return result;
}