define({'Ability':{d:'An endpoint can carry messages using up to four abilities: 1. One-to-many receive (subscriber), 2. One-to-one receive (inbox subscriber), 3. One-to-many send (send call), 4. One-to-one send (send-to-inbox call).\n\nAdministrators bind transports to specific endpoint abilities. [Development, Administration]',l:''},'ACL':{d:'An access control list which is a list of permissions associated with a system resource. An ACL specifies the users or system processes that are granted access to objects, as well as what operations are allowed on given object.',l:''},'Advisory':{d:'TIBCO FTL software uses asynchronous advisory messages to convey errors, warnings or other information.\n[Development]',l:''},'Application':{d:'1. An FTL application is an executable program that communicates using TIBCO FTL software. 2. Within the realm definition, an application (or more explicitly, an application definition) configures the endpoints, formats, transports, and stores for an application program. [Concepts, Administration]',l:''},'Application Definition':{d:'An application definition is a configuration within the realm that represents an application program, declares its endpoints and formats, and configures endpoint implementation for its process instances. An application definition consists of a name, a set of endpoints, a set of application instance definitions, and a set of preload formats. [Concepts, Administration]',l:''},'Application Instance Definition':{d:'An application instance definition configures endpoints for use by application processes in a specific context, for example, a process that runs on a specific host computer or supplies an application instance identifier. \nStructurally, an application instance definition consists of a name, a set of match parameters, and a set of connectors to implement each endpoint. [Concepts, Administration]',l:''},'Application Instance Identifier':{d:'Administrators arrange transports to implement endpoints in different ways, and select among them at runtime using an application instance identifier.\nApplication programs obtain that identifier from the command line, a configuration file, or an environment variable, and then supply that identifier as a property value in the realm connect call. [Concepts, Development]',l:''},'Apportioning Message Streams':{d:'A store can apportion a message stream among a set of cooperating subscribers. Only one subscriber receives and\nprocesses each message. Acting together, the subscribers process every message in the stream. [Concepts]',l:''},'Authentication Service':{d:'A service used to authenticate the identity of, then authorize, client programs, administrative tools, and affiliated servers, typically as a prerequisite to allowing access or communication.',l:''},'Auxiliary Servers':{d:'Optional auxiliary servers are configured for a specialized purpose. It is not designated in the list of core.servers. An auxiliary server might provide an eFTL service to expand capacity, backup bridge service for fault tolerance, or provide a persistence service in a disaster recovery model. Also see Primary Servers and Satellite Servers. [Administration]',l:''},'Bridge':{d:'See Transport Bridge.',l:''},'Broker':{d:'A message broker is an FTL server that provides server-based messaging using a message broker pattern.\n[Concepts, Administration]',l:''},'Broker Based Messaging':{d:'In broker based messaging, publishers send messages to the FTL server, and messages are held in an intermediate store until they are successfully sent to subscribers. This model allows for adjustment of reliability and throughput parameters, and provides flexible administration and monitoring. [Concepts]',l:''},'Brokerless Messaging':{d:'In brokerless messaging, publishers send messages directly to subscribers, with generally lower latency than when using a broker for storage. The FTL server still provides some management for the client applications. [Concepts]',l:''},'Certificate SAN (Subject Alternate Name)':{d:'A Subject Alternate Name (or SAN) certificate is a digital security certificate which allows multiple hostnames to be protected by a single certificate. Also called a Unified Communication Certificate (or UCC), a multi-domain certificate, or an Exchange certificate.',l:''},'Cluster':{d:'A cluster of FTL Servers which can be arranged to provide fault tolerant services, including persistence services, realm services, group services, and bridge services. See Persistence Clusters. [Concepts]',l:''},'Content Matcher':{d:'A content matcher is a pattern matching template for message fields and values. A subscriber can use a content\nmatcher to narrow its interest to a subset of a message stream. [Concepts, Development]',l:''},'Core Server':{d:'A core server is an FTL Server that you designate for managing and storing realm deployments. Also see Primary Servers, Satellite Servers, and Auxiliary Servers. [Administration]',l:''},'Delivery Assurance':{d:'A store can retain message streams for a disconnected subscriber, assuring delivery after the subscriber returns.\nThe subscriber receives the complete message stream. [Concepts]',l:''},'Deploy':{d:'In FTL, an administrator modifies the realm definition so the FTL server\u0027s clients can use the new realm definition. The updated definition put into production use is said to be deployed. [Administration]',l:''},'Direct Path':{d:'The direct path is a communications path in which messages travel directly between publishing and subscribing endpoints,\nwithout an intermediate stop at a store. In contrast, an indirect path goes through a store, which may optionally back a direct path. [Concepts, Administration]',l:''},'Disable':{d:'An administrator can use the FTL server GUI to disable a client process. Disabled clients cannot use TIBCO FTL\ncommunications resources. [Administration]',l:''},'Disk-Based Persistence':{d:'Enable disk-based persistence to store FTL messages and metadata to disk, when disk is more cost effective than memory or when a stronger degree of persistence is desired. The stored messages and metadata can be automatically recovered on a full restart of the persistence cluster. [Concepts]',l:''},'Dispatch':{d:'Programs use API calls to dispatch inbound messages from event queues to callback methods. [Development]',l:''},'Durable':{d:'A durable is the data structure within a store that maintains subscriber interest, forwards messages, and tracks delivery acknowledgments. There are different types of durables. See Standard Durable (with Prefetch Enabled), Standard Durable (no Prefetch), Shared Durable, Last-Value Durable, Dynamic Durable, Static Durable, and Map Durable. [Concepts , Administration, and Development]',l:''},'Durable Subscriber':{d:'A durable subscriber is a subscriber object in an application process that maintains its identity even if the process\nexits and restarts. The subscriber relies on its durable to ensure message delivery. [Concepts, Development,\nAdministration]',l:''},'Dynamic Durable':{d:'A dynamic durable uses a dynamic durable template to enable durable subscribers within programs to create a set of durables at run time. [Concepts , Administration, and Development]',l:''},'Dynamic Durable Template':{d:'An administrative configuration that supplies parameter values for dynamic durables. [Administration]',l:''},'Dynamic Format':{d:'When a program constructs a self-describing message, its format is dynamic. That is, the format changes each\ntime the program adds a field to the message. The message’s metadata reflects the current state of the dynamic\nformat. Also see Managed Format. [Development]',l:''},'eFTL':{d:'TIBCO eFTL software is an add-on product that extends TIBCO FTL messaging to platforms that cannot\nsupport the full TIBCO FTL bus. Platforms such as web browsers and mobile phones can use TIBCO eFTL\nsoftware to communicate with back-end infrastructure based on TIBCO FTL software.',l:''},'eFTL Service':{d:'An eFTL service is an FTL service used to integrate mobile and browser platforms into an enterprise messaging solution.',l:''},'Endpoint':{d:'An endpoint is the connection point between a transport and the publisher, subscriber, or broker. An endpoint contains transport details and insulates programs, and their designers/users, from those details. This enables separation of responsibilities between developers and administrators. Many publishers and many program processes may publish on one publishing endpoint. One subscriber may consume from more than one publishing endpoint. A program can have more than one endpoint to tap into more than one transport message stream. [Concepts]',l:''},'Event Queue':{d:'Event queues buffer inbound messages during message delivery. Programs dispatch messages from event queues\nto callback methods. [Development]',l:''},'Fault Tolerance':{d:'Fault tolerance is a system\u0027s ability to continue operating uninterrupted when one or more of the system\u0027s components fail. [Concepts]',l:''},'Field':{d:'Each field of the metadata for a message has a field name and a field type. Each field of the message contains the data value. [Concepts, Development]',l:''},'Format':{d:'A format defines the set of fields that a message can contain, including field names and data types. The format is available to cooperating programs before they exchange messages. Messages only carry data, which reduces both the message size, transport bandwidth, and processing time. [Concepts, Development, Administration]',l:''},'Forwarding Zone':{d:'Forwarding zones delineate the scope of wide-area durables. A forwarding zone contains a set of persistence\nclusters, which cooperate to forward wide-area durables among all the persistence clusters in that zone.\n[Concepts, Administration]',l:''},'FTL Server':{d:'An FTL server is the main point of contact for FTL clients, providing clients with services. Its\nconfiguration file determines the services that it provides. [Development, Administration]',l:''},'Group':{d:'A group is a named set of application processes. A group service tracks group members as the processes join and leave the group and connect and disconnect from the FTL server. The group membership functionality is used by cooperating applications that belong to the same group to coordinate fault-tolerant operations or to designate operating roles among the cooperating application processes.  [Concepts, Development]',l:''},'Group Service':{d:'FTL\u0027s group service coordinates fault-tolerant operation and operating roles among applications processes. Every core FTL server automatically provides a group service. Application processes in a group use the group facility’s API calls to interact with the group service, and to coordinate appropriate behavior. Group member applications and the group service are all within the same realm, and usually run on host computers within a local area network. Do not use the group facility across routers and WANs. [Concepts, Development]',l:''},'Immutable':{d:'A message is immutable if a program cannot modify the fields of the message. [Development]',l:''},'Inbound':{d:'Inbound indicates the direction proceeding into an endpoint from a transport, or into a program through an endpoint. For example, subscriber objects receive inbound messages. [Development, Administration]',l:''},'Inbox':{d:'An inbox is a data structure that identifies a unique inbox subscriber object, enabling one-to-one communication\nto that subscriber. [Concepts, Development]',l:''},'Inbox Subscriber':{d:'An inbox subscriber can receive one-to-one communication. An inbox subscriber is one kind endpoint instance\nwithin a program. An inbox subscriber instantiates the one-to-one receiving capabilities of an endpoint. (Contrast\nSubscriber.) The term \"subscriber\" is used in a one-to-many model whereas an \"inbox subscriber\" is used in one-to-one communication. [Concepts, Development]',l:''},'Indirect Path':{d:'An indirect path is a communications path in which messages travels with an intermediate stop at a persistence store. The indirect path optionally backs a direct path. [Concepts, Administration]',l:''},'Inline Mode':{d:'Programs that receive time-sensitive messages can use inline mode to favor low latency over high throughput. Restrictions apply. [Development, Administration]',l:''},'Interest':{d:'A subscriber expresses interest in the message stream arriving at an endpoint to potentially receive the message. If the subscriber has a content matcher, it expresses interest in a subset of that message stream: namely, the subset with matching content. A durable expresses interest on behalf of its durable subscriber, even when the subscriber is absent.\n[Concepts, Development, Administration]',l:''},'Iteration':{d:'Iteration is a sequence of instructions are repeated a specific number of times or until a condition is met. When the first set of instructions is executed again, it is called an iteration.',l:''},'Key-Value Map':{d:'A  key/value map stores key/value pairs where each key is a string and a key\u0027s value is a message. Programs can use map methods to store and retrieve key/value pairs, and to iterate over the pairs in a map. This is a way to use the store as a simple database table. [Concepts]',l:''},'Last-Value Durable':{d:'A last-value durable is a durable that represents the interest of potentially many subscriber objects. It stores only the most recent message from one or more message streams. Use a last-value durable to hold recent context for initializing new subscribers.',l:''},'Latency':{d:'Latency is the time for a message to be transferred between its original source and its destination. Latency is typically measured in milliseconds. [Concepts]',l:''},'Managed Format':{d:'A message format is a fixed set of field names and field types. This metadata describes message content and is provided to cooperating programs before they exchange messages. A message that conforms to a format carries only data values, which reduces both the message size and processing time. A message format is defined in the realm definition. Also see Dynamic Format. [Concepts, Administration]',l:''},'Many-to-Many':{d:'Many-to-many communication is when many publishers send messages to many subscribers and, potentially, every subscriber can receives messages from each of the publishers.',l:''},'Many-to-Many or One':{d:'Many-to-many or one communication is when two or more publishers publish messages and one or more subscribers receive messages. [Concepts]',l:''},'Map API':{d:'A MAP API is a set of methods for storing and retrieving key/value pairs in a last-value durable. [Development]',l:''},'Map Durable':{d:'A map durable is a durable that stores a key/value mapping. When a message arrives, a map durable uses the value in the message\u0027s key field as the key, and stores the full message as its value. For each distinct key, the durable stores only the most recent value. (One map durable can hold many key/value pairs.) [Concepts , Administration, and Development]',l:''},'Message':{d:'In FTL, a message format defines the metadata which is the set of fields that a message can contain. The message only carries data. This approach reduces the message size, transport bandwidth, and processing time. For efficiency, TIBCO FTL messages support a limited set of data types. Publishers send messages and subscribers receive messages through endpoints. A program can send messages, receive messages, or both. [Concepts]',l:''},'Message Stream':{d:'A message stream is a sequence of messages. A publisher is the source of the message stream, and a subscriber expresses interest in that stream. Concepts]',l:''},'Message Swapping':{d:'Messages held in process memory can be swapped to disk when configured memory limits are exceeded. Excess messages are temporarily written to disk, as needed. [Concepts and Administration]',l:''},'Multi-tenancy':{d:'Multiple independent instances of one or multiple applications operate in a shared environment.',l:''},'Mutable':{d:'A program may modify the fields of a mutable message. [Development]',l:''},'Notification':{d:'A notification is an out-of-band communication from TIBCO FTL software to an application program. TIBCO FTL\nsoftware delivers notifications when conditions preclude delivering advisories using event queues. [Development]',l:''},'One-to-Many Publishing':{d:'One-to-many publishing is a common model in TIBCO FTL where a publisher produces a stream of messages and the subscribers can receive messages, sometimes selected by content matching. [Concepts]',l:''},'One-to-One Communication':{d:'One-to-one communication lets a publisher send a message to a specific inbox subscriber which is a kind of endpoint instance. Only that inbox subscriber receives the message, even when other subscribers share the transport. [Concepts]',l:''},'Outbound':{d:'Outbound indicates the direction proceeding out from an endpoint to a transport, or out from a program through\nan endpoint. For example, publisher objects send outbound messages. [Development, Administration]',l:''},'Permissions':{d:'Permissions are set at the cluster and store level to grant access to objects for given user/role.',l:''},'Persistence':{d:'Persistence is the potential to store a message after sending it and before it is received so off line subscribers can consume it at a later time. Persistence services use stores and durables to implement this potential. See also Apportioning Message Streams and Delivery Assurance. [Concepts, Administration, Development]',l:''},'Persistence Clusters':{d:'The persistent services of a cluster of FTL servers cooperate in a persistence cluster.  A persistence cluster maintains a set of persistence stores, replicating data for fault tolerance. [Concepts]',l:''},'Persistence Service':{d:'A persistence service is an FTL service used to manage stores and durable subscriptions (durables).',l:''},'Preload Format':{d:'Preload formats are the managed formats available to an application program. [Administration]',l:''},'Primary Servers':{d:'Primary servers form the central hub within a family of affiliated servers and operate within a local network. Servers in the primary cluster function as interchangeable peers. Also see Satellite Servers and Auxiliary Servers. [Administration]',l:''},'Primary Set':{d:'To prepare for disaster recovery, a persistence cluster can define two sets of persistence services, with some\nservices at the main site and others at the disaster recovery site. The primary set is the set of active persistence\nservices at the main site, while the standby set is the set of persistence services at the disaster recovery site.',l:''},'Privileged Users':{d:'Privileged users are users who have been delegated extra levels of control. Users who lack most privileges are defined as unprivileged.',l:''},'Publisher':{d:'A publisher sends messages and is the source of a message stream. A publisher instantiates (verifies) the send capabilities of an endpoint. Within a program, a publisher is one kind of endpoint instance. [Concept]',l:''},'Realm':{d:'A realm represents one communication fabric, with its endpoints, applications, application instances, transports, stores, and message formats. [Concepts, Development, Administration]',l:''},'Realm Service':{d:'A realm service is an FTL service used as a unified communication fabric within and across networks which supplies application programs with communication configuration data. A realm service maintains a realm definition, which the FTL server distributes to client applications. [Development,\nAdministration]',l:''},'Request/Reply':{d:'Request/reply is a communication pattern where a requester sends a request message to a replier system, which receives and processes the request, ultimately returning a message in response. Request/reply can be one-to-many or one-to-one communication. [Concepts]',l:''},'Satellite Servers':{d:'Optional satellite servers provide local service to clients that are geographically distant from the primary servers, or clients that are insulated from the primary servers (to fulfill enterprise requirements).  Also see Primary Servers and Auxiliary Servers. [Administration]',l:''},'Self-Describing Message':{d:'A self-describing message does not conform to a predefined format. A publishing program assembles a message with any number of fields and any combination of the data types. Each message contains the name and data types of each field which enlarges each message and results in slower processing of messages. Contrast to FTL\u0027s formatted messages (see Format). [Concepts]',l:''},'Send':{d:'Programs make send calls to send messages.  More narrowly, the term send also refers specifically to one-to-many publishing. (Contrast Send-to-Inbox.) [Concepts]',l:''},'Send-to-Inbox':{d:'Programs make send-to-inbox calls to send one-to-one messages. (Contrast Send.) [Concepts]',l:''},'Shared Durable':{d:'A shared durable is a durable that represents the identical interest of two or more cooperating subscriber objects, apportioning a message stream among those subscribers. Use a shared durable when a set of subscribers collectively process a message stream in a distributed or parallel fashion, processing every message exactly once.  [Concepts , Administration, and Development]',l:''},'Standard Durable (no Prefetch)':{d:'A standard durable represents the interest of one subscriber object and forwards messages to the subscriber on request. With prefetch disabled (no prefetch), messages typically flow directly from publisher to subscriber and the store serves as a backup. [Concepts , Administration, and Development]',l:''},'Standard Durable (with Prefetch Enabled)':{d:'A standard durable represents the interest of one subscriber object and forwards messages to the subscriber on request. With prefetch enabled, the store functions as a message broker, with no messages traveling peer-to-peer from publisher to subscriber. [Concepts , Administration, and Development]',l:''},'Static Durable':{d:'A static durable is defined in advance of any subscribers and is defined in the realm configuration. [Concepts , Administration, and Development]',l:''},'Store':{d:'A store holds messages until they are consumed. A persistent store is a store that is optionally replicated to further ensure against loss of messages. Administrators can configure stores within apersistence cluster or forwarding zone. Each store collects and maintains exactly one message stream and can collect the stream from one or more publishers. The store can maintain that message stream for one or many subscribers. [Concepts, Administration]',l:''},'Store Inboxes':{d:'Store inboxes use the application’s endpoint configured store or system store to store inbox data. When the endpoint\u0027s configured store is used, this is called an endpoint store inbox. Otherwise, the dedicated inbox stores ftl.system.inbox.store or ftl.routing.inbox.store are used.  [Concepts, Administration]',l:''},'Subscriber':{d:'A subscriber expresses interest in a message stream and receives messages. A subscriber instantiates (verifies) the receiving capabilities of an endpoint. Within a program, a subscriber is one kind of endpoint instance. Also see \"Inbox Subscriber\". [Concepts]',l:''},'Template':{d:'See Dynamic Durable Template.',l:''},'Throughput':{d:'Throughput is the number of messages processed in a given time over a communication channel. Often measured messages per second. [Concepts]',l:''},'Transport':{d:'Messages travel from publishers to subscribers over a transport which is a shared communication medium. TIBCO FTL supports a variety of transport types to use based on messaging requirements and environment. Each transport is a separate communication medium, insulated against crosstalk from other transports. [Concepts, Administration]',l:''},'Transport Bridge':{d:'A transport bridge is a specialized process that can forward messages among sets of transports. [Administration]',l:''},'Transport Bridge Service':{d:'A transport bridge service is an FTL service used to forward messages among multiple transport types.',l:''},'TTL (time-to-live)':{d:'A TTL (time-to-live) defines how long a message remains in a system. Sometimes used to determine how long redelivery should be attempted if a subscriber cannot initially be reached.',l:''},'Unprivileged User':{d:'Users who lack most privileges are defined as unprivileged. Users who have been delegated extra levels of control are called privileged.',l:''},'Variant':{d:'See Application Instance. [Concepts]',l:''},'Wide-Area Durable':{d:'Wide-area durables are accessible to publishers and subscribers across a wide-area network (WAN) link as if the durable is in a local persistence store. [Concepts, Administration]',l:''},'Zone':{d:'See Forwarding Zone. [Concepts, Administration]',l:''}});