define({"1065":{y:0,u:"../cpp-reference/TibrvDispatchable.htm",l:-1,t:"TibrvDispatchable",i:0.00108997501077526,a:"Class Declaration class TibrvDispatchable Purpose Common interface for queues and queue groups. Remarks Programs never instantiate this class. Both  TibrvQueue  and  TibrvQueueGroup  implement this interface, so programs can call the common methods on objects of either class. For example, consider a ..."},"1066":{y:0,u:"../cpp-reference/TibrvDispatchable__destroy__.htm",l:-1,t:"TibrvDispatchable::destroy()",i:0.000343247000967292,a:"Method Declaration virtual  TibrvStatus destroy () = 0; Purpose Destroy a queue or queue group. Remarks When a queue is destroyed, events that remain in the queue are discarded. When a queue group is destroyed, the individual queues in the group continue to exist, even though the group has been ..."},"1067":{y:0,u:"../cpp-reference/TibrvDispatchable__dispatch__.htm",l:-1,t:"TibrvDispatchable::dispatch()",i:0.000462380567111741,a:"TibrvDispatchable:: dispatch() Method Declaration virtual  TibrvStatus dispatch () = 0; Purpose Dispatch an event; if no event is ready, block. Remarks If an event is ready to dispatch, then this call dispatches it, and then returns. If no events are waiting, then this call blocks indefinitely while ..."},"1068":{y:0,u:"../cpp-reference/TibrvDispatchable__getDispatchable__.htm",l:-1,t:"TibrvDispatchable::getDispatchable()",i:0.000343247000967292,a:"TibrvDispatchable::getDispatchable() Method Declaration virtual  tibrvDispatchable getDispatchable() const = 0; Purpose Extract the C handle of a queue or queue group. Remarks If the event is invalid, this method returns the constant TIBRV_INVALID_ID."},"1069":{y:0,u:"../cpp-reference/TibrvDispatchable__isValid__.htm",l:-1,t:"TibrvDispatchable::isValid()",i:0.000343247000967292,a:"TibrvDispatchable:: isValid() Method Declaration virtual tibrv_bool isValid () const = 0; Purpose Test validity of a queue or queue group. Remarks Returns TIBRV_TRUE if the dispatchable object is valid; TIBRV_FALSE if the dispatchable object has been destroyed."},"1070":{y:0,u:"../cpp-reference/TibrvDispatchable__poll__.htm",l:-1,t:"TibrvDispatchable::poll()",i:0.000473003238835052,a:"TibrvDispatchable:: poll() Method Declaration virtual  TibrvStatus poll(); Purpose Dispatch an event, if possible. Remarks If an event is ready to dispatch, then this call dispatches it, and then returns. If no events are waiting, then this call returns immediately. When the call dispatches an ..."},"1071":{y:0,u:"../cpp-reference/TibrvDispatchable__timedDispatch__.htm",l:-1,t:"TibrvDispatchable::timedDispatch()",i:0.000520273213647103,a:"TibrvDispatchable:: timedDispatch() Method Declaration virtual  TibrvStatus timedDispatch(tibrv_f64 timeout) = 0; Purpose Dispatch an event, but if no event is ready to dispatch, limit the time that this call blocks while waiting for an event. Remarks If an event is ready to dispatch, then this call ..."},"1072":{y:0,u:"../cpp-reference/TibrvQueue.htm",l:-1,t:"TibrvQueue",i:0.00223614958657963,a:"Class Declaration class TibrvQueue :  TibrvDispatchable     TibrvQueue();             // Construct empty.     virtual ~TibrvQueue();    // Destroy and reclaim storage. Purpose Event queue. Remarks Each event is associated with a  TibrvQueue  object; when the event occurs, Rendezvous software places ..."},"1073":{y:0,u:"../cpp-reference/TibrvQueue__create__.htm",l:-1,t:"TibrvQueue::create()",i:0.000214139117438805,a:"TibrvQueue::create() Method Declaration TibrvStatus create (); Purpose Create an event queue. Remarks This method creates a C queue and stores its handle in the C++ object. Upon creation, new queues use these default values for properties."},"1074":{y:0,u:"../cpp-reference/TibrvQueue__destroy__.htm",l:-1,t:"TibrvQueue::destroy()",i:0.000641388397691766,a:"TibrvQueue:: destroy() Method Declaration TibrvStatus destroy (); TibrvStatus destroy (      TibrvQueueOnComplete * completeCB,     const void* closure = NULL); Purpose Destroy an event queue. Remarks When a queue is destroyed, events that remain in the queue are discarded. The destructor calls this ..."},"1075":{y:0,u:"../cpp-reference/TibrvQueue__dispatch__.htm",l:-1,t:"TibrvQueue::dispatch()",i:0.00042059315310142,a:"TibrvQueue:: dispatch() Method Declaration virtual  TibrvStatus dispatch (); Purpose Dispatch an event; if no event is ready, block. Remarks If the queue is not empty, then this call dispatches the event at the head of the queue, and then returns. If the queue is empty, then this call blocks ..."},"1076":{y:0,u:"../cpp-reference/TibrvQueue__getCount__.htm",l:-1,t:"TibrvQueue::getCount()",i:0.000214139117438805,a:"TibrvQueue:: getCount() Method Declaration TibrvStatus getCount ( tibrv_u32 \u0026 numEvents) const; Purpose Extract the number of events in a queue."},"1077":{y:0,u:"../cpp-reference/TibrvQueue__getHandle__.htm",l:-1,t:"TibrvQueue::getHandle()",i:0.000214139117438805,a:"TibrvQueue::getHandle() Method Declaration tibrvQueue getHandle() const; Purpose Extract the C handle of this queue."},"1078":{y:0,u:"../cpp-reference/TibrvQueue__getLimitPolicy__.htm",l:-1,t:"TibrvQueue::getLimitPolicy()",i:0.00026635373417215,a:"TibrvQueue:: getLimitPolicy() Method Declaration TibrvStatus getLimitPolicy (     tibrvQueueLimitPolicy\u0026 policy,      tibrv_u32 \u0026 maxEvents,      tibrv_u32 \u0026 discardAmount) const; Purpose Extract the limit properties of a queue. See Also tibrvQueueLimitPolicy in TIBCO Rendezvous C Reference ..."},"1079":{y:0,u:"../cpp-reference/TibrvQueue__getName__.htm",l:-1,t:"TibrvQueue::getName()",i:0.000391299687269448,a:"TibrvQueue:: getName() Method Declaration TibrvStatus getName (const char*\u0026 queueName) const; Purpose Extract the name of a queue. Remarks Queue names assist programmers and administrators in troubleshooting queues. When Rendezvous software delivers an advisory message pertaining to a queue, it ..."},"1080":{y:0,u:"../cpp-reference/TibrvQueue__getPriority__.htm",l:-1,t:"TibrvQueue::getPriority()",i:0.000310014113256755,a:"TibrvQueue:: getPriority() Method Declaration TibrvStatus getPriority ( tibrv_u32 \u0026 priority) const; Purpose Extract the priority of a queue. Remarks Each queue has a single priority value, which controls its dispatch precedence within queue groups. Higher values dispatch before lower values; queues ..."},"1081":{y:0,u:"../cpp-reference/TibrvQueue__isValid__.htm",l:-1,t:"TibrvQueue::isValid()",i:0.000214139117438805,a:"TibrvQueue:: isValid() Method Declaration tibrv_bool isValid () const; Purpose Test validity of a queue. Remarks Returns TIBRV_TRUE if the queue is valid; TIBRV_FALSE if the queue has been destroyed. See Also Tibrv::close() TibrvQueue::destroy()"},"1082":{y:0,u:"../cpp-reference/TibrvQueue__poll__.htm",l:-1,t:"TibrvQueue::poll()",i:0.000411694030723481,a:"TibrvQueue:: poll() Method Declaration virtual  TibrvStatus poll (); Purpose Dispatch an event, if possible. Remarks If the queue is not empty, then this call dispatches the event at the head of the queue, and then returns. If the queue is empty, then this call returns immediately. When the call ..."},"1083":{y:0,u:"../cpp-reference/TibrvQueue__setLimitPolicy__.htm",l:-1,t:"TibrvQueue::setLimitPolicy()",i:0.000307143348032562,a:"TibrvQueue:: setLimitPolicy() Method Declaration TibrvStatus setLimitPolicy (      tibrvQueueLimitPolicy  policy,      tibrv_u32  maxEvents,      tibrv_u32  discardAmount); Purpose Set the limit properties of a queue. Remarks This method simultaneously sets three related properties, which together ..."},"1084":{y:0,u:"../cpp-reference/TibrvQueue__setName__.htm",l:-1,t:"TibrvQueue::setName()",i:0.000416846168588456,a:"Method Declaration TibrvStatus setName  (const char* queueName); Purpose Set the name of a queue. Remarks Queue names assist programmers and administrators in troubleshooting queues. When Rendezvous software delivers an advisory message pertaining to a queue, it includes the queue’s name; ..."},"1085":{y:0,u:"../cpp-reference/TibrvQueue__setPriority__.htm",l:-1,t:"TibrvQueue::setPriority()",i:0.000338380676210864,a:"TibrvQueue:: setPriority() Method Declaration TibrvStatus setPriority( tibrv_u32  priority); Purpose Set the priority of a queue. Remarks Each queue has a single priority value, which controls its dispatch precedence within queue groups. Higher values dispatch before lower values; queues with equal ..."},"1086":{y:0,u:"../cpp-reference/TibrvQueue__timedDispatch__.htm",l:-1,t:"TibrvQueue::timedDispatch()",i:0.000417417625408039,a:"TibrvQueue:: timedDispatch() Method Declaration virtual  TibrvStatus timedDispatch(tibrv_f64 timeout); Purpose Dispatch an event, but if no event is ready to dispatch, limit the time that this call blocks while waiting for an event. Remarks If an event is already in the queue, this call dispatches ..."},"1087":{y:0,u:"../cpp-reference/TibrvQueueOnComplete.htm",l:-1,t:"TibrvQueueOnComplete",i:0.000377095478061046,a:"TibrvQueueOnComplete Class Declaration class TibrvQueueOnComplete Purpose Run program code after all callback methods of a destroyed queue have completed. Remarks Implement this interface to post-process destroyed queues."},"1088":{y:0,u:"../cpp-reference/TibrvQueueOnComplete__onComplete__.htm",l:-1,t:"TibrvQueueOnComplete::onComplete()",i:0.000458642262824005,a:"Method Declaration virtual void onComplete(      TibrvQueue * queue,     void* closure) Purpose A program can destroy a queue object even when callback methods from its events are running in one or more threads. Multi-threaded programs can define methods of this type to discover when all event ..."},"1089":{y:0,u:"../cpp-reference/TibrvQueueGroup.htm",l:-1,t:"TibrvQueueGroup",i:0.000523301017251051,a:"Class Declaration class TibrvQueueGroup : public  TibrvDispatchable     TibrvQueueGroup();             // Create empty.     virtual ~TibrvQueueGroup();    // Destroy and reclaim storage. Purpose Prioritized dispatch of several queues with one call. Remarks Queue groups add flexibility and ..."},"1090":{y:0,u:"../cpp-reference/TibrvQueueGroup__add__.htm",l:-1,t:"TibrvQueueGroup::add()",i:0.000262553893973523,a:"TibrvQueueGroup:: add() Method Declaration virtual  TibrvStatus add(      TibrvQueue * queue); Purpose Add an event queue to a queue group. Remarks If the queue is already in the group, adding it again has no effect. See Also TibrvQueue"},"1091":{y:0,u:"../cpp-reference/TibrvQueueGroup__create__.htm",l:-1,t:"TibrvQueueGroup::create()",i:0.000346866097263261,a:"Method Declaration TibrvStatus create(); Purpose Create an event queue group. Remarks This method creates a C queue group and stores its handle in the C++ object. The new queue group is empty. The queue group remains valid until the program explicitly destroys it. See Also TibrvQueueGroup::add() ..."},"1092":{y:0,u:"../cpp-reference/TibrvQueueGroup__destroy__.htm",l:-1,t:"TibrvQueueGroup::destroy()",i:0.000429624695009979,a:"TibrvQueueGroup:: destroy() Method Declaration TibrvStatus destroy (); Purpose Destroy an event queue group. Remarks The individual queues in the group continue to exist, even though the group has been destroyed. See Also TibrvQueueGroup::create()"},"1093":{y:0,u:"../cpp-reference/TibrvQueueGroup__dispatch__.htm",l:-1,t:"TibrvQueueGroup::dispatch()",i:0.000350287759314293,a:"TibrvQueueGroup:: dispatch() Method Declaration virtual  TibrvStatus dispatch(); Purpose Dispatch an event from a queue group; if no event is ready, block. Remarks If any queue in the group contains an event, then this call searches the queues in priority order, dispatches an event from the first ..."},"1094":{y:0,u:"../cpp-reference/TibrvQueueGroup__getHandle__.htm",l:-1,t:"TibrvQueueGroup::getHandle()",i:0.00016427473493734,a:"TibrvQueueGroup::getHandle() Method Declaration tibrvQueueGroup getHandle() const; Purpose Extract the C handle of this queue group."},"1095":{y:0,u:"../cpp-reference/TibrvQueueGroup__isValid__.htm",l:-1,t:"TibrvQueueGroup::isValid()",i:0.00016427473493734,a:"TibrvQueueGroup:: isValid() Method Declaration tibrv_bool isValid() const; Purpose Test validity of a queue group. Remarks Returns TIBRV_TRUE if the queue group is valid; TIBRV_FALSE if the queue group has been destroyed. See Also Tibrv::close() TibrvQueueGroup::destroy()"},"1096":{y:0,u:"../cpp-reference/TibrvQueueGroup__poll__.htm",l:-1,t:"TibrvQueueGroup::poll()",i:0.00035157398769939,a:"TibrvQueueGroup:: poll() Method Declaration virtual  TibrvStatus poll(); Purpose Dispatch an event, but if no event is ready to dispatch, return immediately (without blocking). Remarks If any queue in the group contains an event, then this call searches the queues in priority order, dispatches an ..."},"1097":{y:0,u:"../cpp-reference/TibrvQueueGroup__remove__.htm",l:-1,t:"TibrvQueueGroup::remove()",i:0.00016427473493734,a:"TibrvQueueGroup:: remove() Method Declaration virtual  TibrvStatus remove( TibrvQueue * queue); Purpose Remove an event queue from a queue group. Remarks If the queue is not in the group, this call returns the status code  TIBRV_INVALID_QUEUE . See Also TibrvQueue"},"1098":{y:0,u:"../cpp-reference/TibrvQueueGroup__timedDispatch__.htm",l:-1,t:"TibrvQueueGroup::timedDispatch()",i:0.000357297582383948,a:"TibrvQueueGroup:: timedDispatch() Method Declaration virtual  TibrvStatus timedDispatch(tibrv_f64 timeout); Purpose Dispatch an event, but if no event is ready to dispatch, limit the time that this call blocks while waiting for an event. Remarks If any queue in the group contains an event, then this ..."},"1099":{y:0,u:"../cpp-reference/TibrvDispatcher.htm",l:-1,t:"TibrvDispatcher",i:0.000197693892903937,a:"Class Declaration class TibrvDispatcher     TibrvDispatcher();             // Create empty.     virtual ~TibrvDispatcher();    // Halt, destroy \u0026 reclaim storage. Purpose Dispatch events from a queue or queue group. Remarks A dispatcher thread repeatedly dispatches a queue or queue group by calling  ..."},"1100":{y:0,u:"../cpp-reference/TibrvDispatcher__create__.htm",l:-1,t:"TibrvDispatcher::create()",i:0.000156780690652565,a:"Method Declaration TibrvStatus create(      TibrvDispatchable * dispatchable,     tibrv_f64 idleTimeout = TIBRV_WAIT_FOREVER); Purpose Start a dispatcher thread. Remarks This method creates a C dispatcher thread and stores its handle in the C++ object. A dispatcher thread repeatedly dispatches a ..."},"1101":{y:0,u:"../cpp-reference/TibrvDispatcher__destroy__.htm",l:-1,t:"TibrvDispatcher::destroy()",i:0.000183433477162047,a:"Method Declaration TibrvStatus destroy(); Purpose Destroy a dispatcher thread. Remarks We do not recommend destroying a dispatcher thread within the same thread (for example, from within a listener callback function running within that thread). Although it is legal to do so, we discourage this ..."},"1102":{y:0,u:"../cpp-reference/TibrvDispatcher__getDispatchable__.htm",l:-1,t:"TibrvDispatcher::getDispatchable()",i:0.000156780690652565,a:"TibrvDispatcher::getDispatchable() Method Declaration TibrvDispatchable * getDispatchable() const; Purpose Extract the queue or queue group that this thread dispatches."},"1103":{y:0,u:"../cpp-reference/TibrvDispatcher__getHandle__.htm",l:-1,t:"TibrvDispatcher::getHandle()",i:0.000156780690652565,a:"TibrvDispatcher::getHandle() Method Declaration tibrvDispatcher getHandle() const; Purpose Extract the C handle of this dispatcher thread."},"1104":{y:0,u:"../cpp-reference/TibrvDispatcher__getName__.htm",l:-1,t:"TibrvDispatcher::getName()",i:0.000156780690652565,a:"TibrvDispatcher::getName() Method Declaration TibrvStatus getName(     const char*\u0026 name) const; Purpose Extract the name of a dispatcher thread."},"1105":{y:0,u:"../cpp-reference/TibrvDispatcher__isValid__.htm",l:-1,t:"TibrvDispatcher::isValid()",i:0.000156780690652565,a:"TibrvDispatcher:: isValid() Method Declaration tibrv_bool isValid() const; Purpose Test whether a dispatcher object has been destroyed. Remarks This method returns TIBRV_TRUE if the dispatcher object is valid, and TIBRV_FALSE if it has been destroyed."},"1106":{y:0,u:"../cpp-reference/TibrvDispatcher__setName__.htm",l:-1,t:"TibrvDispatcher::setName()",i:0.000183433477162047,a:"TibrvDispatcher::setName() Method Declaration TibrvStatus setName (const char* dispatchName); Purpose Set the name of a dispatcher thread.  "},"1107":{y:0,u:"../cpp-reference/Transports.htm",l:-1,t:"Transports",i:0.000138109532391816,a:"Transports Transports manage network connections and send outbound messages. This section presents the various transport classes and their methods. See Also TibrvCmTransport TibrvCmQueueTransport"},"1108":{y:0,u:"../cpp-reference/TibrvTransport.htm",l:-1,t:"TibrvTransport",i:0.00189441814054265,a:"Class Declaration class TibrvTransport     virtual ~TibrvTransport();    // Destroy and reclaim storage. Purpose A transport object represents a delivery mechanism for messages. Remarks A transport describes a carrier for messages—whether across a network, among processes on a single computer, or ..."},"1109":{y:0,u:"../cpp-reference/TibrvTransport__createInbox__.htm",l:-1,t:"TibrvTransport::createInbox()",i:0.000502360462924354,a:"TibrvTransport:: createInbox() Method Declaration TibrvStatus createInbox(     char* subjectString,      tibrv_u32  subjectLimit) const; Purpose Create a unique inbox subject name. Remarks This method creates inbox names that are unique throughout the transport scope. For network transports, inbox ..."},"1110":{y:0,u:"../cpp-reference/TibrvTransport__destroy__.htm",l:-1,t:"TibrvTransport::destroy()",i:0.000493972251009232,a:"TibrvTransport:: destroy() Method Declaration TibrvStatus destroy() Purpose Destroy a transport. Remarks Programs must explicitly destroy each transport object, either using this method, or by calling  Tibrv::close()  (which destroys all transports). Destroying a transport achieves these effects: ..."},"1111":{y:0,u:"../cpp-reference/TibrvTransport__getDescription__.htm",l:-1,t:"TibrvTransport::getDescription()",i:0.000396269883421468,a:"TibrvTransport:: getDescription() Method Declaration TibrvStatus getDescription(      const char** description) const; Purpose Extract the program description parameter from a transport. Remarks The description identifies your program to Rendezvous components. Browser administration interfaces ..."},"1112":{y:0,u:"../cpp-reference/TibrvTransport__getHandle__.htm",l:-1,t:"TibrvTransport::getHandle()",i:0.000382870103863309,a:"TibrvTransport::getHandle() Method Declaration tibrvTransport getHandle() const; Purpose Extract the C handle of this transport object."},"1113":{y:0,u:"../cpp-reference/TibrvTransport__isValid__.htm",l:-1,t:"TibrvTransport::isValid()",i:0.000522829897039239,a:"TibrvTransport:: isValid() Method Declaration virtual tibrv_bool isValid() const; Purpose Test validity of a transport. Remarks Returns TIBRV_TRUE if the transport is valid; TIBRV_FALSE if the transport has been destroyed. See Also Tibrv::close() TibrvTransport::destroy() TibrvCmTransport::destroy() ..."},"1114":{y:0,u:"../cpp-reference/TibrvTransport__requestReliability__.htm",l:-1,t:"TibrvTransport::requestReliability()",i:0.000232831050250103,a:"Method Declaration TibrvStatus requestReliability(      tibrv_f64            reliability); Purpose Request reliability interval (message retention time) for a service. Remarks This call lets application programs shorten the reliability interval of the specific service associated with a transport ..."},"1115":{y:0,u:"../cpp-reference/TibrvTransport__send__.htm",l:-1,t:"TibrvTransport::send()",i:0.000382870103863309,a:"TibrvTransport:: send() Method Declaration virtual  TibrvStatus send(     const  TibrvMsg \u0026 message); Purpose Send a message. Remarks The message must have a valid destination subject; see  TibrvMsg::setSendSubject() . See Also TibrvMsg::setSendSubject()"},"1116":{y:0,u:"../cpp-reference/TibrvTransport__sendReply__.htm",l:-1,t:"TibrvTransport::sendReply()",i:0.000382870103863309,a:"TibrvTransport:: sendReply() Method Declaration virtual  TibrvStatus sendReply(     const  TibrvMsg \u0026 replyMessage,     const  TibrvMsg \u0026 requestMessage); Purpose Send a reply message. Remarks This convenience call extracts the reply subject of an inbound request message, and sends an outbound reply ..."},"1117":{y:0,u:"../cpp-reference/TibrvTransport__sendRequest__.htm",l:-1,t:"TibrvTransport::sendRequest()",i:0.000447007283596922,a:"TibrvTransport:: sendRequest() Method Declaration virtual  TibrvStatus  sendRequest (     const  TibrvMsg \u0026 message,      TibrvMsg \u0026 reply,     tibrv_f64 timeout); Purpose Send a request message and wait for a reply. Blocking can Stall Event Dispatch Parameter Description message Send this message. ..."},"1118":{y:0,u:"../cpp-reference/TibrvTransport__setDescription__.htm",l:-1,t:"TibrvTransport::setDescription()",i:0.000823484293400833,a:"TibrvTransport:: setDescription() Method Declaration TibrvStatus setDescription(     const char* description); Purpose Set the program description parameter of a transport. Remarks The description identifies your program to Rendezvous components. Browser administration interfaces display the ..."},"1119":{y:0,u:"../cpp-reference/tibrvTransportBatchMode.htm",l:-1,t:"tibrvTransportBatchMode",i:0.000335162468809533,a:"tibrvTransportBatchMode Type Declaration typedef enum {     TIBRV_TRANSPORT_DEFAULT_BATCH,     TIBRV_TRANSPORT_TIMER_BATCH } tibrvTransportBatchMode; Purpose Specify the batch mode of a transport. See Also TibrvNetTransport::setBatchMode() Batch Modes for Transports in TIBCO Rendezvous Concepts"},"1120":{y:0,u:"../cpp-reference/TibrvProcessTransport.htm",l:-1,t:"TibrvProcessTransport",i:0.00057520800653077,a:"Class Declaration class TibrvProcessTransport : public  TibrvTransport Purpose The intra-process transport delivers messages among the threads of a program. Remarks The intra-process transport does not access the network. This class does not introduce any new methods. The call  Tibrv::open()  ..."},"1121":{y:0,u:"../cpp-reference/TibrvNetTransport.htm",l:-1,t:"TibrvNetTransport",i:0.000813037186288591,a:"Class Declaration class TibrvNetTransport : public  TibrvTransport     TibrvNetTransport();           // Construct empty.     virtual ~TibrvNetTransport();  // Destroy and reclaim storage. Purpose Deliver messages across a network. Remarks This class connects to rvd for network communications. The ..."},"1122":{y:0,u:"../cpp-reference/TibrvNetTransport__create__.htm",l:-1,t:"TibrvNetTransport::create()",i:0.00270391639630615,a:"Method Declaration TibrvStatus create(     const char* service = NULL,     const char* network = NULL,     const char* daemon  = NULL ); TibrvStatus createLicensed(     const char* service,     const char* network,     const char* daemon,     const char* license_ticket); Purpose Create a transport ..."},"1123":{y:0,u:"../cpp-reference/TibrvNetTransport__getDaemon__.htm",l:-1,t:"TibrvNetTransport::getDaemon()",i:0.000507098669008864,a:"TibrvNetTransport:: getDaemon() Method Declaration TibrvStatus getDaemon(     const char*\u0026 daemonString ) const; Purpose Extract the daemon parameter from this transport."},"1124":{y:0,u:"../cpp-reference/TibrvNetTransport__getNetwork__.htm",l:-1,t:"TibrvNetTransport::getNetwork()",i:0.000507098669008864,a:"TibrvNetTransport:: getNetwork() Method Declaration TibrvStatus getNetwork(     const char*\u0026 networkString) const; Purpose Return the network interface that this transport uses for communication."},"1125":{y:0,u:"../cpp-reference/TibrvNetTransport__getService__.htm",l:-1,t:"TibrvNetTransport::getService()",i:0.000507098669008864,a:"TibrvNetTransport:: getService() Method Declaration TibrvStatus getService(     const char*\u0026 serviceString) const; Purpose Return the effective service that this transport uses for communication."},"1126":{y:0,u:"../cpp-reference/TibrvNetTransport__setBatchMode__.htm",l:-1,t:"TibrvNetTransport::setBatchMode()",i:0.000463651317693182,a:"TibrvNetTransport:: setBatchMode() Method Declaration TibrvStatus setBatchMode(     tibrvTransportBatchMode mode); Purpose Set the batch mode parameter of a transport. Remarks The batch mode determines when the transport transmits outbound message data to rvd: As soon as possible (the initial ..."},"1127":{y:0,u:"../cpp-reference/Virtual_Circuits.htm",l:-1,t:"Virtual Circuits",i:0.000138109532391816,a:"Virtual Circuits Virtual circuits feature Rendezvous communication between two terminals over an exclusive, continuous, monitored connection. See Also Virtual Circuits in TIBCO Rendezvous Concepts"},"1128":{y:0,u:"../cpp-reference/TibrvVcTransport.htm",l:-1,t:"TibrvVcTransport",i:0.000358568750379966,a:"Class Declaration class TibrvVcTransport : public  TibrvTransport     TibrvVcTransport();           // Construct empty.     virtual ~TibrvVcTransport();  // Destroy and reclaim storage. Purpose A virtual circuit transport object represents a terminal in a potential circuit. Remarks A virtual circuit ..."},"1129":{y:0,u:"../cpp-reference/TibrvVcTransport__createAcceptVc__.htm",l:-1,t:"TibrvVcTransport::createAcceptVc()",i:0.000294884900187718,a:"Method Declaration TibrvStatus createAcceptVc(     const char**       connectSubject,      TibrvTransport *    transport); Purpose Create a virtual circuit accept object. Remarks This method creates a C accept transport and stores its handle in the C++ object. Test Before Using Either of two ..."},"1130":{y:0,u:"../cpp-reference/TibrvVcTransport__createConnectVc__.htm",l:-1,t:"TibrvVcTransport::createConnectVc()",i:0.000277657896394295,a:"Method Declaration TibrvStatus createConnectVc(     const char*        connectSubject,      TibrvTransport *    transport); Purpose Create a virtual circuit connect object. Remarks This method creates a C connect transport and stores its handle in the C++ object. Test Before Using Either of two ..."},"1131":{y:0,u:"../cpp-reference/TibrvVcTransport__waitForVcConnection__.htm",l:-1,t:"TibrvVcTransport::waitForVcConnection()",i:0.000262332581821601,a:"Method Declaration TibrvStatus waitForVcConnection(     tibrv_f64         timeout); Purpose Test the connection status of a virtual circuit. Remarks This method tests (and can block) until this virtual circuit transport object has established a connection with its opposite terminal. You may call ..."},"1132":{y:0,u:"../cpp-reference/Fault_Tolerance.htm",l:-1,t:"Fault Tolerance",i:0.00027221348930084,a:"Rendezvous fault tolerance software coordinates a group of redundant processes into a fault-tolerant distributed program. Some processes actively fulfill the tasks of the program, while other processes wait in readiness. When one of the active processes fails, another process rapidly assumes active ..."},"1133":{y:0,u:"../cpp-reference/Fault_Tolerance_Road_Map.htm",l:-1,t:"Fault Tolerance Road Map",i:0.000138109532391816,a:"For a complete discussion of concepts and operating principles, see  Fault Tolerance Concepts . For suggestions to help you design programs using fault tolerance features, see  Fault Tolerance Programming . For step-by-step hints for implementing fault-tolerant systems, see  Developing Fault ..."},"1134":{y:0,u:"../cpp-reference/tibrvftAction.htm",l:-1,t:"tibrvftAction",i:0.000989848104401387,a:"Type Declaration typedef enum {     TIBRVFT_PREPARE_TO_ACTIVATE = 1,     TIBRVFT_ACTIVATE            = 2,     TIBRVFT_DEACTIVATE          = 3 } tibrvftAction; Purpose Instruct fault tolerance callback methods to react to changing circumstances. Remarks Each token of this enumerated type designates a ..."},"1135":{y:0,u:"../cpp-reference/TibrvFtMember.htm",l:-1,t:"TibrvFtMember",i:0.000573546038253285,a:"Class Declaration class TibrvFtMember     TibrvFtMember();             // Create empty.     virtual ~TibrvFtMember();    // Destroy and reclaim storage. Purpose Represent membership in a fault tolerance group. Remarks The constructor creates a hollow object;  TibrvFtMember::create()  makes it ..."},"1136":{y:0,u:"../cpp-reference/TibrvFtMember__create__.htm",l:-1,t:"TibrvFtMember::create()",i:0.00179132713704683,a:"Method Declaration TibrvStatus create(      TibrvQueue * queue,      TibrvFtMemberCallback * callback,      TibrvTransport * transport,     const char* groupName,     tibrv_u16  weight,     tibrv_u16  activeGoal,     tibrv_f64  heartbeatInterval,     tibrv_f64  preparationInterval,     tibrv_f64  ..."},"1137":{y:0,u:"../cpp-reference/TibrvFtMember__destroy__.htm",l:-1,t:"TibrvFtMember::destroy()",i:0.000720304141608051,a:"TibrvFtMember:: destroy() Method Declaration TibrvStatus destroy(      TibrvFtMemberOnComplete * completeCB = NULL); Purpose Destroy a member of a fault tolerance group. Remarks By destroying a member object, the program cancels or withdraws its membership in the group. If the member is active, it ..."},"1138":{y:0,u:"../cpp-reference/TibrvFtMember__getClosure__.htm",l:-1,t:"TibrvFtMember::getClosure()",i:0.000178735943047217,a:"TibrvFtMember:: getClosure() Method Declaration void* getClosure() const; Purpose Extract the closure data of a fault tolerance member. See Also TibrvFtMember::create()"},"1139":{y:0,u:"../cpp-reference/TibrvFtMember__getGroupName__.htm",l:-1,t:"TibrvFtMember::getGroupName()",i:0.000178735943047217,a:"TibrvFtMember:: getGroupName() Method Declaration TibrvStatus getGroupName(     const char *\u0026 groupName) const; Purpose Extract the group name of a fault tolerance member. See Also TibrvFtMember::create()"},"1140":{y:0,u:"../cpp-reference/TibrvFtMember__getHandle__.htm",l:-1,t:"TibrvFtMember::getHandle()",i:0.000178735943047217,a:"TibrvFtMember::getHandle() Method Declaration tibrvftMember getHandle() const; Purpose Extract the C handle of a fault tolerance member. See Also TibrvFtMember::create() tibrvftMember"},"1141":{y:0,u:"../cpp-reference/TibrvFtMember__getQueue__.htm",l:-1,t:"TibrvFtMember::getQueue()",i:0.000178735943047217,a:"TibrvFtMember:: getQueue() Method Declaration TibrvQueue * getQueue () const; Purpose Extract the event queue of a fault tolerance member. Remarks If the member is invalid, this method returns NULL. See Also TibrvQueue TibrvFtMember::create()"},"1142":{y:0,u:"../cpp-reference/TibrvFtMember__getTransport__.htm",l:-1,t:"TibrvFtMember::getTransport()",i:0.000178735943047217,a:"TibrvFtMember:: getTransport() Method Declaration TibrvTransport * getTransport() const; Purpose Extract the transport of a fault tolerance member. See Also TibrvTransport TibrvFtMember::create()"},"1143":{y:0,u:"../cpp-reference/TibrvFtMember__getWeight__.htm",l:-1,t:"TibrvFtMember::getWeight()",i:0.000178735943047217,a:"TibrvFtMember:: getWeight() Method Declaration TibrvStatus getWeight(     tibrv_u16\u0026 weight) const; Purpose Extract the weight of a fault tolerance member. See Also TibrvFtMember::create()"},"1144":{y:0,u:"../cpp-reference/TibrvFtMember__isValid__.htm",l:-1,t:"TibrvFtMember::isValid()",i:0.000301188344937213,a:"TibrvFtMember:: isValid() Method Declaration tibrv_bool isValid() const; Purpose Test validity of a fault tolerance member object. Remarks Returns TIBRV_TRUE if the C member is valid; TIBRV_FALSE if the member has been destroyed or is otherwise invalid. See Also TibrvFtMember::destroy()"},"1145":{y:0,u:"../cpp-reference/TibrvFtMember__setWeight__.htm",l:-1,t:"TibrvFtMember::setWeight()",i:0.000178735943047217,a:"TibrvFtMember:: setWeight() Method Declaration TibrvStatus setWeight(     tibrv_u16  weight); Purpose Change the weight of a fault tolerance member within its group. Remarks Weight summarizes the relative suitability of a member for its task, relative to other members of the same fault tolerance ..."},"1146":{y:0,u:"../cpp-reference/TibrvFtMemberCallback.htm",l:-1,t:"TibrvFtMemberCallback",i:0.000396255524871178,a:"TibrvFtMemberCallback Class Declaration class TibrvFtMemberCallback Purpose Process fault tolerance events for a group member. Remarks Implement this interface to process fault tolerance events. See Also TibrvFtMember::create()"},"1147":{y:0,u:"../cpp-reference/TibrvFtMemberCallback__onFtAction__.htm",l:-1,t:"TibrvFtMemberCallback::onFtAction()",i:0.000727206993239772,a:"TibrvFtMemberCallback:: onFtAction() Method Declaration virtual void onFtAction(      TibrvFtMember * ftMember,     const char* groupName,      tibrvftAction  action ) = 0; Purpose Process fault tolerance events for a group member. Remarks Each member program of a fault tolerance group must ..."},"1148":{y:0,u:"../cpp-reference/TibrvFtMemberOnComplete.htm",l:-1,t:"TibrvFtMemberOnComplete",i:0.000328599216520723,a:"Class Declaration class TibrvFtMemberOnComplete Purpose A program can destroy a member object even when its callback method is running in one or more threads. Multi-threaded programs can define a subclass of this interface class to discover when all callback methods in progress have completed. See ..."},"1149":{y:0,u:"../cpp-reference/TibrvFtMemberOnComplete__onComplete.htm",l:-1,t:"TibrvFtMemberOnComplete::onComplete",i:0.000400217278371167,a:"Method Declaration virtual void onComplete(      TibrvFtMember * ftMember) = 0; Purpose A program can destroy a member object even when its callback method is running in one or more threads. Multi-threaded programs can define methods of this type to discover when all callback methods in progress ..."},"1150":{y:0,u:"../cpp-reference/TibrvFtMonitor.htm",l:-1,t:"TibrvFtMonitor",i:0.000308865704688153,a:"Class Declaration class TibrvFtMonitor     TibrvFtmonitor();             // Create empty.     virtual ~TibrvFtmonitor();    // Destroy and reclaim storage. Purpose Monitor a fault tolerance group. Remarks The constructor creates a hollow object;  TibrvFtMonitor::create()  makes it operational, and ..."},"1151":{y:0,u:"../cpp-reference/TibrvFtMonitor__create__.htm",l:-1,t:"TibrvFtMonitor::create()",i:0.00135611684835044,a:"Method Declaration TibrvStatus create(      TibrvQueue * queue,      TibrvFtMonitorCallback * callback,      TibrvTransport * transport,     const char* groupName,     tibrv_f64  lostInterval,     const void* closure = NULL); Purpose Monitor a fault tolerance group. Remarks The monitor callback ..."},"1152":{y:0,u:"../cpp-reference/TibrvFtMonitor__destroy__.htm",l:-1,t:"TibrvFtMonitor::destroy()",i:0.000544261767631967,a:"TibrvFtMonitor:: destroy() Method Declaration TibrvStatus destroy(      TibrvFtMonitorOnComplete * completeCB=NULL); Purpose Stop monitoring a fault tolerance group, and free associated resources. Remarks This method returns an error when the monitor object is already invalid, or when its queue or ..."},"1153":{y:0,u:"../cpp-reference/TibrvFtMonitor__getClosure__.htm",l:-1,t:"TibrvFtMonitor::getClosure()",i:0.000164363220251548,a:"TibrvFtMonitor:: getClosure() Method Declaration void* getClosure() const; Purpose Extract the closure data of a fault tolerance monitor. See Also TibrvFtMonitor::create()"},"1154":{y:0,u:"../cpp-reference/TibrvFtMonitor__getGroupName__.htm",l:-1,t:"TibrvFtMonitor::getGroupName()",i:0.000164363220251548,a:"TibrvFtMonitor:: getGroupName() Method Declaration TibrvStatus getGroupName(     const char*\u0026 groupName) const; Purpose Extract the group name of a fault tolerance monitor. See Also TibrvFtMonitor::create()"},"1155":{y:0,u:"../cpp-reference/TibrvFtMonitor__getHandle__.htm",l:-1,t:"TibrvFtMonitor::getHandle()",i:0.000164363220251548,a:"TibrvFtMonitor:: getHandle() Method Declaration tibrvftMonitor getHandle() const; Purpose Extract the C handle of a fault tolerance monitor. See Also TibrvFtMonitor::create() tibrvftMonitor"},"1156":{y:0,u:"../cpp-reference/TibrvFtMonitor__getQueue__.htm",l:-1,t:"TibrvFtMonitor::getQueue()",i:0.000164363220251548,a:"TibrvFtMonitor:: getQueue() Method Declaration TibrvQueue * getQueue() const; Purpose Extract the event queue of a fault tolerance monitor. Remarks If the monitor is invalid, this method returns NULL. See Also TibrvQueue TibrvFtMonitor::create()"},"1157":{y:0,u:"../cpp-reference/TibrvFtMonitor__getTransport__.htm",l:-1,t:"TibrvFtMonitor::getTransport()",i:0.000164363220251548,a:"TibrvFtMonitor:: getTransport() Method Declaration TibrvTransport * getTransport() const; Purpose Extract the transport of a fault tolerance monitor. See Also TibrvTransport TibrvFtMonitor::create()"},"1158":{y:0,u:"../cpp-reference/TibrvFtMonitor__isValid__.htm",l:-1,t:"TibrvFtMonitor::isValid()",i:0.000164363220251548,a:"TibrvFtMonitor:: isValid() Method Declaration tibrv_bool isValid() const; Purpose Test validity of a fault tolerance monitor object. Remarks Returns TIBRV_TRUE if the C monitor is valid; TIBRV_FALSE if the monitor has been destroyed or is otherwise invalid. See Also TibrvFtMonitor::destroy()"},"1159":{y:0,u:"../cpp-reference/TibrvFtMonitorCallback.htm",l:-1,t:"TibrvFtMonitorCallback",i:0.000356480613327563,a:"TibrvFtMonitorCallback Class Declaration class TibrvFtMonitorCallback Purpose Process fault tolerance events for a monitor. Remarks Implement this interface to process fault tolerance monitor events. See Also TibrvFtMonitor::create()"},"1160":{y:0,u:"../cpp-reference/TibrvFtMonitorCallback__onFtMonitor__.htm",l:-1,t:"TibrvFtMonitorCallback::onFtMonitor()",i:0.000289614383257647,a:"TibrvFtMonitorCallback:: onFtMonitor() Declaration virtual void onFtMonitor(      TibrvFtMonitor * ftMonitor,     const char* groupName,      tibrv_u32  numActiveMembers ) = 0; Purpose Process fault tolerance events for a monitor. Remarks A program must define a method of this type as a prerequisite ..."},"1161":{y:0,u:"../cpp-reference/TibrvFtMonitorOnComplete.htm",l:-1,t:"TibrvFtMonitorOnComplete",i:0.000340389688648502,a:"Class Declaration class TibrvFtMonitorOnComplete Purpose A program can destroy a monitor object even when its callback method is running in one or more threads. Multi-threaded programs can define a subclass of this interface class to discover when all callback methods in progress have completed. See ..."},"1162":{y:0,u:"../cpp-reference/TibrvFtMonitorOnComplete__onComplete.htm",l:-1,t:"TibrvFtMonitorOnComplete::onComplete",i:0.000282775695108528,a:"Method Declaration virtual void onComplete(      TibrvFtMonitor * ftMonitor) = 0; Purpose A program can destroy a monitor object even when its callback method is running in one or more threads. Multi-threaded programs can define methods of this type to discover when all callback methods in progress ..."},"1163":{y:0,u:"../cpp-reference/Certified_Message_Delivery.htm",l:-1,t:"Certified Message Delivery",i:0.000247422163322246,a:"Certified  Message Delivery Although Rendezvous communications are highly reliable, some applications require even stronger assurances of delivery. Certified delivery features offers greater certainty of delivery—even in situations where processes and their network connections are unstable. See Also ..."},"1164":{y:0,u:"../cpp-reference/TibrvCmListener.htm",l:-1,t:"TibrvCmListener",i:0.000886610513722548,a:"Class Declaration class TibrvCmListener :  TibrvEvent     TibrvCmListener();             // Create empty.     virtual ~TibrvCmListener();    // Destroy and reclaim storage. Purpose A certified delivery listener object listens for labeled messages and certified messages. Remarks The constructor ..."},"1165":{y:0,u:"../cpp-reference/TibrvCmListener__confirmMsg__.htm",l:-1,t:"TibrvCmListener::confirmMsg()",i:0.000274883442380401,a:"Method Declaration TibrvStatus confirmMsg(     const  TibrvMsg \u0026 msg); Purpose Explicitly confirm delivery of a certified message. Remarks Use this method only in programs that override automatic confirmation (see  TibrvCmListener::setExplicitConfirm() ). The default behavior of certified listeners ..."},"1166":{y:0,u:"../cpp-reference/TibrvCmListener__create__.htm",l:-1,t:"TibrvCmListener::create()",i:0.000357217906895672,a:"Method Declaration TibrvStatus create(      TibrvQueue * queue,      TibrvCmMsgCallback * cmMsgCallback,      TibrvCmTransport * cmTransport,     const char* subject,     const void* closure = NULL); Purpose Listen for messages that match the subject, and request certified delivery when available. ..."},"1167":{y:0,u:"../cpp-reference/TibrvCmListener__destroy__.htm",l:-1,t:"TibrvCmListener::destroy()",i:0.000332958846214603,a:"Method Declaration TibrvStatus destroy(     tibrv_bool cancelAgreements,      TibrvEventOnComplete * completeCB = NULL); Purpose Destroy a certified delivery listener. Canceling Agreements When destroying a certified delivery listener, a program can either cancel its certified delivery agreements ..."},"1168":{y:0,u:"../cpp-reference/TibrvCmListener__getSubject__.htm",l:-1,t:"TibrvCmListener::getSubject()",i:0.000179977486179379,a:"TibrvCmListener::getSubject() Method Declaration TibrvStatus getSubject(     const char*\u0026 subject) const; Purpose Extract the subject from a certified delivery listener. See Also TibrvCmListener"},"1169":{y:0,u:"../cpp-reference/TibrvCmListener__getTransport__.htm",l:-1,t:"TibrvCmListener::getTransport()",i:0.000179977486179379,a:"TibrvCmListener::getTransport() Method Declaration TibrvCmTransport * getTransport() const; Purpose Extract the transport from a certified delivery listener. See Also TibrvCmListener"},"1170":{y:0,u:"../cpp-reference/TibrvCmListener__isValid__.htm",l:-1,t:"TibrvCmListener::isValid()",i:0.000179977486179379,a:"TibrvCmListener:: isValid() Method Declaration tibrv_bool isValid() const; Purpose Test whether a certified delivery listener has been destroyed. Remarks This method returns TIBRV_TRUE if the listener is valid, and TIBRV_FALSE if it has been destroyed. Notice that  TibrvCmListener::destroy()  ..."},"1171":{y:0,u:"../cpp-reference/TibrvCmListener__setExplicitConfirm__.htm",l:-1,t:"TibrvCmListener::setExplicitConfirm()",i:0.000226707850574313,a:"Method Declaration TibrvStatus setExplicitConfirm(); Purpose Override automatic confirmation of delivery for this listener. Remarks The default behavior of certified listeners is to automatically confirm delivery when the callback method returns (see  TibrvMsgCallback::onMsg() ). This call ..."},"1172":{y:0,u:"../cpp-reference/TibrvCmTransport.htm",l:-1,t:"TibrvCmTransport",i:0.00118269894840785,a:"Class Declaration class TibrvCmTransport : public  TibrvTransport Purpose A certified delivery transport object implements the CM delivery protocol for messages. Remarks Each certified delivery transport employs a  TibrvTransport  for network communications. The  TibrvCmTransport  adds the ..."},"1173":{y:0,u:"../cpp-reference/TibrvCmTransport__addListener__.htm",l:-1,t:"TibrvCmTransport::addListener()",i:0.000251472073649426,a:"Method Declaration TibrvStatus addListener(     const char* cmName,     const char* subject); Purpose Pre-register an anticipated listener. Remarks Some sending programs can anticipate requests for certified delivery—even before the listening programs actually register. In such situations, the ..."},"1174":{y:0,u:"../cpp-reference/TibrvCmTransport__allowListener__.htm",l:-1,t:"TibrvCmTransport::allowListener()",i:0.000279320607401572,a:"Method Declaration TibrvStatus allowListener(     const char* cmName); Purpose Invite the named receiver to reinstate certified delivery for its listeners, superseding the effect of any previous disallow calls. Remarks Upon receiving the invitation to reinstate certified delivery, Rendezvous ..."},"1175":{y:0,u:"../cpp-reference/TibrvCmTransport__create__.htm",l:-1,t:"TibrvCmTransport::create()",i:0.00133133198609985,a:"Method Declaration TibrvStatus create(      TibrvTransport * transport); TibrvStatus create(      TibrvTransport * transport,     const char* cmName,     tibrv_bool  requestOld,     const char* ledgerName = NULL,     tibrv_bool  syncLedger = TIBRV_FALSE); Purpose Create a transport for certified ..."},"1176":{y:0,u:"../cpp-reference/TibrvCmTransport__createInbox__.htm",l:-1,t:"TibrvCmTransport::createInbox()",i:0.000138109532391816,a:"TibrvCmTransport:: createInbox() Method Declaration TibrvStatus createInbox(     char* subjectString,      tibrv_u32  subjectLimit) const; Purpose Create a unique inbox subject name. Remarks This convenience method extracts the network transport, and then calls  TibrvTransport::createInbox() . For ..."},"1177":{y:0,u:"../cpp-reference/TibrvCmTransport__destroy__.htm",l:-1,t:"TibrvCmTransport::destroy()",i:0.000817911020994543,a:"Method Declaration TibrvStatus destroy(); TibrvStatus destroyEx(      TibrvCmTransportOnComplete * completeCB = NULL); Purpose Destroy a certified delivery transport. Remarks Destroying a certified delivery transport with a file-based ledger always leaves the ledger file intact; it neither erases ..."},"1178":{y:0,u:"../cpp-reference/TibrvCmTransport__disallowListener__.htm",l:-1,t:"TibrvCmTransport::disallowListener()",i:0.000385180842293893,a:"Method Declaration TibrvStatus disallowListener(     const char* cmName); Purpose Cancel certified delivery to all listeners at a specific correspondent. Deny subsequent certified delivery registration requests from those listeners. Remarks Disallowed listeners still receive subsequent messages from ..."},"1179":{y:0,u:"../cpp-reference/TibrvCmTransport__expireMessages__.htm",l:-1,t:"TibrvCmTransport::expireMessages()",i:0.000138109532391816,a:"Method Declaration TibrvStatus expireMessages(     const char*    subject,      tibrv_u64      sequenceNumber); Purpose Mark specified outbound CM messages as expired. Remarks This call checks the ledger for messages that match both the subject and sequence number criteria, and immediately marks ..."},"1180":{y:0,u:"../cpp-reference/TibrvCmTransport__getDefaultTimeLimit__.htm",l:-1,t:"TibrvCmTransport::getDefaultTimeLimit()",i:0.000391118531439336,a:"Method Declaration TibrvStatus getDefaultTimeLimit(     tibrv_f64\u0026 timeLimit) const; Purpose Get the default message time limit for all outbound certified messages from a transport. Remarks Every labeled message has a time limit, after which the sender no longer certifies delivery. Sending programs ..."},"1181":{y:0,u:"../cpp-reference/TibrvCmTransport__getLedgerName__.htm",l:-1,t:"TibrvCmTransport::getLedgerName()",i:0.000189127677926132,a:"Method Declaration TibrvStatus getLedgerName(     const char*\u0026 ledgerName) const; Purpose Extract the ledger name of a certified delivery transport. Errors The status code  TIBRV_ARG_CONFLICT  indicates that the transport does not have a ledger file. See Also Ledger File TibrvCmTransport::create()"},"1182":{y:0,u:"../cpp-reference/TibrvCmTransport__getName__.htm",l:-1,t:"TibrvCmTransport::getName()",i:0.000244024604627,a:"TibrvCmTransport::getName() Method Declaration TibrvStatus getName(     const char*\u0026 cmName) const; Purpose Extract the correspondent name of a certified delivery transport or distributed queue member. See Also Name TibrvCmTransport::create() TibrvCmQueueTransport::create()"},"1183":{y:0,u:"../cpp-reference/TibrvCmTransport__getRequestOld__.htm",l:-1,t:"TibrvCmTransport::getRequestOld()",i:0.000189127677926132,a:"TibrvCmTransport::getRequestOld() Method Declaration TibrvStatus getRequestOld(     tibrv_bool\u0026 requestOld) const; Purpose Extract the request old messages flag of a certified delivery transport. See Also requestOld TibrvCmTransport::create()"},"1184":{y:0,u:"../cpp-reference/TibrvCmTransport__getSyncLedger__.htm",l:-1,t:"TibrvCmTransport::getSyncLedger()",i:0.000278340013036622,a:"Method Declaration TibrvStatus getSyncLedger(     tibrv_bool\u0026 syncLedger) const; Purpose Extract the sync ledger flag of a certified delivery transport. Errors The status code  TIBRV_ARG_CONFLICT  indicates that the transport does not have a ledger file. See Also Ledger File ..."},"1185":{y:0,u:"../cpp-reference/TibrvCmTransport__getTransport__.htm",l:-1,t:"TibrvCmTransport::getTransport()",i:0.000189127677926132,a:"TibrvCmTransport::getTransport() Method Declaration TibrvTransport * getTransport() const; Purpose Extract the transport employed by a certified delivery transport or a distributed queue member. See Also TibrvTransport TibrvNetTransport TibrvCmTransport::create() TibrvCmQueueTransport::create()"},"1186":{y:0,u:"../cpp-reference/TibrvCmTransport__removeListener__.htm",l:-1,t:"TibrvCmTransport::removeListener()",i:0.000251472073649426,a:"Method Declaration TibrvStatus removeListener(     const char* cmName,     const char* subject); Purpose Unregister a specific listener at a specific correspondent, and free associated storage in the sender’s ledger. Remarks This method cancels certified delivery of the specific subject to the ..."},"1187":{y:0,u:"../cpp-reference/TibrvCmTransport__removeSendState__.htm",l:-1,t:"TibrvCmTransport::removeSendState()",i:0.000189127677926132,a:"Method Declaration TibrvStatus removeSendState(     const char* subject); Purpose Reclaim ledger space from obsolete subjects. Background In some programs subject names are useful only for a limited time; after that time, they are never used again. For example, consider a server program that sends ..."},"1188":{y:0,u:"../cpp-reference/TibrvCmTransport__reviewLedger__.htm",l:-1,t:"TibrvCmTransport::reviewLedger()",i:0.000538004925983808,a:"Method Declaration TibrvStatus reviewLedger(      TibrvCmReviewCallback * reviewCallback,     const char* subject,     const void* closure=NULL); Purpose Query the ledger for stored items related to a subject name. Remarks The callback method receives one message for each matching subject of ..."},"1189":{y:0,u:"../cpp-reference/TibrvCmTransport__send__.htm",l:-1,t:"TibrvCmTransport::send()",i:0.000556702106018884,a:"Method Declaration TibrvStatus send(     const  TibrvMsg \u0026 msg); Purpose Send a labeled message. Remarks This method sends the message, along with its certified delivery protocol information: the correspondent name of the  TibrvCmTransport , a sequence number, and a time limit. The protocol ..."},"1190":{y:0,u:"../cpp-reference/TibrvCmTransport__sendReply__.htm",l:-1,t:"TibrvCmTransport::sendReply()",i:0.00030219493168621,a:"Method Declaration TibrvStatus sendReply(     const  TibrvMsg \u0026 replyMsg,     const  TibrvMsg \u0026 requestMsg); Purpose Send a labeled reply message. Remarks This convenience call extracts the reply subject of an inbound request message, and sends a labeled outbound reply message to that subject. In ..."},"1191":{y:0,u:"../cpp-reference/TibrvCmTransport__sendRequest__.htm",l:-1,t:"TibrvCmTransport::sendRequest()",i:0.000320944330330704,a:"Method Declaration TibrvStatus sendRequest(     const  TibrvMsg \u0026 requestMsg,      TibrvMsg \u0026 replyMsg,     tibrv_f64 timeout); Purpose Send a labeled request message and wait for a reply. Blocking can Stall Event Dispatch Parameter Description requestMsg Send this request message. Wildcard subjects ..."},"1192":{y:0,u:"../cpp-reference/TibrvCmTransport__setDefaultTimeLimit__.htm",l:-1,t:"TibrvCmTransport::setDefaultTimeLimit()",i:0.000443793713921594,a:"Method Declaration TibrvStatus setDefaultTimeLimit(     tibrv_f64 timeLimit); Purpose Set the default message time limit for all outbound certified messages from a transport. Remarks Every labeled message has a time limit, after which the sender no longer certifies delivery. Sending programs can ..."},"1193":{y:0,u:"../cpp-reference/TibrvCmTransport__setPublisherInactivityDiscardInterval__.htm",l:-1,t:"TibrvCmTransport::setPublisherInactivityDiscardInterval()",i:0.000169525205670315,a:"Method Declaration TibrvStatus setPublisherInactivityDiscardInterval(     tibrv_i32    timeout); Purpose Set a time limit after which a listening CM transport can discard state for inactive CM senders. Remarks The timeout value limits the time that can elapse during which such a sender does not send ..."},"1194":{y:0,u:"../cpp-reference/TibrvCmTransport__syncLedger__.htm",l:-1,t:"TibrvCmTransport::syncLedger()",i:0.000314865378055995,a:"Method Declaration TibrvStatus syncLedger(); Purpose Synchronize the ledger to its storage medium. Remarks When this method returns, the transport’s current state is safely stored in the ledger file. Transports that use synchronous ledger files need not call this method, since the current state is ..."},"1195":{y:0,u:"../cpp-reference/TibrvCmTransportOnComplete.htm",l:-1,t:"TibrvCmTransportOnComplete",i:0.000369852635382952,a:"TibrvCmTransportOnComplete Class Declaration class TibrvCmTransportOnComplete Purpose Callback class to signal completion of clean-up tasks after destroying a CM or CMQ transport. See Also TibrvCmTransport::destroy()"},"1196":{y:0,u:"../cpp-reference/TibrvCmTransportOnComplete__onComplete.htm",l:-1,t:"TibrvCmTransportOnComplete::onComplete",i:0.000527040990394789,a:"Method Declaration virtual void onComplete(      TibrvCmTransport * destroyedTransport) = 0; Purpose Destroying a CM or CMQ transport involves cleanup operations that can sometimes be lengthy. Programs can define this method to discover when the cleanup has completed. Remarks Programs must not ..."},"1197":{y:0,u:"../cpp-reference/TibrvCmReviewCallback.htm",l:-1,t:"TibrvCmReviewCallback",i:0.000252436169921892,a:"TibrvCmReviewCallback Class Declaration class TibrvCmReviewCallback Purpose Process ledger review messages. Remarks Implement this interface to process ledger review messages. See Also TibrvCmTransport::reviewLedger()"},"1198":{y:0,u:"../cpp-reference/TibrvCmReviewCallback__onLedgerMsg__.htm",l:-1,t:"TibrvCmReviewCallback::onLedgerMsg()",i:0.000433400390638604,a:"Method Declaration virtual void* onLedgerMsg(      TibrvCmTransport * cmTransport,     const char* subject,      TibrvMsg \u0026 msg,     void* closure) = 0; Purpose Programs define this method to process ledger review messages. Remarks TibrvCmTransport::reviewLedger()  calls this callback method once ..."},"1199":{y:0,u:"../cpp-reference/TibrvCmMsg.htm",l:-1,t:"TibrvCmMsg",i:0.000160904375050703,a:"Class Declaration class TibrvCmMsg Purpose Define methods to manipulate labeled messages. Remarks This class is a collection of accessor methods. Programs do not create instances of  TibrvCmMsg . Instead, programs use its static methods to get and set certified delivery information of  TibrvMsg  ..."},"1200":{y:0,u:"../cpp-reference/TibrvCmMsg__getSender__.htm",l:-1,t:"TibrvCmMsg::getSender()",i:0.000322921572077337,a:"Method Declaration static  TibrvStatus getSender(      TibrvMsg \u0026 msg,     const char*\u0026 name); Purpose Extract the correspondent name of the sender from a certified message. Status This method returns a status code that discriminates between labeled messages and other messages. If the message is ..."},"1201":{y:0,u:"../cpp-reference/TibrvCmMsg__getSequence__.htm",l:-1,t:"TibrvCmMsg::getSequence()",i:0.000322921572077337,a:"Method Declaration static  TibrvStatus getSequence(      TibrvMsg \u0026 msg,     tibrv_u64\u0026 sequenceNumber); Purpose Extract the sequence number from a certified message. Remarks Rendezvous certified delivery sending methods automatically generate positive sequence numbers for outbound labeled messages. ..."},"1202":{y:0,u:"../cpp-reference/TibrvCmMsg__getTimeLimit__.htm",l:-1,t:"TibrvCmMsg::getTimeLimit()",i:0.00034427324711817,a:"Method Declaration static  TibrvStatus getTimeLimit(      TibrvMsg \u0026 msg,     tibrv_f64\u0026 timeLimit); Purpose Extract the message time limit from a certified message. Remarks Programs can explicitly set the message time limit (see  TibrvCmMsg::setTimeLimit() ). Zero is a special value, indicating no ..."},"1203":{y:0,u:"../cpp-reference/TibrvCmMsg__setTimeLimit__.htm",l:-1,t:"TibrvCmMsg::setTimeLimit()",i:0.000538222488164773,a:"Method Declaration static  TibrvStatus setTimeLimit (      TibrvMsg \u0026 msg,     tibrv_f64 timeLimit); Purpose Set the message time limit of a certified message. Remarks Every labeled message has a time limit, after which the sender no longer certifies delivery. Sending programs can explicitly set the ..."},"1204":{y:0,u:"../cpp-reference/TibrvCmMsgCallback.htm",l:-1,t:"TibrvCmMsgCallback",i:0.000329975570992033,a:"Class Declaration class TibrvCmMsgCallback : public  TibrvCallback Purpose Process inbound messages (CM listener events). Remarks Implement this interface to process inbound certified delivery messages. Related Classes TibrvCallback TibrvMsgCallback See Also TibrvCmListener::create()"},"1205":{y:0,u:"../cpp-reference/TibrvCmMsgCallback__onCmMsg__.htm",l:-1,t:"TibrvCmMsgCallback::onCmMsg()",i:0.000389128613693643,a:"TibrvCmMsgCallback:: onCmMsg() Method Declaration virtual void onCmMsg(      TibrvCmListener * cmListener,      TibrvMsg \u0026 msg) = 0; Purpose Process inbound certified delivery messages (CM listener events). Remarks Implement this method to process inbound certified delivery messages. CM Label ..."},"1206":{y:0,u:"../cpp-reference/Distributed_Queue.htm",l:-1,t:"Distributed Queue",i:0.000138109532391816,a:"Programs can use distributed queues for one of n certified delivery to a group of worker processes. A distributed queue is a group of  TibrvCmQueueTransport  objects, each in a separate process. From the outside, a distributed queue appears as though a single transport object; inside, the group ..."},"1207":{y:0,u:"../cpp-reference/TibrvCmQueueTransport.htm",l:-1,t:"TibrvCmQueueTransport",i:0.000899401293969629,a:"Class Declaration class TibrvCmQueueTransport : public  TibrvCmTransport     TibrvCmQueueTransport();             // Create empty.     virtual ~TibrvCmQueueTransport();    // Destroy and reclaim storage. Purpose Coordinate a distributed queue for one-of-n delivery. Remarks Each  ..."},"1208":{y:0,u:"../cpp-reference/TibrvCmQueueTransport__create__.htm",l:-1,t:"TibrvCmQueueTransport::create()",i:0.000534907191408117,a:"Method Declaration TibrvStatus create(    TibrvTransport * transport,   const char* cmName,    tibrv_u32  workerWeight = TIBRVCM_DEFAULT_WORKER_WEIGHT,    tibrv_u32  workerTasks  = TIBRVCM_DEFAULT_WORKER_TASKS,   tibrv_u16 schedulerWeight = TIBRVCM_DEFAULT_SCHEDULER_WEIGHT,   tibrv_f64 ..."},"1209":{y:0,u:"../cpp-reference/TibrvCmQueueTransport__destroy__.htm",l:-1,t:"TibrvCmQueueTransport::destroy()",i:0.00034459303547037,a:"TibrvCmQueueTransport::destroy() Method Declaration TibrvStatus destroy(); Purpose Destroy a distributed queue member object. Remarks Destroying a  TibrvCmQueueTransport  object removes the program from the distributed queue group. See Also TibrvCmQueueTransport::create()"},"1210":{y:0,u:"../cpp-reference/TibrvCmQueueTransport__getCompleteTime__.htm",l:-1,t:"TibrvCmQueueTransport::getCompleteTime()",i:0.000274282526853978,a:"TibrvCmQueueTransport::getCompleteTime() Method Declaration TibrvStatus getCompleteTime(     tibrv_f64\u0026 completeTime) const; Purpose Extract the worker complete time limit of a distributed queue member. See Also Distributed Queue, in TIBCO Rendezvous Concepts TibrvCmQueueTransport::setCompleteTime()"},"1211":{y:0,u:"../cpp-reference/TibrvCmQueueTransport__getUnassignedMessageCount__.htm",l:-1,t:"TibrvCmQueueTransport::getUnassignedMessageCount()",i:0.000157712004647632,a:"Function Declaration TibrvStatus getUnassignedMessageCount(      tibrv_u32 \u0026          msgCount) const; Purpose Extract the number of unassigned task messages from a distributed queue transport. Remarks An unassigned task message is a message received by the scheduler, but not yet assigned to any ..."},"1212":{y:0,u:"../cpp-reference/TibrvCmQueueTransport__getWorkerWeight__.htm",l:-1,t:"TibrvCmQueueTransport::getWorkerWeight()",i:0.00020026939344615,a:"TibrvCmQueueTransport::getWorkerWeight() Method Declaration TibrvStatus getWorkerWeight(     tibrv_u32\u0026 workerWeight) const; Purpose Extract the worker weight of a distributed queue member. See Also Distributed Queue TibrvCmQueueTransport::create() TibrvCmQueueTransport::setWorkerWeight()"},"1213":{y:0,u:"../cpp-reference/TibrvCmQueueTransport__getWorkerTasks__.htm",l:-1,t:"TibrvCmQueueTransport::getWorkerTasks()",i:0.00020026939344615,a:"TibrvCmQueueTransport:: getWorkerTasks() Method Declaration TibrvStatus getWorkerTasks(      tibrv_u32 \u0026 workerTasks) const; Purpose Extract the worker task capacity of a distributed queue member. See Also Distributed Queue, in TIBCO Rendezvous Concepts TibrvCmQueueTransport::create() ..."},"1214":{y:0,u:"../cpp-reference/TibrvCmQueueTransport__setCompleteTime__.htm",l:-1,t:"TibrvCmQueueTransport::setCompleteTime()",i:0.000274282526853978,a:"Method Declaration TibrvStatus setCompleteTime(     tibrv_f64  completeTime); Purpose Set the worker complete time limit of a distributed queue member. Remarks If the complete time is non-zero, the scheduler waits for a worker member to complete an assigned task. If the complete time elapses before ..."},"1215":{y:0,u:"../cpp-reference/TibrvCmQueueTransport__setTaskBacklogLimit_____.htm",l:-1,t:"TibrvCmQueueTransport::setTaskBacklogLimit...()",i:0.000157712004647632,a:"Method Declaration TibrvStatus setTaskBacklogLimitInBytes(      tibrv_u32     byteLimit); TibrvStatus setTaskBacklogLimitInMessages(      tibrv_u32     msgLimit); Purpose Set the scheduler task queue limits of a distributed queue transport. Remarks The scheduler stores tasks in a queue. These ..."},"1216":{y:0,u:"../cpp-reference/TibrvCmQueueTransport__setWorkerWeight__.htm",l:-1,t:"TibrvCmQueueTransport::setWorkerWeight()",i:0.00020026939344615,a:"Method Declaration TibrvStatus setWorkerWeight(      tibrv_u32   workerWeight); Purpose Set the worker weight of a distributed queue member. Remarks Relative worker weights assist the scheduler in assigning tasks. When the scheduler receives a task, it assigns the task to the available worker with ..."},"1217":{y:0,u:"../cpp-reference/TibrvCmQueueTransport__setWorkerTasks__.htm",l:-1,t:"TibrvCmQueueTransport::setWorkerTasks()",i:0.00020026939344615,a:"Method Declaration TibrvStatus setWorkerTasks(      tibrv_u32   workerTasks); Purpose Set the worker task capacity of a distributed queue member. Remarks Task capacity is the maximum number of tasks that a worker can accept. When the number of accepted tasks reaches this maximum, the worker cannot ..."},"1218":{y:0,u:"../cpp-reference/Datatypes.htm",l:-1,t:"Datatypes",i:0.000264800955263529,a:"Datatypes Rendezvous wire format datatypes are a standard, platform-independent convention for types and sizes. A parallel set of C datatypes represents data within programs. This section summarizes the two sets of datatypes, and the conversions among the various types."},"1219":{y:0,u:"../cpp-reference/Wire_Format_Datatypes.htm",l:-1,t:"Wire Format Datatypes",i:0.00545691159140271,a:"C Datatypes Datatype Conversion Rendezvous software converts datatypes in two situations: As it translates a message to wire format (when sending a message). As it extracts data from a message field. Convenience methods that extract a field from a Rendezvous message automatically decode the field’s ..."},"1220":{y:0,u:"../cpp-reference/Status_and_Errors.htm",l:-1,t:"Status and Errors",i:0.000138109532391816,a:"Status and Errors"},"1221":{y:0,u:"../cpp-reference/TibrvStatus.htm",l:-1,t:"TibrvStatus",i:0.0215813912559274,a:"Class Declaration class TibrvStatus   TibrvStatus();                      // Construct empty.   TibrvStatus( tibrv_status  status);  // Construct from C status.   ~TibrvStatus();                    // Reclaim storage. Purpose Encapsulate status codes. Remarks Status codes are the enumerated values ..."},"1222":{y:0,u:"../cpp-reference/TibrvStatus__getCode__.htm",l:-1,t:"TibrvStatus::getCode()",i:0.00243115772176646,a:"TibrvStatus:: getCode() Method Declaration tibrv_status getCode() const; Purpose Extract the C status code from a status object."},"1223":{y:0,u:"../cpp-reference/TibrvStatus__getText__.htm",l:-1,t:"TibrvStatus::getText()",i:0.00243115772176646,a:"TibrvStatus:: getText() Method Declaration const char* getText() const; Purpose Extract an interpretive string from a status object."},"1224":{y:0,u:"../java-ref/Concepts.htm",l:-1,t:"Concepts",i:0.000138109532391816,a:"Concepts This section presents concepts specific to the TIBCO Rendezvous® Java language interface. For concepts that pertain to Rendezvous software in general, see the book  TIBCO Rendezvous Concepts."},"1225":{y:0,u:"../java-ref/Implementations.htm",l:-1,t:"Implementations",i:0.00120542481071229,a:"Implementations Rendezvous Java language interface offers several implementations.  Implementations  summarizes and compares them. To specify an implementation, see  Archive Files  and  Tibrv.open() ."},"1226":{y:0,u:"../java-ref/Strings_and_Character_Encodings.htm",l:-1,t:"Strings and Character Encodings",i:0.00381858514749205,a:"Rendezvous software uses strings in several roles: String data inside message fields Field names Subject names (and other associated strings that are not strictly inside the message) Certified delivery (CM) correspondent names Group names (fault tolerance) Encodings and Translation Java programs ..."},"1227":{y:0,u:"../java-ref/Interrupting_Event_Dispatch_Threads.htm",l:-1,t:"Interrupting Event Dispatch Threads",i:0.000587934211645398,a:"The Java method Thread.interrupt() is ineffective when all of these conditions are simultaneously true: Tibrv  is open using the native (JNI) implementation. The thread dispatches an event queue or queue group. The queue or queue group is empty of events. To effectively interrupt such a thread, a ..."},"1228":{y:0,u:"../java-ref/Network_Overview_rvd_Transports.htm",l:-1,t:"Network Overview—rvd Transports",i:0.000920518853073342,a:"Java Programs with rvd Transports  shows programs that communicate using rvd transports. In the top and bottom of  Java Programs with rvd Transports , Java applets run in two separate local networks. Browsers download the applets from an intranet web server (center), but the applets then communicate ..."},"1229":{y:0,u:"../java-ref/Intranet_Web_Site_Considerations.htm",l:-1,t:"Intranet Web Site Considerations",i:0.000138109532391816,a:"When you design Java programs that run on an intranet—using rvd transports to connect to the local network—pay special attention to these issues. Rendezvous Files Correct operation of programs requires the Rendezvous classes. The program searches for the archive file that contains the Rendezvous ..."},"1230":{y:0,u:"../java-ref/Programmer_s_Checklist.htm",l:-1,t:"Programmer’s Checklist",i:0.000138109532391816,a:"Programmer’s Checklist Consult this section for details of the application development cycle."},"1231":{y:0,u:"../java-ref/Checklist.htm",l:-1,t:"Checklist",i:0.000138109532391816,a:"Developers of Rendezvous programs can use this checklist during the four phases of the development cycle: installing Rendezvous software, coding your Java program, compiling your Java program, and running your program as either an independent application or as a browser applet. Install Install the ..."},"1232":{y:0,u:"../java-ref/Archive_Files.htm",l:-1,t:"Archive Files",i:0.000834546765921411,a:"Archive Files Archive Files  details the jar files for various implementations of Rendezvous for Java. Place the appropriate jar file in the CLASSPATH environment variable."},"1233":{y:0,u:"../java-ref/Shared_Library_Files.htm",l:-1,t:"Shared Library Files",i:0.00180053887715825,a:"Independent Java applications that use rvd transports must be able to access Rendezvous shared library files (C libraries).  Environment Variables for Shared Library Files  details the environment variables that direct Java applications to the Rendezvous installation directory. The installation ..."},"1234":{y:0,u:"../java-ref/_Environment.htm",l:-1,t:"Rendezvous Environment",i:0.000138109532391816,a:"Rendezvous Environment This brief section describes the methods that open and close the internal machinery upon which Rendezvous software depends."},"1235":{y:0,u:"../java-ref/Tibrv.htm",l:-1,t:"Tibrv",i:0.00120432841017786,a:"Class Declaration class com.tibco.tibrv.Tibrv.Tibrv   extends java.lang.Object Purpose The Rendezvous environment. Remarks Programs do not create instances of  Tibrv . Instead, programs use its static methods to open and close the Rendezvous environment. Private constants and variables contain ..."},"1236":{y:0,u:"../java-ref/Tibrv_close__.htm",l:-1,t:"Tibrv.close()",i:0.0021295671802509,a:"Tibrv. close() Method Declaration static void close() throws  TibrvException Purpose Stop and destroy Rendezvous internal machinery. Remarks After  Tibrv.close()  destroys the internal machinery, Rendezvous software becomes inoperative: Events no longer arrive in queues. All events, queues and queue ..."},"1237":{y:0,u:"../java-ref/Tibrv_defaultQueue__.htm",l:-1,t:"Tibrv.defaultQueue()",i:0.000476519534799255,a:"Tibrv. defaultQueue() Method Declaration static  TibrvQueue defaultQueue() Purpose Extract the default queue object. Remarks If Rendezvous is not open, this method returns null. Each process has exactly one default queue; the call  Tibrv.open()  automatically creates it. Programs must not destroy ..."},"1238":{y:0,u:"../java-ref/Tibrv_getErrorCallback__.htm",l:-1,t:"Tibrv.getErrorCallback()",i:0.000551771711167753,a:"Tibrv. getErrorCallback() Method Declaration static  TibrvErrorCallback getErrorCallback() Purpose Extract the callback object that processes asynchronous errors. Remarks If the program has not set an error callback, this method returns null. See Also Tibrv.setErrorCallback() TibrvErrorCallback"},"1239":{y:0,u:"../java-ref/Tibrv_getVersion__.htm",l:-1,t:"Tibrv.getVersion()",i:0.00022341679363508,a:"Tibrv. getVersion() Method Declaration static String getVersion() static String getCmVersion() static String getFtVersion() static int    getMajorVersion() static int    getMinorVersion() static int    getUpdateVersion() static String getVersionString()     // This method is deprecated // Purpose ..."},});