define({"1421":{y:0,u:"../java-ref/Certified_Message_Delivery.htm",l:-1,t:"Certified Message Delivery",i:0.000247422163322246,a:"Certified  Message Delivery Although Rendezvous communications are highly reliable, some applications require even stronger assurances of delivery. Certified delivery features offers greater certainty of delivery—even in situations where processes and their network connections are unstable. See Also ..."},"1422":{y:0,u:"../java-ref/TibrvCmListener.htm",l:-1,t:"TibrvCmListener",i:0.000524850106779624,a:"Class Declaration class com.tibco.tibrv.TibrvCmListener   extends  TibrvListener Purpose A certified delivery listener object listens for labeled messages and certified messages. Remarks Each call to the constructor  TibrvCmListener()  results in a new certified delivery listener, which represents ..."},"1423":{y:0,u:"../java-ref/TibrvCmListener__.htm",l:-1,t:"TibrvCmListener()",i:0.000254642837780764,a:"Constructor Declaration TibrvCmListener(      TibrvQueue         queue,      TibrvMsgCallback   callback,      TibrvCmTransport   cmTransport,     java.lang.String  subject,     java.lang.Object  closure)   throws  TibrvException Purpose Listen for messages that match the subject, and request ..."},"1424":{y:0,u:"../java-ref/TibrvCmListener_destroy__.htm",l:-1,t:"TibrvCmListener.destroy()",i:0.000175286570750811,a:"Method Declaration void destroy() void destroy(     boolean    cancelAgreements) Purpose Destroy a certified delivery listener. Canceling Agreements When destroying a certified delivery listener, a program can either cancel its certified delivery agreements with senders, or let those agreements ..."},"1425":{y:0,u:"../java-ref/TibrvCmListener_confirmMsg__.htm",l:-1,t:"TibrvCmListener.confirmMsg()",i:0.00031156328826844,a:"Method Declaration void confirmMsg(      TibrvMsg     message)   throws  TibrvException Purpose Explicitly confirm delivery of a certified message. Remarks Use this method only in programs that override automatic confirmation (see  TibrvCmListener.setExplicitConfirm() ). The default behavior of ..."},"1426":{y:0,u:"../java-ref/TibrvCmListener_isExplicitConfirm__.htm",l:-1,t:"TibrvCmListener.isExplicitConfirm()",i:0.000220556580195344,a:"Method Declaration boolean isExplicitConfirm() Purpose Test whether this listener expects explicit confirmation of delivery. Remarks The default behavior of certified listeners is to automatically confirm delivery when the callback method returns (see  TibrvMsgCallback.onMsg() ).  ..."},"1427":{y:0,u:"../java-ref/TibrvCmListener_setExplicitConfirm__.htm",l:-1,t:"TibrvCmListener.setExplicitConfirm()",i:0.000266293278823906,a:"Method Declaration void setExplicitConfirm()   throws  TibrvException Purpose Override automatic confirmation of delivery for this listener. Remarks The default behavior of certified listeners is to automatically confirm delivery when the callback method returns (see  TibrvMsgCallback.onMsg() ). ..."},"1428":{y:0,u:"../java-ref/TibrvCmTransport.htm",l:-1,t:"TibrvCmTransport",i:0.000890760346881196,a:"Class Declaration class com.tibco.tibrv.TibrvCmTransport   extends  TibrvTransport Purpose A certified delivery transport object implements the CM delivery protocol for messages. Remarks Each certified delivery transport employs a  TibrvTransport  for network communications. The  TibrvCmTransport  ..."},"1429":{y:0,u:"../java-ref/TibrvCmTransport__.htm",l:-1,t:"TibrvCmTransport()",i:0.00170595629131598,a:"Method Declaration TibrvCmTransport(      TibrvRvdTransport   transport)   throws  TibrvException TibrvCmTransport(      TibrvRvdTransport   transport,     java.lang.String   cmName,     boolean            requestOld)   throws  TibrvException TibrvCmTransport(      TibrvRvdTransport   transport, ..."},"1430":{y:0,u:"../java-ref/TibrvCmTransport_addListener__.htm",l:-1,t:"TibrvCmTransport.addListener()",i:0.000236413971921115,a:"Method Declaration void addListener(     java.lang.String    cmName,     java.lang.String    subject)   throws  TibrvException Purpose Pre-register an anticipated listener. Remarks Some sending programs can anticipate requests for certified delivery—even before the listening programs actually ..."},"1431":{y:0,u:"../java-ref/TibrvCmTransport_allowListener__.htm",l:-1,t:"TibrvCmTransport.allowListener()",i:0.000250178760676608,a:"Method Declaration void allowListener(     java.lang.String    cmName)   throws  TibrvException Purpose Invite the named receiver to reinstate certified delivery for its listeners, superseding the effect of any previous disallow calls. Remarks Upon receiving the invitation to reinstate certified ..."},"1432":{y:0,u:"../java-ref/TibrvCmTransport_destroy__.htm",l:-1,t:"TibrvCmTransport.destroy()",i:0.000520507300797688,a:"Method Declaration void destroy() void destroyEx() Purpose Destroy a certified delivery transport. Remarks Destroying a certified delivery transport with a file-based ledger always leaves the ledger file intact; it neither erases nor removes a ledger file. Distributed Queue To destroy a distributed ..."},"1433":{y:0,u:"../java-ref/TibrvCmTransport_disallowListener__.htm",l:-1,t:"TibrvCmTransport.disallowListener()",i:0.00034977050914653,a:"Method Declaration void disallowListener(     java.lang.String    cmName)   throws  TibrvException Purpose Cancel certified delivery to all listeners at a specific correspondent. Deny subsequent certified delivery registration requests from those listeners. Remarks Disallowed listeners still receive ..."},"1434":{y:0,u:"../java-ref/TibrvCmTransport_expireMessages__.htm",l:-1,t:"TibrvCmTransport.expireMessages()",i:0.000162533730813201,a:"Method Declaration void expireMessages(     String    subject,     long      sequenceNumber)   throws  TibrvException ; Purpose Mark specified outbound CM messages as expired. Remarks This call checks the ledger for messages that match both the subject and sequence number criteria, and immediately ..."},"1435":{y:0,u:"../java-ref/TibrvCmTransport_getDefaultTimeLimit__.htm",l:-1,t:"TibrvCmTransport.getDefaultTimeLimit()",i:0.000412928584363542,a:"Method Declaration double getDefaultTimeLimit() Purpose Get the default message time limit for all outbound certified messages from a transport. Remarks Every labeled message has a time limit, after which the sender no longer certifies delivery. Sending programs can explicitly set the time limit on ..."},"1436":{y:0,u:"../java-ref/TibrvCmTransport_getLedgerName__.htm",l:-1,t:"TibrvCmTransport.getLedgerName()",i:0.00018258738829393,a:"Method Declaration java.lang.String getLedgerName() Purpose Extract the ledger name of a certified delivery transport. Errors The error code  TibrvStatus.ARG_CONFLICT  can indicate that the transport does not have a ledger file. See Also Ledger File TibrvCmTransport()"},"1437":{y:0,u:"../java-ref/TibrvCmTransport_getName__.htm",l:-1,t:"TibrvCmTransport.getName()",i:0.000227364325635758,a:"TibrvCmTransport.getName() Method Declaration java.lang.String getName() Purpose Extract the correspondent name of a certified delivery transport or distributed queue member. See Also Name TibrvCmTransport() TibrvCmQueueTransport()"},"1438":{y:0,u:"../java-ref/TibrvCmTransport_getRequestOld__.htm",l:-1,t:"TibrvCmTransport.getRequestOld()",i:0.00018258738829393,a:"TibrvCmTransport.getRequestOld() Method Declaration boolean getRequestOld() Purpose Extract the request old messages flag of a certified delivery transport. See Also requestOld TibrvCmTransport()"},"1439":{y:0,u:"../java-ref/TibrvCmTransport_getSyncLedger__.htm",l:-1,t:"TibrvCmTransport.getSyncLedger()",i:0.000272744302773576,a:"TibrvCmTransport.getSyncLedger() Method Declaration boolean getSyncLedger() Purpose Extract the sync ledger flag of a certified delivery transport. Errors The error code  TibrvStatus.ARG_CONFLICT  can indicate that the transport does not have a ledger file. See Also Ledger File TibrvCmTransport()"},"1440":{y:0,u:"../java-ref/TibrvCmTransport_getTransport__.htm",l:-1,t:"TibrvCmTransport.getTransport()",i:0.00018258738829393,a:"TibrvCmTransport.getTransport() Method Declaration TibrvRvdTransport getTransport() Purpose Extract the transport employed by a certified delivery transport or a distributed queue member. See Also TibrvTransport TibrvRvdTransport TibrvCmTransport() TibrvCmQueueTransport()"},"1441":{y:0,u:"../java-ref/TibrvCmTransport_removeListener__.htm",l:-1,t:"TibrvCmTransport.removeListener()",i:0.000236413971921115,a:"Method Declaration void removeListener(     java.lang.String    cmName,     java.lang.String    subject)   throws  TibrvException Purpose Unregister a specific listener at a specific correspondent, and free associated storage in the sender’s ledger. Remarks This method cancels certified delivery of ..."},"1442":{y:0,u:"../java-ref/TibrvCmTransport_removeSendState__.htm",l:-1,t:"TibrvCmTransport.removeSendState()",i:0.00018258738829393,a:"Method Declaration void removeSendState(     java.lang.String    subject)   throws  TibrvException Purpose Reclaim ledger space from obsolete subjects. Background In some programs subject names are useful only for a limited time; after that time, they are never used again. For example, consider a ..."},"1443":{y:0,u:"../java-ref/TibrvCmTransport_reviewLedger__.htm",l:-1,t:"TibrvCmTransport.reviewLedger()",i:0.000570471375126657,a:"Method Declaration void reviewLedger(      TibrvCmReviewCallback     callback,     java.lang.String         subject,     java.lang.Object         closure)   throws  TibrvException Purpose Query the ledger for stored items related to a subject name. Remarks The callback method receives one message ..."},"1444":{y:0,u:"../java-ref/TibrvCmTransport_send__.htm",l:-1,t:"TibrvCmTransport.send()",i:0.00052684422471332,a:"Method Declaration void send(      TibrvMsg     msg)   throws  TibrvException Purpose Send a labeled message. Remarks This method sends the message, along with its certified delivery protocol information: the correspondent name of the  TibrvCmTransport , a sequence number, and a time limit. The ..."},"1445":{y:0,u:"../java-ref/TibrvCmTransport_sendReply__.htm",l:-1,t:"TibrvCmTransport.sendReply()",i:0.000290228471791511,a:"Method Declaration void sendReply(      TibrvMsg     replyMsg,      TibrvMsg     requestMsg)   throws  TibrvException Purpose Send a labeled reply message. Remarks This convenience call extracts the reply subject of an inbound request message, and sends a labeled outbound reply message to that ..."},"1446":{y:0,u:"../java-ref/TibrvCmTransport_sendRequest__.htm",l:-1,t:"TibrvCmTransport.sendRequest()",i:0.000308235407154101,a:"Method Declaration TibrvMsg sendRequest(      TibrvMsg   msg,     double    timeout)   throws  TibrvException Purpose Send a labeled request message and wait for a reply. Blocking can Stall Event Dispatch Parameter Description msg Send this request message. Wildcard subjects are illegal. timeout ..."},"1447":{y:0,u:"../java-ref/TibrvCmTransport_setDefaultTimeLimit__.htm",l:-1,t:"TibrvCmTransport.setDefaultTimeLimit()",i:0.000508361755726596,a:"Method Declaration void setDefaultTimeLimit(     double    timeLimit)   throws  TibrvException Purpose Set the default message time limit for all outbound certified messages from a transport. Remarks Every labeled message has a time limit, after which the sender no longer certifies delivery. Sending ..."},"1448":{y:0,u:"../java-ref/TibrvCmTransport_setPublisherInactivityDiscardInterval__.htm",l:-1,t:"TibrvCmTransport.setPublisherInactivityDiscardInterval()",i:0.000162533730813201,a:"Method Declaration void setPublisherInactivityDiscardInterval(     int    timeout);   throws  TibrvException Purpose Set a time limit after which a listening CM transport can discard state for inactive CM senders. Remarks The timeout value limits the time that can elapse during which such a sender ..."},"1449":{y:0,u:"../java-ref/TibrvCmTransport_syncLedger__.htm",l:-1,t:"TibrvCmTransport.syncLedger()",i:0.000424265800654089,a:"Method Declaration void syncLedger()   throws  TibrvException Purpose Synchronize the ledger to its storage medium. Remarks When this method returns, the transport’s current state is safely stored in the ledger file. Transports that use synchronous ledger files need not call this method, since the ..."},"1450":{y:0,u:"../java-ref/TibrvCmReviewCallback.htm",l:-1,t:"TibrvCmReviewCallback",i:0.000259335237564559,a:"TibrvCmReviewCallback Interface Declaration interface com.tibco.tibrv.TibrvCmReviewCallback Purpose Process ledger review messages. Remarks Implement this interface to process ledger review messages. See Also TibrvCmTransport.reviewLedger()"},"1451":{y:0,u:"../java-ref/TibrvCmReviewCallback_onLedgerMsg__.htm",l:-1,t:"TibrvCmReviewCallback.onLedgerMsg()",i:0.000369553119716151,a:"Method Declaration boolean onLedgerMsg(      TibrvCmTransport     cmTransport,     java.lang.String    subject,      TibrvMsg             msg,     java.lang.Object    closure) Purpose Programs define this method to process ledger review messages. Remarks TibrvCmTransport.reviewLedger()  calls this ..."},"1452":{y:0,u:"../java-ref/TibrvCmMsg.htm",l:-1,t:"TibrvCmMsg",i:0.000160904375050703,a:"Class Declaration class com.tibco.tibrv.TibrvCmMsg   extends java.lang.Object Purpose Define methods to manipulate labeled messages. Remarks Programs do not create instances of  TibrvCmMsg . Instead, programs use its static methods to get and set certified delivery information of  TibrvMsg  objects. ..."},"1453":{y:0,u:"../java-ref/TibrvCmMsg_getSender__.htm",l:-1,t:"TibrvCmMsg.getSender()",i:0.000263392862671153,a:"Method Declaration static final java.lang.String getSender(      TibrvMsg     msg)   throws  TibrvException Purpose Extract the correspondent name of the sender from a certified message. Remarks If the message is from a CM sender, then  TibrvCmMsg.getSender()  yields a valid CM correspondent name. ..."},"1454":{y:0,u:"../java-ref/TibrvCmMsg_getSequence__.htm",l:-1,t:"TibrvCmMsg.getSequence()",i:0.000254698305284171,a:"Method Declaration static final long getSequence(      TibrvMsg     msg)   throws  TibrvException Purpose Extract the sequence number from a certified message. Remarks Rendezvous certified delivery sending methods automatically generate positive sequence numbers for outbound labeled messages. In ..."},"1455":{y:0,u:"../java-ref/TibrvCmMsg_getTimeLimit__.htm",l:-1,t:"TibrvCmMsg.getTimeLimit()",i:0.000304920595456736,a:"Method Declaration static final double getTimeLimit(      TibrvMsg     msg)   throws  TibrvException Purpose Extract the message time limit from a certified message. Remarks Programs can explicitly set the message time limit (see  TibrvCmMsg.setTimeLimit() ). Zero is a special value, indicating no ..."},"1456":{y:0,u:"../java-ref/TibrvCmMsg_setTimeLimit__.htm",l:-1,t:"TibrvCmMsg.setTimeLimit()",i:0.00060920647812532,a:"Method Declaration static final void setTimeLimit(      TibrvMsg     msg,     double      timeLimit)   throws  TibrvException Purpose Set the message time limit of a certified message. Remarks Every labeled message has a time limit, after which the sender no longer certifies delivery. Sending ..."},"1457":{y:0,u:"../java-ref/Distributed_Queue.htm",l:-1,t:"Distributed Queue",i:0.000138109532391816,a:"Programs can use distributed queues for one of n certified delivery to a group of worker processes. A distributed queue is a group of  TibrvCmQueueTransport  objects, each in a separate process. From the outside, a distributed queue appears as though a single transport object; inside, the group ..."},"1458":{y:0,u:"../java-ref/TibrvCmQueueTransport.htm",l:-1,t:"TibrvCmQueueTransport",i:0.000849327283571441,a:"Class Declaration class com.tibco.tibrv.TibrvCmQueueTransport   extends  TibrvCmTransport Purpose Coordinate a distributed queue for one-of-n delivery. Remarks Each  TibrvCmQueueTransport  object employs a  TibrvTransport  for network communications. The  TibrvCmQueueTransport  adds the accounting ..."},"1459":{y:0,u:"../java-ref/TibrvCmQueueTransport__.htm",l:-1,t:"TibrvCmQueueTransport()",i:0.000773437191727048,a:"Constructor Declaration TibrvCmQueueTransport(      TibrvRvdTransport     transport,     java.lang.String     cmName)   throws  TibrvException TibrvCmQueueTransport(     TibrvRvdTransport     transport,    java.lang.String     cmName,    int          workerWeight,    int          workerTasks, ..."},"1460":{y:0,u:"../java-ref/TibrvCmQueueTransport_destroy__.htm",l:-1,t:"TibrvCmQueueTransport.destroy()",i:0.000325860786942033,a:"TibrvCmQueueTransport.destroy() Method Declaration void destroy() Purpose Destroy a distributed queue member object. Remarks Destroying a  TibrvCmQueueTransport  object removes the program from the distributed queue group. See Also TibrvCmQueueTransport()"},"1461":{y:0,u:"../java-ref/TibrvCmQueueTransport_getCompleteTime__.htm",l:-1,t:"TibrvCmQueueTransport.getCompleteTime()",i:0.00035285156423306,a:"TibrvCmQueueTransport.getCompleteTime() Method Declaration double getCompleteTime() Purpose Extract the worker complete time limit of a distributed queue member. See Also Distributed Queue, in TIBCO Rendezvous Concepts TibrvCmQueueTransport.setCompleteTime()"},"1462":{y:0,u:"../java-ref/TibrvCmQueueTransport_getUnassignedMessageCount__.htm",l:-1,t:"TibrvCmQueueTransport.getUnassignedMessageCount()",i:0.000158163189872544,a:"Method Declaration int getUnassignedMessageCount()   throws  TibrvException Purpose Extract the number of unassigned task messages from a distributed queue transport. Remarks An unassigned task message is a message received by the scheduler, but not yet assigned to any worker in the distributed ..."},"1463":{y:0,u:"../java-ref/TibrvCmQueueTransport_getWorkerWeight__.htm",l:-1,t:"TibrvCmQueueTransport.getWorkerWeight()",i:0.000230764289086084,a:"TibrvCmQueueTransport.getWorkerWeight() Method Declaration int getWorkerWeight() Purpose Extract the worker weight of a distributed queue member. See Also Distributed Queue, in TIBCO Rendezvous Concepts TibrvCmQueueTransport() TibrvCmQueueTransport.setWorkerWeight()"},"1464":{y:0,u:"../java-ref/TibrvCmQueueTransport_getWorkerTasks__.htm",l:-1,t:"TibrvCmQueueTransport.getWorkerTasks()",i:0.000230764289086084,a:"TibrvCmQueueTransport. getWorkerTasks() Method Declaration int getWorkerTasks() Purpose Extract the worker task capacity of a distributed queue member. See Also Distributed Queue, in TIBCO Rendezvous Concepts TibrvCmQueueTransport() TibrvCmQueueTransport.setWorkerTasks()"},"1465":{y:0,u:"../java-ref/TibrvCmQueueTransport_setCompleteTime__.htm",l:-1,t:"TibrvCmQueueTransport.setCompleteTime()",i:0.000458088256355365,a:"Method Declaration void setCompleteTime(     double   completeTime)   throws  TibrvException Purpose Set the worker complete time limit of a distributed queue member. Remarks If the complete time is non-zero, the scheduler waits for a worker member to complete an assigned task. If the complete time ..."},"1466":{y:0,u:"../java-ref/TibrvCmQueueTransport_setTaskBacklogLimit_____.htm",l:-1,t:"TibrvCmQueueTransport.setTaskBacklogLimit...()",i:0.000158163189872544,a:"Method Declaration void setTaskBacklogLimitInBytes(     int   byteLimit)   throws  TibrvException void setTaskBacklogLimitInMessages(     int   msgLimit)   throws  TibrvException Purpose Set the scheduler task queue limits of a distributed queue transport. Remarks The scheduler stores tasks in a ..."},"1467":{y:0,u:"../java-ref/TibrvCmQueueTransport_setWorkerWeight__.htm",l:-1,t:"TibrvCmQueueTransport.setWorkerWeight()",i:0.000256238325538542,a:"Method Declaration void setWorkerWeight(     int   workerWeight)   throws  TibrvException Purpose Set the worker weight of a distributed queue member. Remarks Relative worker weights assist the scheduler in assigning tasks. When the scheduler receives a task, it assigns the task to the available ..."},"1468":{y:0,u:"../java-ref/TibrvCmQueueTransport_setWorkerTasks__.htm",l:-1,t:"TibrvCmQueueTransport.setWorkerTasks()",i:0.000256238325538542,a:"Method Declaration void setWorkerTasks(     int   workerTasks)   throws  TibrvException Purpose Set the worker task capacity of a distributed queue member. Remarks Task capacity is the maximum number of tasks that a worker can accept. When the number of accepted tasks reaches this maximum, the ..."},"1469":{y:0,u:"../java-ref/Exceptions_and_Errors.htm",l:-1,t:"Exceptions and Errors",i:0.0128439707605082,a:"TibrvException Class Declaration class com.tibco.tibrv.TibrvException   extends java.lang.Exception Purpose Rendezvous software throws exceptions of this class. Remarks Rendezvous software also throws exceptions defined as part of the Java language. Method Description ..."},"1470":{y:0,u:"../java-ref/TibrvException_printStackTrace__.htm",l:-1,t:"TibrvException.printStackTrace()",i:0.00559684864510827,a:"TibrvException. printStackTrace() Method Declaration void printStackTrace() void printStackTrace(java.io.PrintWriter s) void printStackTrace(java.io.PrintStream s) Purpose Print stack trace of this exception, and of the internal exception (if it is set). Overrides java.lang.Throwable.printStackTrace"},"1471":{y:0,u:"../java-ref/TibrvStatus.htm",l:-1,t:"TibrvStatus",i:0.00995401696853447,a:"TibrvStatus Class Declaration class com.tibco.tibrv.TibrvStatus Purpose Define status codes. See Also TibrvException"},"1472":{y:0,u:"../java-ref/TibrvErrorCallback.htm",l:-1,t:"TibrvErrorCallback",i:0.000546208862339906,a:"TibrvErrorCallback Interface Declaration interface com.tibco.tibrv.TibrvErrorCallback Purpose Process asynchronous errors. Remarks Programs can implement this interface (optional) to process asynchronous errors. See Also Tibrv.getErrorCallback() Tibrv.setErrorCallback()"},"1473":{y:0,u:"../java-ref/TibrvErrorCallback_onError__.htm",l:-1,t:"TibrvErrorCallback.onError()",i:0.000466464449924488,a:"TibrvErrorCallback. onError() Method Declaration void onError(     java.lang.Object tibrvObject,     int errorCode,     java.lang.String message,     java.lang.Throwable internal) Purpose Process asynchronous errors. Remarks Rendezvous software calls this method in an asynchronous error situation: A ..."},"1474":{y:0,u:"../java-ref/Custom_Datatypes.htm",l:-1,t:"Custom Datatypes",i:0.000302369255853589,a:"Programs can define custom datatypes by implementing interfaces that encode and decode the data. Decoder methods of  TibrvMsg  decode data from Rendezvous wire format representation into Java objects (for example, while extracting data from a message field). Encoder methods of  TibrvMsg  encode data ..."},"1475":{y:0,u:"../java-ref/TibrvMsg_getDecoder__.htm",l:-1,t:"TibrvMsg.getDecoder()",i:0.00022049164881595,a:"TibrvMsg. getDecoder() Method Declaration static  TibrvMsgDecoder getDecoder(     short    userType) Purpose Extract the decoder interface for a custom datatype. Remarks If no decoder is registered for the datatype, return null. See Also TibrvMsg.setHandlers() TibrvMsgDecoder"},"1476":{y:0,u:"../java-ref/TibrvMsg_getEncoder__.htm",l:-1,t:"TibrvMsg.getEncoder()",i:0.00022049164881595,a:"TibrvMsg. getEncoder() Method Declaration static  TibrvMsgEncoder getEncoder(     short    userType) Purpose Extract the encoder interface for a custom datatype. Remarks If no encoder is registered for the datatype, return null. See Also TibrvMsg.setHandlers() TibrvMsgEncoder"},"1477":{y:0,u:"../java-ref/TibrvMsg_setHandlers__.htm",l:-1,t:"TibrvMsg.setHandlers()",i:0.000772306411076873,a:"TibrvMsg. setHandlers() Method Declaration static void setHandlers(     short              userType,      TibrvMsgEncoder     encoder,      TibrvMsgDecoder     decoder) Purpose Define a custom datatype by registering its encoder and decoder interfaces. Remarks The encoder and decoder must implement ..."},"1478":{y:0,u:"../java-ref/TibrvMsgDecoder.htm",l:-1,t:"TibrvMsgDecoder",i:0.000541107754476025,a:"TibrvMsgDecoder Interface Declaration interface com.tibco.tibrv.TibrvMsgDecoder Purpose Decode custom datatypes from wire format into Java objects. Remarks To define this interface, programs must implement its method. See Also TibrvMsg.setHandlers() . TibrvMsgEncoder"},"1479":{y:0,u:"../java-ref/TibrvMsgDecoder_decode__.htm",l:-1,t:"TibrvMsgDecoder.decode()",i:0.000545636829600195,a:"TibrvMsgDecoder. decode() Method Declaration java.lang.Object decode(     short type,     byte[] bytes) Purpose Decode data (of a custom datatype) from wire format into a Java object. Remarks When this method successfully decodes the data, it must return the decoding as a Java object. When this ..."},"1480":{y:0,u:"../java-ref/TibrvMsgEncoder.htm",l:-1,t:"TibrvMsgEncoder",i:0.000572719023531784,a:"TibrvMsgEncoder Interface Declaration interface com.tibco.tibrv.TibrvMsgEncoder Purpose Encode Java objects as wire format custom datatypes. Remarks To define this interface, programs must implement both of its methods. See Also TibrvMsg.setHandlers() . TibrvMsgDecoder"},"1481":{y:0,u:"../java-ref/TibrvMsgEncoder_canEncode__.htm",l:-1,t:"TibrvMsgEncoder.canEncode()",i:0.000514025560544436,a:"TibrvMsgEncoder. canEncode() Method Declaration boolean canEncode(     short type,     java.lang.Object data) Purpose Test whether this encoder can encode the data as a particular wire format custom datatype. Remarks Before calling  TibrvMsgEncoder.encode() ,  TibrvMsg  first checks its ..."},"1482":{y:0,u:"../java-ref/TibrvMsgEncoder_encode__.htm",l:-1,t:"TibrvMsgEncoder.encode()",i:0.00119628309329909,a:"TibrvMsgEncoder. encode() Method Declaration byte[] encode(     short type,     java.lang.Object data) Purpose Encode a Java object as a wire format custom datatype. Remarks Before calling this method,  TibrvMsg  first checks its applicability by calling  TibrvMsgEncoder.canEncode() . Whenever  ..."},"1483":{y:0,u:"../dotnet-reference/Concepts.htm",l:-1,t:"Concepts",i:0.000138109532391816,a:"Concepts This section presents concepts specific to the TIBCO Rendezvous® .NET interface. For concepts that pertain to Rendezvous software in general, see the book  TIBCO Rendezvous Concepts."},"1484":{y:0,u:"../dotnet-reference/Strings_and_Character_Encodings.htm",l:-1,t:"Strings and Character Encodings",i:0.000607275546679628,a:"Rendezvous software uses strings in several roles: String data inside message fields Field names Subject names (and other associated strings that are not strictly inside the message) Certified delivery (CM) correspondent names Group names (fault tolerance) .NET programs represent all these strings ..."},"1485":{y:0,u:"../dotnet-reference/Programmer_s_Checklist.htm",l:-1,t:"Programmer’s Checklist",i:0.000138109532391816,a:"Developers of Rendezvous programs can use this checklist during the four phases of the development cycle: installing Rendezvous software, coding your program, compiling your program, and running your program. Install Before installing Rendezvous software, we recommend that you first install the .NET ..."},"1486":{y:0,u:"../dotnet-reference/Shared_Library_Files.htm",l:-1,t:"Shared Library Files",i:0.00287646326912352,a:"Programs that use network transports must be able to access Rendezvous shared library files (C libraries).  Environment Variables for Shared Library Files  details the environment variables that direct .NET applications to the Rendezvous installation directory. The installation directory must ..."},"1487":{y:0,u:"../dotnet-reference/_Environment.htm",l:-1,t:"Rendezvous Environment",i:0.000138109532391816,a:"Rendezvous Environment This brief section describes the methods that open and close the internal machinery upon which Rendezvous software depends. It also describes secure daemon contexts, and timeout values."},"1488":{y:0,u:"../dotnet-reference/Environment.htm",l:-1,t:"Environment",i:0.00191769383351287,a:"Class Superclasses System.Object   Environment Visual Basic NotInheritable Public Class Environment C# public sealed class Environment Purpose The Rendezvous environment. Remarks Programs do not create instances of  Environment . Instead, programs use its static methods to open and close the ..."},"1489":{y:0,u:"../dotnet-reference/Environment_Close.htm",l:-1,t:"Environment.Close",i:0.00421210087828513,a:"Environment. Close Method Visual Basic Public Shared Sub Close() C# public static void Close(); Purpose Stop and destroy Rendezvous internal machinery. Remarks After  Environment.Close  destroys the internal machinery, Rendezvous software becomes inoperative: Events no longer arrive in queues. All ..."},"1490":{y:0,u:"../dotnet-reference/Environment_IsIPM__.htm",l:-1,t:"Environment.IsIPM()",i:0.000341864787867714,a:"Method Visual Basic Not supported. C# public static bool IsIPM(); Purpose Test whether the IPM library is linked. Remarks You can use this call to determine whether an application program process has linked the IPM library. You can test that your program dynamically links the correct library. You ..."},"1491":{y:0,u:"../dotnet-reference/Environment_Open.htm",l:-1,t:"Environment.Open",i:0.0049219355986729,a:"Environment. Open Method Visual Basic Public Shared Sub Open() C# public static void Open(); public static void Open(string pathname) Purpose Start Rendezvous internal machinery. Remarks This call creates the internal machinery that Rendezvous software requires for its operation: Internal data ..."},"1492":{y:0,u:"../dotnet-reference/Environment_SetRVParameters__.htm",l:-1,t:"Environment.SetRVParameters()",i:0.000341864787867714,a:"Method Visual Basic Not supported. C# public static  Status SetRVParameters(     string[]  parameters) Purpose Set TIBCO Rendezvous daemon command line parameters for IPM. Remarks The  TIBCO Rendezvous daemon process (rvd) accepts several command line parameters. When IPM serves the role of the ..."},"1493":{y:0,u:"../dotnet-reference/SDContext.htm",l:-1,t:"SDContext",i:0.000321047142780533,a:"Class Superclasses System.Object   SDContext Visual Basic NotInheritable Public Class SDContext C# public sealed class SDContext Purpose This class defines static methods for interacting with secure Rendezvous daemons. Remarks Programs do not create instances of  SDContext . Instead, programs use ..."},"1494":{y:0,u:"../dotnet-reference/SDContext_SetDaemonCertificate.htm",l:-1,t:"SDContext.SetDaemonCertificate",i:0.000404874299873508,a:"Method Visual Basic Public Shared Sub SetDaemonCertificate(     ByVal daemonName As String,     ByVal daemonCert As String) C# public static void SetDaemonCertificate(     string daemonName,     string daemonCert); Purpose Register trust in a secure daemon. Remarks When any program transport ..."},"1495":{y:0,u:"../dotnet-reference/SDContext_SetUserCertificateWithKey.htm",l:-1,t:"SDContext.SetUserCertificateWithKey",i:0.00123004610868609,a:"Method Visual Basic Overloads Public Shared Sub SetUserCertificateWithKey(     ByVal userCertificateWithKey As String,     ByVal password As String) Overloads Public Shared Sub SetUserCertificateWithKey(     ByVal userCertificateWithKeyBinaryFormat As Byte(),     ByVal password As String) C# public ..."},"1496":{y:0,u:"../dotnet-reference/SDContext_SetUserNameWithPassword.htm",l:-1,t:"SDContext.SetUserNameWithPassword",i:0.000206332303792612,a:"Method Visual Basic Public Shared Sub SetUserNameWithPassword(     ByVal userName As String,     ByVal password As String) C# public static void SetUserNameWithPassword(     string userName,     string password); Purpose Register a username with password for identification to secure daemons. Remarks ..."},"1497":{y:0,u:"../dotnet-reference/TimeoutValue.htm",l:-1,t:"TimeoutValue",i:0.000875052188664745,a:"Class Superclasses System.Object   TimeoutValue Visual Basic NotInheritable Public Class TimeoutValue C# public sealed class TimeoutValue Description Defines constants for special timeout values. Remarks Programs can supply these special numeric values as timeout arguments to methods such as  ..."},"1498":{y:0,u:"../dotnet-reference/Data.htm",l:-1,t:"Data",i:0.000138109532391816,a:"Data This section describes messages and the data they contain. See Also Strings and Character Encodings"},"1499":{y:0,u:"../dotnet-reference/Field_Names_and_Field_Identifiers.htm",l:-1,t:"Field Names and Field Identifiers",i:0.000175377305631951,a:"In Rendezvous 5 and earlier releases, programs would specify fields within a message using a field name. In Rendezvous 6 and later releases, programs can specify fields in two ways: A field name is a character string. Each field can have at most one name. Several fields can have the same name. A ..."},"1500":{y:0,u:"../dotnet-reference/IPPort.htm",l:-1,t:"IPPort",i:0.000501191829042804,a:"Class Superclasses System.Object   IPPort Visual Basic Public Class IPPort C# public class IPPort Purpose Represent an IP port number. Remarks In general, an IP Port number is an unsigned 16-bit integer [0;65535], in network byte order. Method Description Page IPPort Create an IP port object. IPPort ..."},"1501":{y:0,u:"../dotnet-reference/IPPort_1.htm",l:-1,t:"IPPort",i:0.000351118007566012,a:"IPPort Constructor Visual Basic Public Sub New() C# public IPPort(); Purpose Create an IP port object."},"1502":{y:0,u:"../dotnet-reference/Message.htm",l:-1,t:"Message",i:0.00330860329516914,a:"Class Superclasses System.Object   Message Visual Basic Public Class Message C# public class Message Purpose Represent Rendezvous messages. Remarks This class has no destroy() method. Instead, the garbage collector reclaims storage automatically. Nonetheless it is possible to explicitly manage ..."},"1503":{y:0,u:"../dotnet-reference/Message_1.htm",l:-1,t:"Message",i:0.000912146700614293,a:"Constructor Visual Basic Overloads Public Sub New() Overloads Public Sub New(     ByVal initialSize As UInt32) Overloads Public Sub New(     ByVal bytes As Byte() ) Overloads Public Sub New(     ByVal message As  Message ) C# public Message(); public Message(uint initialSize); public Message(byte[] ..."},"1504":{y:0,u:"../dotnet-reference/Message_AddField.htm",l:-1,t:"Message.AddField",i:0.00256290810388914,a:"Message. AddField Method Visual Basic Overloads Public Sub AddField(     ByVal messageField As  MessageField ) Overloads Public Sub AddField(     ByVal fieldName As String,     ByVal fieldValue As value_type) Overloads Public Sub AddField(     ByVal messageField As  MessageField ,     ByVal ..."},"1505":{y:0,u:"../dotnet-reference/Message_AddStringAsXml.htm",l:-1,t:"Message.AddStringAsXml",i:0.000956449295801126,a:"Message. AddStringAsXml Method Visual Basic Overloads Public Sub AddStringAsXml(     ByVal fieldName As String,     ByVal fieldValue As String) Overloads Public Sub AddStringAsXml(     ByVal messageField As  MessageField ,     ByVal fieldValue As String,     ByVal fieldId As UInt16) C# public void ..."},"1506":{y:0,u:"../dotnet-reference/Message_Dispose__.htm",l:-1,t:"Message.Dispose()",i:0.000286126923209997,a:"Method Declaration void Dispose() Purpose Release native storage associated with the message. Remarks Messages occupy storage outside of the .NET environment (that is, in the native C environment) and also within the .NET environment. When the .NET garbage collector recycles the .NET message object, ..."},"1507":{y:0,u:"../dotnet-reference/Message_Expand.htm",l:-1,t:"Message.Expand",i:0.000304490284990949,a:"Method Visual Basic Public Sub Expand(     ByVal additionalStorage As UInt32) C# public void Expand(     uint additionalStorage); Purpose Enlarge a message by allocating additional storage. Remarks .NET programs store messages in unmanaged objects. When adding data to a message would overflow the ..."},"1508":{y:0,u:"../dotnet-reference/Message_GetField.htm",l:-1,t:"Message.GetField",i:0.00128488021162171,a:"Message. GetField Method Visual Basic Overloads Public Function GetField(     ByVal fieldName As String) Overloads Public Function GetField(     ByVal messageField As  MessageField ,     ByVal fieldId As UInt16) C# public  MessageField GetField(     string fieldName); public  MessageField GetField( ..."},"1509":{y:0,u:"../dotnet-reference/Message_GetFieldByIndex.htm",l:-1,t:"Message.GetFieldByIndex",i:0.000626914717301178,a:"Message. GetFieldByIndex Method Visual Basic Public Function GetFieldByIndex(     ByVal fieldIndex As UInt32 ) As  MessageField C# public  MessageField GetFieldByIndex(     uint fieldIndex) Purpose Get a field from a message by an index. Remarks Programs can loop through all the fields of a message, ..."},"1510":{y:0,u:"../dotnet-reference/Message_GetFieldInstance.htm",l:-1,t:"Message.GetFieldInstance",i:0.000594364204946532,a:"Message. GetFieldInstance Method Visual Basic Public Function GetFieldInstance(     ByVal fieldName As String,     ByVal instanceNumber As UInt32 ) As  MessageField C# public  MessageField GetFieldInstance(     string  fieldName,     uint    instanceNumber) Purpose Get a specific instance of a field ..."},"1511":{y:0,u:"../dotnet-reference/Message_GetXmlAsString.htm",l:-1,t:"Message.GetXmlAsString",i:0.000489374234836443,a:"Message. GetXmlAsString Method Visual Basic Overloads Public Function GetXmlAsString(     ByVal fieldName As String) Overloads Public Function GetXmlAsString(     ByVal fieldName As String,     ByVal fieldId As UInt16) Public Function GetXmlAsStringByIndex(     ByVal fieldIndex As UInt32 ) As String ..."},"1512":{y:0,u:"../dotnet-reference/Message_GetSource.htm",l:-1,t:"Message.GetSource",i:0.000286126923209997,a:"Message. GetSource Method Visual Basic Public Function GetSource() As Object C# public object GetSource(); Purpose Extract the source associated with a (dispatched) message object. Remarks Dispatch associates the message with either a  Listener  or a  VectorListener . This method returns that ..."},"1513":{y:0,u:"../dotnet-reference/Message_RegisterCustomDataType.htm",l:-1,t:"Message.RegisterCustomDataType",i:0.000927456378546293,a:"Message. RegisterCustomDataType Method Visual Basic Public Shared Sub RegisterCustomDataType(     ByVal type As Type,     ByVal customDataTypeAdapter As  ICustomDataTypeAdapter ) C# public static void RegisterCustomDataType(     Type type,      ICustomDataTypeAdapter  customDataTypeAdapter); Purpose ..."},"1514":{y:0,u:"../dotnet-reference/Message_RemoveField.htm",l:-1,t:"Message.RemoveField",i:0.00111505449553234,a:"Message. RemoveField Method Visual Basic Overloads Public Sub RemoveField(     ByVal messageField As  MessageField ) Overloads Public Sub RemoveField(     ByVal fieldName As String) Overloads Public Sub RemoveField(     ByVal fieldName As String,     ByVal fieldId As UInt16) C# public void ..."},"1515":{y:0,u:"../dotnet-reference/Message_RemoveFieldInstance.htm",l:-1,t:"Message.RemoveFieldInstance",i:0.000341758058231084,a:"Message. RemoveFieldInstance Method Visual Basic Public Sub RemoveFieldInstance(     ByVal fieldName As String,     ByVal instanceNumber As UInt32) C# public void RemoveFieldInstance(     string  fieldName,     uint    instanceNumber) Purpose Remove a specified instance of a field from a message. ..."},"1516":{y:0,u:"../dotnet-reference/Message_Reset.htm",l:-1,t:"Message.Reset",i:0.000304490284990949,a:"Method Visual Basic Public Sub Reset() C# public void Reset(); Purpose Clear a message, preparing it for re-use. Remarks This method is the equivalent of creating a new message—except that the unmanaged storage is re-used. When this method returns, the message has no fields; it is like a newly ..."},"1517":{y:0,u:"../dotnet-reference/Message_ToByteArray.htm",l:-1,t:"Message.ToByteArray",i:0.000736489262554938,a:"Message. ToByteArray Method Visual Basic Public Function ToByteArray( ) As Byte() C# public byte[] ToByteArray() Purpose Extract the data from a message as a byte sequence. Remarks This method returns a copy of the message data as a byte sequence, suitable for archiving in a file. To reconstruct the ..."},"1518":{y:0,u:"../dotnet-reference/Message_UpdateField.htm",l:-1,t:"Message.UpdateField",i:0.000868871926404533,a:"Message. UpdateField Method Visual Basic Overloads Public Sub UpdateField(     ByVal messageField As  MessageField ) Overloads Public Sub UpdateField(     ByVal fieldName As String,     ByVal fieldValue As value_type) Overloads Public Sub UpdateField(     ByVal messageField As  MessageField , ..."},"1519":{y:0,u:"../dotnet-reference/MessageField.htm",l:-1,t:"MessageField",i:0.0031408426054822,a:"Class Superclasses System.Object   MessageField Visual Basic Public Class MessageField C# public class MessageField Purpose Represent a message field. Remarks This class has no destroy() method. Instead, the garbage collector reclaims storage automatically. Member Description   Public Instance ..."},"1520":{y:0,u:"../dotnet-reference/MessageField_1.htm",l:-1,t:"MessageField",i:0.0007024911738054,a:"Constructor Visual Basic Overloads Public Sub New(     ByVal fieldName As String,     ByVal fieldValue As value_type) Overloads Public Sub New(     ByVal messageField As  MessageField ,     ByVal fieldValue As value_type,     ByVal fieldId As UInt16) C# public MessageField(     string fieldName, ..."},"1521":{y:0,u:"../dotnet-reference/Opaque.htm",l:-1,t:"Opaque",i:0.000501191829042804,a:"Opaque Class Superclasses System.Object   Opaque Visual Basic Public Class Opaque C# public class Opaque Purpose Wrap an opaque byte sequence."},"1522":{y:0,u:"../dotnet-reference/ICustomDataType.htm",l:-1,t:"ICustomDataType",i:0.00108070546170233,a:"Interface Visual Basic Public Interface ICustomDataType C# public interface ICustomDataType Purpose Interface for custom datatypes. Remarks Custom datatype classes must implement this interface. However, this interface does not define any contract. Merely declaring that your datatype class ..."},"1523":{y:0,u:"../dotnet-reference/ICustomDataTypeAdapter.htm",l:-1,t:"ICustomDataTypeAdapter",i:0.00115524823642541,a:"Interface Visual Basic Public Interface ICustomDataTypeAdapter C# public interface ICustomDataTypeAdapter Purpose Interface for encoding and decoding custom datatypes. Method Description Page ICustomDataTypeAdapter.Decode() Decode a byte array to produce a custom datatype. ..."},"1524":{y:0,u:"../dotnet-reference/ICustomDataTypeAdapter_Decode__.htm",l:-1,t:"ICustomDataTypeAdapter.Decode()",i:0.00030177138289721,a:"ICustomDataTypeAdapter. Decode() Method Visual Basic Function Decode(     ByVal bytes As Byte() )   As  ICustomDataType C# ICustomDataType Decode(     byte[] bytes); Purpose Decode a byte array to produce a custom datatype. Remarks When this method successfully decodes the data, it must return the ..."},"1525":{y:0,u:"../dotnet-reference/ICustomDataTypeAdapter_Encode__.htm",l:-1,t:"ICustomDataTypeAdapter.Encode()",i:0.00030177138289721,a:"ICustomDataTypeAdapter. Encode() Method Visual Basic Function Encode(     ByVal customDataType As  ICustomDataType ) )   As Byte() C# byte[] Encode(      ICustomDataType  customDataType); Purpose Encode a custom datatype instance to produce a byte array. Remarks When this method successfully encodes ..."},"1526":{y:0,u:"../dotnet-reference/Listeners.htm",l:-1,t:"Listeners",i:0.000138109532391816,a:"Listeners Each listener object expresses interest in a set of inbound messages. This section presents the classes, methods and delegates for receiving messages."},"1527":{y:0,u:"../dotnet-reference/Listener.htm",l:-1,t:"Listener",i:0.000441062491566448,a:"Class Superclasses System.Object   Listener Visual Basic Public Class Listener C# public class Listener Purpose Listen for inbound messages. Remarks Each  Listener  object represents your program’s interest in a set of message events. When a matching message arrives, TIBCO Rendezvous places the ..."},"1528":{y:0,u:"../dotnet-reference/Listener_1.htm",l:-1,t:"Listener",i:0.000412574955111838,a:"Constructor Visual Basic Overloads Public Sub New(  ByVal queue As  Queue ,  ByVal messageReceivedEventHandler As  MessageReceivedEventHandler ,  ByVal transport As  Transport ,  ByVal subject As String,  ByVal closure As Object ) Overloads Public Sub New(  ByVal queue As  Queue ,  ByVal transport ..."},"1529":{y:0,u:"../dotnet-reference/Listener_Destroy.htm",l:-1,t:"Listener.Destroy",i:0.00156649819401162,a:"Listener. Destroy Method Visual Basic Overrideable Public Sub Destroy() C# public virtual void Destroy(); Purpose Destroy a listener, canceling interest. Remarks Destroying a listener cancels interest in its subject. Upon return from  Listener.Destroy , the destroyed listener is no longer ..."},"1530":{y:0,u:"../dotnet-reference/MessageReceivedEventArgs.htm",l:-1,t:"MessageReceivedEventArgs",i:0.000179208056692598,a:"Class Superclasses System.Object   EventArgs     MessageReceivedEventArgs Visual Basic Public Class MessageReceivedEventArgs   Inherits EventArgs C# public class MessageReceivedEventArgs : EventArgs Purpose Message received events pass instances of this class to their event handlers."},"1531":{y:0,u:"../dotnet-reference/MessageReceivedEventHandler.htm",l:-1,t:"MessageReceivedEventHandler",i:0.000386808127699884,a:"Delegate Visual Basic Public Delegate Sub MessageReceivedEventHandler (     ByVal listener As Object,     ByVal messageReceivedEventArgs As  MessageReceivedEventArgs  ) C# public delegate void MessageReceivedEventHandler (     object listener,      MessageReceivedEventArgs  messageReceivedEventArgs ..."},"1532":{y:0,u:"../dotnet-reference/VectorListener.htm",l:-1,t:"VectorListener",i:0.000475693072023195,a:"Class Superclasses System.Object   VectorListener Visual Basic Public Class VectorListener C# public class VectorListener Purpose Listen for inbound messages, and receive them in a vector. Remarks A vector listener object continues listening for messages until the program destroys it. The ..."},"1533":{y:0,u:"../dotnet-reference/VectorListener_1.htm",l:-1,t:"VectorListener",i:0.000307225461329984,a:"Constructor Visual Basic Overloads Public Sub New(  ByVal queue As  Queue ,  ByVal messagesReceivedEventHandler As           MessagesReceivedEventHandler ,  ByVal transport As  Transport ,  ByVal subject As String,  ByVal closure As Object ) C# public VectorListener(      Queue  queue,      ..."},"1534":{y:0,u:"../dotnet-reference/VectorListener_Destroy.htm",l:-1,t:"VectorListener.Destroy",i:0.00159537695323744,a:"VectorListener. Destroy Method Visual Basic Overrideable Public Sub Destroy() C# public virtual void Destroy(); Purpose Destroy a listener, canceling interest. Remarks Destroying a vector listener cancels interest in its subject. Upon return from  VectorListener.Destroy , the destroyed listener is ..."},"1535":{y:0,u:"../dotnet-reference/VectorListener_GetClosure.htm",l:-1,t:"VectorListener.GetClosure",i:0.000195872518370948,a:"VectorListener. GetClosure Method Visual Basic Public Function GetClosure() As Object C# public object GetClosure(); Purpose Extract the closure data from a vector listener object."},"1536":{y:0,u:"../dotnet-reference/MessagesReceivedEventArgs.htm",l:-1,t:"MessagesReceivedEventArgs",i:0.000205938709529508,a:"Class Superclasses System.Object   EventArgs     MessagesReceivedEventArgs Visual Basic Public Class MessagesReceivedEventArgs   Inherits EventArgs C# public class MessagesReceivedEventArgs : EventArgs Purpose Message vector received events pass instances of this class to their event handlers."},"1537":{y:0,u:"../dotnet-reference/MessagesReceivedEventHandler.htm",l:-1,t:"MessagesReceivedEventHandler",i:0.000239396284192292,a:"Delegate Visual Basic Public Delegate Sub MessagesReceivedEventHandler (     ByVal messagesReceivedEventArgs As  MessagesReceivedEventArgs  ) C# public delegate void MessagesReceivedEventHandler (      MessagesReceivedEventArgs  messagesReceivedEventArgs ); Purpose Process inbound message vectors ..."},"1538":{y:0,u:"../dotnet-reference/Event_Queues.htm",l:-1,t:"Event Queues",i:0.000138109532391816,a:".NET programs can express interest in several types of events—such as inbound messages, and fault tolerance events. When a message arrives, it triggers program callback delegates to process the message. TIBCO Rendezvous events wait in queues until programs dispatch them. Dispatching a TIBCO ..."},"1539":{y:0,u:"../dotnet-reference/IDispatchable.htm",l:-1,t:"IDispatchable",i:0.00203050966228033,a:"Interface Visual Basic Public Interface IDispatchable C# public interface IDispatchable Purpose Common interface for queues and queue groups. Remarks Both  Queue  and  QueueGroup  implement this interface, so programs can call the common methods on objects of either class. For example, consider a ..."},"1540":{y:0,u:"../dotnet-reference/IDispatchable_dispatch.htm",l:-1,t:"IDispatchable.dispatch",i:0.000686823944955527,a:"IDispatchable. dispatch Method Visual Basic Sub Dispatch () C# void Dispatch (); Purpose Dispatch an event; if no event is ready, block. Remarks If an event is ready to dispatch, then this call dispatches it, and then returns. If no events are waiting, then this call blocks indefinitely while ..."},"1541":{y:0,u:"../dotnet-reference/IDispatchable_Poll.htm",l:-1,t:"IDispatchable.Poll",i:0.000688041851145963,a:"IDispatchable. Poll Method Visual Basic Function Poll () As Boolean C# bool Poll (); Purpose Dispatch an event, if possible. Remarks If an event is ready to dispatch, then this call dispatches it, and then returns. If no events are waiting, then this call returns immediately. When the call ..."},"1542":{y:0,u:"../dotnet-reference/IDispatchable_TimedDispatch.htm",l:-1,t:"IDispatchable.TimedDispatch",i:0.00102915166559611,a:"IDispatchable. TimedDispatch Method Visual Basic Function TimedDispatch (     ByVal timeout As Double )   As Boolean C# bool TimedDispatch (     double timeout ); Purpose Dispatch an event, but if no event is ready to dispatch, limit the time that this call blocks while waiting for an event. Remarks ..."},"1543":{y:0,u:"../dotnet-reference/Queue.htm",l:-1,t:"Queue",i:0.00207417415217606,a:"Class Superclasses System.Object   Queue Visual Basic Public Class Queue   Implements  IDispatchable C# public class Queue :  IDispatchable Purpose Event queue. Remarks Each listener is associated with a  Queue  object; when a message arrives, Rendezvous software places an event in the corresponding ..."},"1544":{y:0,u:"../dotnet-reference/Queue_1.htm",l:-1,t:"Queue",i:0.000314415522898186,a:"Queue Constructor Visual Basic Overloads Public Sub New() C# public Queue(); Purpose Create an event queue. Remarks Upon creation, new queues use these default property values."},"1545":{y:0,u:"../dotnet-reference/Queue_Destroy.htm",l:-1,t:"Queue.Destroy",i:0.000438720332191927,a:"Queue. Destroy Method Visual Basic Public Sub Destroy() C# public void Destroy(); Purpose Destroy a queue. Remarks When a queue is destroyed, events that remain in the queue are discarded. Destroying a queue invalidates all events associated with the queue. A program must not call  Queue.Destroy  on ..."},"1546":{y:0,u:"../dotnet-reference/Queue_Dispatch.htm",l:-1,t:"Queue.Dispatch",i:0.000820116227928547,a:"Queue. Dispatch Method Visual Basic NotOverrideable Public Sub Dispatch ()   Implements  IDispatchable.dispatch C# public void Dispatch (); Purpose Dispatch an event; if no event is ready, block. Remarks If the queue is not empty, then this call dispatches the event at the head of the queue, and ..."},"1547":{y:0,u:"../dotnet-reference/Queue_Poll.htm",l:-1,t:"Queue.Poll",i:0.000677731631797749,a:"Queue. Poll Method Visual Basic NotOverrideable Public Function Poll ()   Implements  IDispatchable.Poll C# public bool Poll (); Purpose Dispatch an event, if possible. Remarks If the queue is not empty, then this call dispatches the event at the head of the queue, and then returns. If the queue is ..."},"1548":{y:0,u:"../dotnet-reference/Queue_TimedDispatch.htm",l:-1,t:"Queue.TimedDispatch",i:0.000743653005563325,a:"Queue. TimedDispatch Method Visual Basic NotOverrideable Public Function TimedDispatch (     ByVal timeout As Double )   As Boolean   Implements  IDispatchable.TimedDispatch C# public bool TimedDispatch (     double timeout ); Purpose Dispatch an event, but if no event is ready to dispatch, limit ..."},"1549":{y:0,u:"../dotnet-reference/LimitPolicy.htm",l:-1,t:"LimitPolicy",i:0.000314415522898186,a:"Class Superclasses System.Object   LimitPolicy Visual Basic Public Class LimitPolicy C# public class LimitPolicy Purpose Determine queue overflow behavior. Member Description   Public Instance Properties DiscardAmount uint When the queue exceeds its maximum event limit, discard a block of events. ..."},"1550":{y:0,u:"../dotnet-reference/LimitPolicy_1.htm",l:-1,t:"LimitPolicy",i:0.000271736839410877,a:"Constructor Visual Basic Public Sub New(     ByVal limitPolicyStrategy As  LimitPolicyStrategy ,     ByVal maxEvents As UInt32,     ByVal discardAmount As UInt32 ) C# public LimitPolicy(      LimitPolicyStrategy  limitPolicyStrategy,     uint maxEvents,     uint discardAmount ); Purpose Create a ..."},"1551":{y:0,u:"../dotnet-reference/LimitPolicyStrategy.htm",l:-1,t:"LimitPolicyStrategy",i:0.00334893929227961,a:"LimitPolicyStrategy Enumeration Visual Basic Public Enum LimitPolicyStrategy C# public enum LimitPolicyStrategy Description These enumerated constants specify the possible strategies for resolving queue overflow."},"1552":{y:0,u:"../dotnet-reference/QueueGroup.htm",l:-1,t:"QueueGroup",i:0.000886679442701321,a:"Class Superclasses System.Object   QueueGroup Visual Basic Public Class QueueGroup   Implements  IDispatchable C# public class QueueGroup :  IDispatchable Purpose Prioritized dispatch of several queues with one call. Remarks Queue groups add flexibility and fine-grained control to the event queue ..."},"1553":{y:0,u:"../dotnet-reference/QueueGroup_1.htm",l:-1,t:"QueueGroup",i:0.000672872416280553,a:"QueueGroup Constructor Visual Basic Overloads Public Sub New() C# public QueueGroup(); Purpose Create an event queue group. Remarks The new queue group is empty. The queue group remains valid until the program explicitly destroys it. See Also QueueGroup.Add QueueGroup.Destroy"},"1554":{y:0,u:"../dotnet-reference/QueueGroup_Add.htm",l:-1,t:"QueueGroup.Add",i:0.000635102914907362,a:"QueueGroup. Add Method Visual Basic Public Sub Add(     ByVal queue As  Queue  ) C# public void Add(      Queue  queue ); Purpose Add an event queue to a queue group. Remarks If the queue is already in the group, adding it again has no effect. If either the queue or the group is invalid, this method ..."},"1555":{y:0,u:"../dotnet-reference/QueueGroup_Destroy.htm",l:-1,t:"QueueGroup.Destroy",i:0.00051829303754124,a:"QueueGroup. Destroy Method Visual Basic Public Sub Destroy() C# public void Destroy(); Purpose Destroy an event queue group. Remarks The individual queues in the group continue to exist, even though the group has been destroyed. See Also QueueGroup"},"1556":{y:0,u:"../dotnet-reference/QueueGroup_Dispatch.htm",l:-1,t:"QueueGroup.Dispatch",i:0.000572398639725477,a:"QueueGroup. Dispatch Method Visual Basic NotOverrideable Public Sub Dispatch ()   Implements  IDispatchable.dispatch C# public void Dispatch (); Purpose Dispatch an event from a queue group; if no event is ready, block. Remarks If any queue in the group contains an event, then this call searches the ..."},"1557":{y:0,u:"../dotnet-reference/QueueGroup_Poll.htm",l:-1,t:"QueueGroup.Poll",i:0.000556491340311654,a:"QueueGroup. Poll Method Visual Basic NotOverrideable Public Function Poll ()   As Boolean   Implements  IDispatchable.Poll C# public bool Poll (); Purpose Dispatch an event, but if no event is ready to dispatch, return immediately (without blocking). Remarks If any queue in the group contains an ..."},"1558":{y:0,u:"../dotnet-reference/QueueGroup_Remove.htm",l:-1,t:"QueueGroup.Remove",i:0.000412267223775942,a:"QueueGroup. Remove Method Visual Basic Public Sub Remove (     ByVal queue as  Queue  ) C# public void Remove (      Queue  queue ); Purpose Remove an event queue from a queue group. Remarks If the queue is not in the group, or if the group is invalid, this call throws an exception with the status ..."},"1559":{y:0,u:"../dotnet-reference/QueueGroup_TimedDispatch.htm",l:-1,t:"QueueGroup.TimedDispatch",i:0.000618008667314222,a:"QueueGroup. TimedDispatch Method Visual Basic NotOverrideable Public Function TimedDispatch (     ByVal timeout As Double )   As Boolean   Implements  IDispatchable.TimedDispatch C# public bool TimedDispatch (     double timeout ); Purpose Dispatch an event, but if no event is ready to dispatch, ..."},"1560":{y:0,u:"../dotnet-reference/Dispatcher.htm",l:-1,t:"Dispatcher",i:0.000975865769934627,a:"Class Superclasses System.Object   Dispatcher Visual Basic Public Class Dispatcher C# public class Dispatcher Purpose Dispatch events from a queue or queue group. Remarks Each instance of this class represents a thread that loops indefinitely, repeatedly dispatching a queue or queue group. This ..."},"1561":{y:0,u:"../dotnet-reference/Dispatcher_1.htm",l:-1,t:"Dispatcher",i:0.000474726266347298,a:"Constructor Visual Basic Overloads Public Sub New(     ByVal dispatchable As  IDispatchable ,     ByVal name As String,     ByVal timeout As Double ) Overloads Public Sub New(     ByVal dispatchable As  IDispatchable ,     ByVal name As String ) Overloads Public Sub New(     ByVal dispatchable As  ..."},"1562":{y:0,u:"../dotnet-reference/Dispatcher_Destroy.htm",l:-1,t:"Dispatcher.Destroy",i:0.000256608255791011,a:"Dispatcher. Destroy Method Visual Basic Public Sub Destroy() C# public void Destroy(); Purpose Destroy a dispatcher thread. Remarks Destroying a dispatcher leaves its dispatchable intact. See Also Dispatcher"},"1563":{y:0,u:"../dotnet-reference/Dispatcher_Join.htm",l:-1,t:"Dispatcher.Join",i:0.000256608255791011,a:"Dispatcher. Join Method Visual Basic Public Sub Join() C# public void Join(); Purpose Wait for a dispatcher thread to finish. Remarks The calling thread blocks until after the dispatcher thread is destroyed. Consider a program in which the main thread creates a queue and listeners, and then creates ..."},"1564":{y:0,u:"../dotnet-reference/Dispatcher_Pause.htm",l:-1,t:"Dispatcher.Pause",i:0.000446277049302485,a:"Dispatcher. Pause Method Visual Basic Public Sub Pause() C# public void Pause(); Purpose Pause a dispatcher thread (so it does not dispatch events). Remarks Use  Dispatcher.Resume  to start dispatching again. See Also Dispatcher Dispatcher.Resume"},"1565":{y:0,u:"../dotnet-reference/Dispatcher_Resume.htm",l:-1,t:"Dispatcher.Resume",i:0.000446277049302485,a:"Dispatcher. Resume Method Visual Basic Public Sub Resume() C# public void Resume(); Purpose Resume a dispatcher thread (after pause). Remarks The thread continues dispatching events. See Also Dispatcher Dispatcher.Pause  "},"1566":{y:0,u:"../dotnet-reference/Transports.htm",l:-1,t:"Transports",i:0.000138109532391816,a:"Transports Transports manage network connections and send outbound messages. This section presents the various transport classes and their methods. See Also CMTransport CMQueueTransport"},"1567":{y:0,u:"../dotnet-reference/Transport.htm",l:-1,t:"Transport",i:0.000970108849074265,a:"Class Superclasses System.Object   Transport Visual Basic MustInherit Public Class Transport C# public abstract class Transport Purpose A transport object represents a delivery mechanism for messages. Remarks A transport describes a carrier for messages—whether across a network, among processes on a ..."},"1568":{y:0,u:"../dotnet-reference/Transport_CreateInbox.htm",l:-1,t:"Transport.CreateInbox",i:0.000481428100108089,a:"Transport. CreateInbox Method Visual Basic Public Function CreateInbox ()   As String C# public string CreateInbox (); Purpose Create a unique inbox subject name. Remarks This method creates inbox names that are unique throughout the transport scope. For network transports, inbox subject names are ..."},"1569":{y:0,u:"../dotnet-reference/Transport_Destroy.htm",l:-1,t:"Transport.Destroy",i:0.000334544352871475,a:"Transport. Destroy Method Visual Basic Overrideable Public Sub Destroy () C# public virtual void Destroy (); Purpose Destroy a transport. Remarks Programs must explicitly destroy each transport object. Destroying a transport achieves these effects: The transport flushes all outbound data to the ..."},"1570":{y:0,u:"../dotnet-reference/Transport_Send.htm",l:-1,t:"Transport.Send",i:0.000616323955320119,a:"Transport. Send Method Visual Basic Overrideable Public Sub Send (     ByVal message As  Message  ) Overrideable Public Sub Send (     ByVal messages As  Message [] ) C# public virtual void Send (      Message  message ); public virtual void Send (      Message [] messages) Purpose Send a message. ..."},"1571":{y:0,u:"../dotnet-reference/Transport_SendReply.htm",l:-1,t:"Transport.SendReply",i:0.000358231112523942,a:"Transport. SendReply Method Visual Basic Overrideable Public Sub SendReply (     ByVal reply As  Message ,     ByVal request As  Message  ) C# public virtual void SendReply (      Message  reply,      Message  request ); Purpose Send a reply message. Remarks This convenience call extracts the reply ..."},"1572":{y:0,u:"../dotnet-reference/Transport_SendRequest.htm",l:-1,t:"Transport.SendRequest",i:0.000358231112523942,a:"Transport. SendRequest Method Visual Basic Overrideable Public Function SendRequest (     ByVal request As  Message ,     ByVal timeout As Double )   As  Message C# public virtual  Message SendRequest (      Message  request,     double timeout ); Purpose Send a request message and wait for a reply. ..."},"1573":{y:0,u:"../dotnet-reference/Transport_SetBatchSize.htm",l:-1,t:"Transport.SetBatchSize",i:0.00021307285644943,a:"Transport. SetBatchSize Method Visual Basic Not supported. C# public virtual void SetBatchSize (     uint numBytes ); Purpose Enable outbound batching of data from IPM, and set the batch size (in bytes). Remarks This type of batching is available only in the IPM library. It is not available in the ..."},"1574":{y:0,u:"../dotnet-reference/IntraProcessTransport.htm",l:-1,t:"IntraProcessTransport",i:0.000538299608347374,a:"Class Superclasses System.Object   Transport     IntraProcessTransport Visual Basic NotInheritable Public Class IntraProcessTransport   Inherits Transport C# public sealed class IntraProcessTransport : Transport Purpose The intra-process transport delivers messages among the threads of a program. ..."},"1575":{y:0,u:"../dotnet-reference/NetTransport.htm",l:-1,t:"NetTransport",i:0.000759438716300421,a:"Class Superclasses System.Object   Transport     NetTransport Visual Basic Public Class NetTransport   Inherits Transport C# public class NetTransport : Transport Purpose Deliver messages across a network. Remarks Programs must explicitly destroy instances of this class. Rendezvous software keeps ..."},"1576":{y:0,u:"../dotnet-reference/NetTransport_1.htm",l:-1,t:"NetTransport",i:0.000295859439056996,a:"Constructor Visual Basic Overloads Public Sub New() Overloads Public Sub New(     ByVal service As String,     ByVal network As String,     ByVal daemon  As String ) Overloads Public Sub New(     ByVal service As String,     ByVal network As String,     ByVal daemon  As String,     ByVal ..."},"1577":{y:0,u:"../dotnet-reference/TransportBatchMode.htm",l:-1,t:"TransportBatchMode",i:0.000181144600069075,a:"Enumeration Visual Basic Public Enum TransportBatchMode C# public enum TransportBatchMode Description These enumerated constants specify the possible strategies for batching outbound messages. Remarks The batch mode determines when the transport transmits outbound message data to rvd: As soon as ..."},"1578":{y:0,u:"../dotnet-reference/Virtual_Circuits.htm",l:-1,t:"Virtual Circuits",i:0.000138109532391816,a:"Virtual Circuits Virtual circuits feature Rendezvous communication between two terminals over an exclusive, continuous, monitored connection. See Also Virtual Circuits in TIBCO Rendezvous Concepts"},"1579":{y:0,u:"../dotnet-reference/VCTransport.htm",l:-1,t:"VCTransport",i:0.000357134517724212,a:"Class Superclasses System.Object    Transport     VCTransport Visual Basic Public Class VCTransport   Inherits  Transport C# public class VCTransport :  Transport Purpose A virtual circuit transport object represents a terminal in a potential circuit. Remarks A virtual circuit transport can fill the ..."},"1580":{y:0,u:"../dotnet-reference/VCTransport_CreateAcceptVC.htm",l:-1,t:"VCTransport.CreateAcceptVC",i:0.000317303975991812,a:"Method Visual Basic Public Shared Function CreateAcceptVC(     ByVal transport As  Transport ,     ByRef connectSubject As String )   As  VCTransport C# public static  VCTransport CreateAcceptVC(      Transport  transport,     out string connectSubject ); Purpose Create a virtual circuit accept ..."},"1581":{y:0,u:"../dotnet-reference/VCTransport_CreateConnectVC.htm",l:-1,t:"VCTransport.CreateConnectVC",i:0.000343072409603864,a:"Method Visual Basic Public Shared Function CreateConnectVC(     ByVal transport As  Transport ,     ByVal connectSubject As String )   As  VCTransport C# public static  VCTransport CreateConnectVC(      Transport  transport,     string connectSubject ); Purpose Create a virtual circuit connect ..."},"1582":{y:0,u:"../dotnet-reference/VCTransport_WaitForVCConnection.htm",l:-1,t:"VCTransport.WaitForVCConnection",i:0.000646692799569937,a:"Method Visual Basic Public Sub WaitForVCConnection(     ByVal timeout As Double )   As  VCTransport C# public void WaitForVCConnection(     double timeout ); Purpose Test the connection status of a virtual circuit. Remarks This method tests (and can block) until this virtual circuit transport object ..."},"1583":{y:0,u:"../dotnet-reference/Fault_Tolerance.htm",l:-1,t:"Fault Tolerance",i:0.000236817167097166,a:"Rendezvous fault tolerance software coordinates a group of redundant processes into a fault-tolerant distributed program. Some processes actively fulfill the tasks of the program, while other processes wait in readiness. When one of the active processes fails, another process rapidly assumes active ..."},"1584":{y:0,u:"../dotnet-reference/Fault_Tolerance_Road_Map.htm",l:-1,t:"Fault Tolerance Road Map",i:0.000138109532391816,a:"For a complete discussion of concepts and operating principles, see  Fault Tolerance Concepts . For suggestions to help you design programs using fault tolerance features, see  Fault Tolerance Programming . For step-by-step hints for implementing fault-tolerant systems, see  Developing Fault ..."},"1585":{y:0,u:"../dotnet-reference/FTGroupMember.htm",l:-1,t:"FTGroupMember",i:0.000284342671317211,a:"Class Superclasses System.Object   FTGroupMember Visual Basic Public Class FTGroupMember C# public class FTGroupMember Purpose Represent membership in a fault tolerance group. Remarks Upon creating this object, the program joins a fault tolerance group. By destroying a member object, the program ..."},"1586":{y:0,u:"../dotnet-reference/FTGroupMember_1.htm",l:-1,t:"FTGroupMember",i:0.0005087274118362,a:"Constructor Visual Basic Public Sub New(     ByVal queue As  Queue ,     ByVal actionTokenReceivedEventHandler             As  ActionTokenReceivedEventHandler ,     ByVal transport As  Transport ,     ByVal groupName As String,     ByVal weight As UInt16,     ByVal activeGoal As UInt16,     ByVal ..."},"1587":{y:0,u:"../dotnet-reference/FTGroupMember_Destroy.htm",l:-1,t:"FTGroupMember.Destroy",i:0.000234348737204698,a:"FTGroupMember. Destroy Method Visual Basic Public Sub Destroy () C# public void Destroy (); Purpose Destroy a member of a fault tolerance group. Remarks By destroying a member object, the program cancels or withdraws its membership in the group. This method has two effects: If this member is active, ..."},"1588":{y:0,u:"../dotnet-reference/ActionToken.htm",l:-1,t:"ActionToken",i:0.000357431132717466,a:"Enumeration Visual Basic Public Enum ActionToken C# public enum ActionToken Description These enumerated constants specify the possible strategies for batching outbound messages. Remarks Each of these constants is a token designating a command to a fault tolerance callback method. The program’s ..."},"1589":{y:0,u:"../dotnet-reference/ActionTokenReceivedEventArgs.htm",l:-1,t:"ActionTokenReceivedEventArgs",i:0.000222359180608922,a:"Class Superclasses System.Object   EventArgs     ActionTokenReceivedEventArgs Visual Basic Public Class ActionTokenReceivedEventArgs   Inherits EventArgs C# public class ActionTokenReceivedEventArgs : EventArgs Purpose Action token received events pass instances of this class to their event ..."},"1590":{y:0,u:"../dotnet-reference/ActionTokenReceivedEventHandler.htm",l:-1,t:"ActionTokenReceivedEventHandler",i:0.000297350698510423,a:"Delegate Visual Basic Public Delegate Sub ActionTokenReceivedEventHandler (     ByVal ftGroupMember As Object,     ByVal actionTokenReceivedEventArgs             As  ActionTokenReceivedEventArgs  ) C# public delegate void ActionTokenReceivedEventHandler (     object ftGroupMember,      ..."},"1591":{y:0,u:"../dotnet-reference/FTGroupMonitor.htm",l:-1,t:"FTGroupMonitor",i:0.000294080705014029,a:"Class Superclasses System.Object   FTGroupMonitor Visual Basic Public Class FTGroupMonitor C# public class FTGroupMonitor Purpose Monitor a fault tolerance group. Remarks Upon creating this object, the program monitors a fault tolerance group. Monitors are passive—they do not affect the group ..."},"1592":{y:0,u:"../dotnet-reference/FTGroupMonitor_1.htm",l:-1,t:"FTGroupMonitor",i:0.000930361792610662,a:"Constructor Visual Basic Overloads Public Sub New(     ByVal queue As  Queue ,     ByVal groupStateChangedEventHandler             As  GroupStateChangedEventHandler ,     ByVal transport As  Transport ,     ByVal groupName As String,     ByVal lostInterval As Double,     ByVal closure As Object ) ..."},});