define({"173":{y:0,u:"../programmers-guide/Getting_Started.htm",l:-1,t:"Getting Started",i:0.000254387859382893,a:"Getting Started This section provides details about the TIBCO® Patterns development kit."},"174":{y:0,u:"../programmers-guide/What_is_TIBCO_Patterns___Search_Developer_s_ToolKit__DevKit__.htm",l:-1,t:"What is TIBCO Patterns Developer’s ToolKit (DevKit)?",i:0.000254387859382893,a:"TIBCO Patterns DevKit is a high level \"C\" programming interface to the TIBCO Patterns server. The heart of the TIBCO Patterns DevKit is a set of about a dozen high-level command functions that load records into memory, update them in real time, and perform  queries on them. The TIBCO Patterns DevKit ..."},"175":{y:0,u:"../programmers-guide/A_Simple_Example.htm",l:-1,t:"A Simple Example",i:0.000838236739119771,a:"Here is a listing of source file lgrep.c, a simple, fully functional program that loads a text file of one-field records into the DevKit, then looks up records for a query. If you are familiar with Unix systems, consider it as an TIBCO Patterns analogue of the grep utility. While simple, this ..."},"176":{y:0,u:"../programmers-guide/The_DevKit_Header_File_devkit_h.htm",l:-1,t:"The DevKit Header File devkit.h",i:0.000254387859382893,a:"The DevKit Header File devkit.h The header file devkit.h has all the type definitions, macros, and function prototypes you need for the DevKit. It is normally installed in the netrics subdirectory of an include directory on your standard include path."},"177":{y:0,u:"../programmers-guide/Compiling_and_Linking_Programs_With_the_DevKit.htm",l:-1,t:"Compiling and Linking Programs With the DevKit",i:0.000254387859382893,a:"The DevKit can be used only on systems that fully support ANSI-compliant C and the POSIX threads interface. Depending on your system, you might need to specify libraries explicitly when linking a program with the DevKit. On a Linux system, for example, here is how you would link lgrep: cc -o lgrep ..."},"178":{y:0,u:"../programmers-guide/Input_and_Output_Parameter_Types.htm",l:-1,t:"Input and Output Parameter Types",i:0.000686858373877863,a:"When you looked at the source code for the lgrep program in  A Simple Example , you probably noticed the important role of the generic parameter type lpar_t. This type provides a clean, extensible interface for DevKit command functions. A value of type lpar_t is called an lpar, and is pronounced ..."},"179":{y:0,u:"../programmers-guide/Building_the_Input__lpars.htm",l:-1,t:"Building the Input: lpars",i:0.000254387859382893,a:"An lpar is a value and an integer code, called the lpar ID, that identifies the value\u0027s data type. Lpar ID\u0027s are predefined in the header file devkit.h. Here is a partial listing of that file:   enum lparid_en {         /* ... */         LPAR_STR_DBDESCRIPTOR,     /* Database name */         ..."},"180":{y:0,u:"../programmers-guide/Building_the_Input__Data_Records.htm",l:-1,t:"Building the Input: Data Records",i:0.000497581469635378,a:"There is a special list type of lpar used to construct and manipulate data records: The record is a child record if the parent key string is present. The parent key string is a null-terminated character string that is used to identify the parent record of the child record. The value is the key ..."},"181":{y:0,u:"../programmers-guide/Processing_the_Output_of_DevKit_Commands.htm",l:-1,t:"Processing the Output of DevKit Commands",i:0.000724390290331856,a:"Most DevKit command functions return lists. The following example illustrates two ways to access them:   typedef unsigned char UCHAR; /* ... */ {     int       i, item, numitems, recnum, numrecs, arrlen;     int       srchtxtlen;     lpar_t    query, lpar;     lpar_t    name, srchpars, stats, ..."},"182":{y:0,u:"../programmers-guide/The_lpar_find_lst_lpar_Function.htm",l:-1,t:"The lpar_find_lst_lpar Function",i:0.000254387859382893,a:"There is still another way of accessing items in a list lpar. You can call the function lpar_find_lst_lpar with a specific lpar id, and the function return the lpar in the list that has that id, or the value LPAR_NULL if such an lpar was not found.  If there is more than one lpar in a list with the ..."},"183":{y:0,u:"../programmers-guide/Destroying_DevKit_Command_Output.htm",l:-1,t:"Destroying DevKit Command Output",i:0.000254387859382893,a:"The application that uses the DevKit is responsible for destroying all DevKit command output. Since all command output is in the form of lists, simply calling lpar_destroy for each list is sufficient. Note that even a list of lists (for more information, see  Processing the Output of DevKit Commands ..."},"184":{y:0,u:"../programmers-guide/Printing_Input_and_Output_Objects.htm",l:-1,t:"Printing Input and Output Objects",i:0.000254387859382893,a:"For debugging purposes, it\u0027s useful to be able to print the contents of an lpar. The DevKit provides the following function that prints to a file stream: void lpar_fprintf( FILE *stream, lpar_t lpar, int nicechar ); The object parameter can be any type of lpar. The function operates recursively, ..."},"185":{y:0,u:"../programmers-guide/An_important_Word__and_a_Warning__About_Error_Conditions.htm",l:-1,t:"An Important Word (and a Warning) About Error Conditions",i:0.000417151402828718,a:"Now that you know everything there is need to know about DevKit input and output, it\u0027s time to discuss DevKit command functions in detail. But first, we need to have a brief but very important discussion of the way in which DevKit commands return error-related information. As you\u0027ll see from the ..."},"186":{y:0,u:"../programmers-guide/The_TIBCO_Patterns___Search_Table.htm",l:-1,t:"The TIBCO Patterns Table",i:0.00104321854699356,a:"Before describing the commands to load and search a TIBCO Patterns database, you must be clear about the logical structure of the database. For historical reasons, throughout the document the term database is used as a synonym for table. But in the following section the term database refers to the ..."},"187":{y:0,u:"../programmers-guide/Matching_Accelerators__prefilters_.htm",l:-1,t:"Matching Accelerators (prefilters)",i:0.000254387859382893,a:"A Matching Accelerator speeds matching by quickly filtering out many table records from consideration before performing a full match calculation. Thus they are generally referred to as prefilters. GIP, SORT, and PSI are the three prefilters that provide a large boost in search time performance. It ..."},"188":{y:0,u:"../programmers-guide/The_GIP_Prefilter___Usage_Details.htm",l:-1,t:"The GIP Prefilter - Usage Details",i:0.000450308020139041,a:"If the GIP prefilter is the default prefilter, any table you load is automatically configured for matching acceleration with the GIP prefilter at load time. If for any reason you do not wish a particular table to be so configured simply include the Boolean parameter LPAR_BOOL_GIPSEARCH with a value ..."},"189":{y:0,u:"../programmers-guide/The_SORT_Prefilter___Usage_Details.htm",l:-1,t:"The SORT Prefilter - Usage Details",i:0.000361188658523302,a:"A SORT prefilter uses a collection of sorted indexes. A single sorted index is called an encoding. When creating a table that is to use a SORT prefilter, the collection of encodings to be used might be defined. If you do not specify them explicitly, a default set is created. The default set is ..."},"190":{y:0,u:"../programmers-guide/The_PSI_Prefilter___Usage_Details.htm",l:-1,t:"The PSI Prefilter - Usage Details",i:0.000361188658523302,a:"Like the SORT prefilter, a PSI prefilter uses a collection of sorted indexes. The terminology, defaults, and restrictions of the SORT prefilter apply to the PSI prefilter. Creating a PSI prefilter is the same as creating a SORT prefilter: pass an LPAR_LST_ENCODINGS in the dbpars parameter of the ..."},"191":{y:0,u:"../programmers-guide/Variable_Attributes___Usage_Details.htm",l:-1,t:"Variable Attributes - Usage Details",i:0.000688451363218488,a:"The Variable Attributes feature provides the ability to associate with a record a variable number of labeled pieces of data and then search for records based on these labeled values. These labeled pieces of information are called Attributes of the record. The feature is called Variable Attributes ..."},"192":{y:0,u:"../programmers-guide/Federated_Tables.htm",l:-1,t:"Federated Tables",i:0.000254387859382893,a:"When working with federated tables through a gateway there are a number of additional error codes that might be returned. These codes might be returned by almost any command, so they are described once here, and not mentioned further in the individual command descriptions. All of these codes start ..."},"193":{y:0,u:"../programmers-guide/Federated_Tables_and_Gateways.htm",l:-1,t:"Federated Tables and Gateways",i:0.000745545555172564,a:"TIBCO Patterns directly supports federated tables through a gateway server. Although this feature has little impact on the API described in this document some understanding of federated tables and gateway servers are useful. A brief description of the important points is given here. For a full ..."},"194":{y:0,u:"../programmers-guide/Communicating_with_TIBCO_Patterns_-_Search_Servers.htm",l:-1,t:"Communicating with TIBCO Patterns Servers",i:0.00730024015216607,a:"In all of the examples so far the tables have been assumed to be local, that is within the same process. However, you are probably communicating with a TIBCO Patterns server process, in which case the host must be identified. This is done using the host parameter.  The host parameter is always the ..."},"195":{y:0,u:"../programmers-guide/Field_Names___Referencing_a_Field_in_a_Table.htm",l:-1,t:"Field Names – Referencing a Field in a Table",i:0.000254387859382893,a:"The field names used in a query or predicate expression have the following form: [table-name.]field-name[:attribute-name] An optional table name followed by a period, a field name and an optional variable attribute name preceded by a colon.  Never enter the period without a table name, or a colon ..."},"196":{y:0,u:"../programmers-guide/Restrictions_on_Names.htm",l:-1,t:"Restrictions on Names",i:0.000254387859382893,a:"The names of in-memory objects (tables, thesauri, character maps, and Learn Models) must not contain any of the following characters: at sign (@) backslash (\\) forward slash (/) colon (:) newline character In addition, the name of a table must not contain a period (.). The field names must not ..."},"197":{y:0,u:"../programmers-guide/Essential_DevKit_Commands.htm",l:-1,t:"Essential DevKit Commands",i:0.000382957029512186,a:"This section explains the basic DevKit command functions that perform the following tasks: system initialization and cleanup, creating and destroying DevKit tables and checking their status, and TIBCO Patterns matching and machine learning scoring operations. For ease of reference, we follow a ..."},"198":{y:0,u:"../programmers-guide/DevKit_System_Initialization__lkt_devkit_init_.htm",l:-1,t:"DevKit System Initialization (lkt_devkit_init)",i:0.000254387859382893,a:"dvkerr_t  lkt_devkit_init( void ); Before calling any other functions, all DevKit applications must: Make any desired changes to DevKit parameters, by calling lkt_devkit_get_parameters and lkt_devkit_set_parameters. Call lkt_devkit_init. This applies to the input-building functions discussed in  ..."},"199":{y:0,u:"../programmers-guide/Loading_a_Database__lkt_dbload_.htm",l:-1,t:"Loading a Database (lkt_dbload)",i:0.000622579053003472,a:"This command is the only DevKit command that creates a new database. dvkerr_t lkt_dbload( lpar_t host, lpar_t name, lpar_t dbpars, lpar_t reclist,                       lpar_t *dbstats ); dvkerr_t lkt_dbloadT(lpar_t host, lpar_t name, lpar_t tran, lpar_t dbpars,                      lpar_t reclist, ..."},"200":{y:0,u:"../programmers-guide/Reading_a_Database_From_a_File__lkt_dbread_.htm",l:-1,t:"Reading a Database From a File (lkt_dbread)",i:0.000666543277386526,a:"The dbread command is used to facilitate database loading. It\u0027s designed to read records from a file and produce a record list and database parameter list suitable for input to lkt_dbload. dvkerr_t lkt_dbread( lpar_t file, lpar_t parameters,                       lpar_t *reclist, lpar_t *dbpars ); ..."},"201":{y:0,u:"../programmers-guide/Reading_a_Database_From_a_File_in_Small_Chunks__lkt_open_dbfile_.htm",l:-1,t:"Reading a Database From a File in Small Chunks (lkt_open_dbfile)",i:0.000254387859382893,a:"The dbread command reads an entire database file, but there might be times when it is desirable to open a file and only read a handful of records at a time. dvkerr_t lkt_open_dbfile( lpar_t file, lpar_t parameters,                            lpar_t *filehandle, lpar_t *dbpars ); lkt_open_dbfile is ..."},"202":{y:0,u:"../programmers-guide/Reading_a_Database_From_a_File_in_Small_Chunks__lkt_read_records_.htm",l:-1,t:"Reading a Database From a File in Small Chunks (lkt_read_records)",i:0.000254387859382893,a:"The following command is used to read records from the database. dvkerr_t lkt_read_records(lpar_t host, lpar_t filehandle, lpar_t *reclist,                             int numrecords ); lkt_read_records accepts a filehandle lpar returned by lkt_open_dbfile and reads up to numrecords from the file ..."},"203":{y:0,u:"../programmers-guide/Deleting_a_Database__lkt_dbdelete_.htm",l:-1,t:"Deleting a Database (lkt_dbdelete)",i:0.000254387859382893,a:"This command deletes a database, releasing all storage associated with it and with its records. dvkerr_t lkt_dbdelete(lpar_t host, lpar_t name ); dvkerr_t lkt_dbdeleteT(lpar_t host, lpar_t name, lpar_t tran ); If the database has been checkpointed (see  Checkpointing and Restoring a Database ) the ..."},"204":{y:0,u:"../programmers-guide/Renaming_a_Database__lkt_dbmove_.htm",l:-1,t:"Renaming a Database (lkt_dbmove)",i:0.000302501477228601,a:"This command renames a table.  dvkerr_t lkt_dbmove( lpar_t host, lpar_t srcname, lpar_t dstname ); dvkerr_t lkt_dbmoveT( lpar_t host, lpar_t srcname, lpar_t tran, lpar_t dstname ); The database\u0027s new name is dstdesc. If there already exists a database with name dstdesc, that database is deleted. If ..."},"205":{y:0,u:"../programmers-guide/Checking_the_Status_of_Loaded_Databases__lkt_dblist_.htm",l:-1,t:"Checking the Status of Loaded Databases (lkt_dblist)",i:0.000254387859382893,a:"The following command returns a list of lists of database statistics one list per database specified. dvkerr_t lkt_dblist( lpar_t host, lpar_t names, lpar_t *dbstatlists ); Input host (optional) This is used to identify the server. For more information, see  Communicating with TIBCO Patterns Servers ..."},"206":{y:0,u:"../programmers-guide/Invoking_TIBCO_Patterns___Search_Matching__lkt_dbsearch_.htm",l:-1,t:"Invoking TIBCO Patterns Matching (lkt_dbsearch)",i:0.0013116849258854,a:"The following command finds matches for a given query over a list of databases. It returns statistics, matching records, and per-match information. dvkerr_t lkt_dbsearch( lpar_t host, lpar_t names, lpar_t dbparlists,                         lpar_t query, lpar_t srchpars, lpar_t *stats,               ..."},"207":{y:0,u:"../programmers-guide/Online_Cluster_Configuration_Modification__lkt_cl_cfg_reload_.htm",l:-1,t:"Online Cluster Configuration Modification (lkt_cl_cfg_reload)",i:0.000254387859382893,a:"This command is used to load a new configuration into a running gateway.  lkt_cl_cfg_reload(lpar_t host, lpar_t filedesc , lpar_t options); It has following restrictions: There can be no open transactions when the configuration is reloaded. Loading a new configuration, blocks all modify commands ..."},"208":{y:0,u:"../programmers-guide/Termination_and_Cleanup__lkt_devkit_shutdown_.htm",l:-1,t:"Termination and Cleanup (lkt_devkit_shutdown)",i:0.000254387859382893,a:"The following command shuts down the DevKit, and releases all storage associated with all loaded databases.  dvkerr_t lkt_devkit_shutdown( void ); It does not release any storage allocated by calls to the creator functions for lpars, records or lists documented in  Input and Output Parameter Types . ..."},"209":{y:0,u:"../programmers-guide/Getting_Version_Information__lkt_devkit_version_.htm",l:-1,t:"Getting Version Information (lkt_devkit_version)",i:0.000254387859382893,a:"This function returns a string lpar with id LPAR_STR_DEVKITINFO. The lpar value is a printable string giving version numbers and compilation information for this version of the DevKit.    \t\tlpar_t lkt_devkit_version( void ); The output of this function should be destroyed with a call to lpar_destroy ..."},"210":{y:0,u:"../programmers-guide/An_Explanation_of_Match_Scores.htm",l:-1,t:"An Explanation of Match Scores",i:0.000313075040677594,a:"To fully understand how to use the TIBCO Patterns servers\u0027 search technology, it\u0027s important to have a basic understanding of what the match score returned by the search engine does and does not mean. What the match score is not is a percentage of the query found in the record. In other words, a ..."},"211":{y:0,u:"../programmers-guide/Score_Types.htm",l:-1,t:"Score Types",i:0.000313075040677594,a:"A search computes several types of scores, each of which is appropriate for a separate problem domain. Score types are defined by the lscore_t enumerated type in the DevKit header. By passing an LPAR_INT_SORTSCORE parameter at search time, you can select which type of score is used for ranking ..."},"212":{y:0,u:"../programmers-guide/Tie_Breaking.htm",l:-1,t:"Tie Breaking",i:0.000313075040677594,a:"Custom tie breaking rules allow you to control how records are ordered in the event that multiple records receive the same score. Tie breaks are specified by attaching an LPAR_LST_TIEBREAKS list lpar to the search parameters list. This is an ordered list of tie breaking rules. The first rule in the ..."},"213":{y:0,u:"../programmers-guide/Dynamic_Score_Cutoffs.htm",l:-1,t:"Dynamic Score Cutoffs",i:0.00071254974446552,a:"Because it is inappropriate to cut off search results at a static score threshold, there are several configurable dynamic methods which can be used. Cutoff types are defined by the lcutoff_t enumerated type in the DevKit header. A cutoff is specified by creating an LPAR_LST_CUTOFF which contains an ..."},"214":{y:0,u:"../programmers-guide/Partition_Indexes.htm",l:-1,t:"Partition Indexes",i:0.00129936599022468,a:"Partition Indexes are used in conjunction with record filtering predicates to speed the selection of a subset of records based on some exact matching criteria, e.g. search only those patient records with a date of birth within two years of May 8, 1964. See dbparlists in  Invoking TIBCO Patterns ..."},"215":{y:0,u:"../programmers-guide/Detailed_Description.htm",l:-1,t:"Detailed Description",i:0.000254387859382893,a:"Detailed Description This section describes additional commands to the core set described in the previous section, and provides more detailed information on using the TIBCO Patterns server."},"216":{y:0,u:"../programmers-guide/Updating_Loaded_Databases.htm",l:-1,t:"Updating Loaded Databases",i:0.000302501477228601,a:"The commands described in  Essential DevKit Commands  are sufficient for many applications that do not do real-time data updates. By using the commands described in this section you can update databases in real-time. While a command like lkt_dbrecreplace or lkt_dbrecadd is modifying a database, all ..."},"217":{y:0,u:"../programmers-guide/Adding_Records_to_a_Database__lkt_dbrecadd_.htm",l:-1,t:"Adding Records to a Database (lkt_dbrecadd)",i:0.000254387859382893,a:"This command adds one or more records to a database.    dvkerr_t lkt_dbrecadd(lpar_t host, lpar_t dbname, lpar_t reclist,                         lpar_t params,lpar_t *dbstats ); dvkerr_t lkt_dbrecaddT(lpar_t host, lpar_t dbname, lpar_t tran, lpar_t reclist,                        lpar_t params, ..."},"218":{y:0,u:"../programmers-guide/Deleting_Records_From_a_Database__lkt_dbrecdelete_.htm",l:-1,t:"Deleting Records From a Database (lkt_dbrecdelete)",i:0.000354964221252386,a:"The following command deletes one or more records from a database. Statistics are returned for the modified database.   dvkerr_t lkt_dbrecdelete(lpar_t host, lpar_t dbname, lpar_t reckeylist,                            lpar_t params, lpar_t *dbstats ); dvkerr_t lkt_dbrecdeleteT(lpar_t host, lpar_t ..."},"219":{y:0,u:"../programmers-guide/Replacing_Records_in_a_Database__lkt_dbrecreplace_.htm",l:-1,t:"Replacing Records in a Database (lkt_dbrecreplace)",i:0.000326466278465388,a:"The following command replaces one or more records in a database. Statistics are returned for the modified database.   dvkerr_t lkt_dbrecreplace(lpar_t host, lpar_t dbname, lpar_t reclist,                             lpar_t params, lpar_t *dbstats ); dvkerr_t lkt_dbrecreplaceT(lpar_t host, lpar_t ..."},"220":{y:0,u:"../programmers-guide/Updating_Records_in_a_Database__lkt_dbrecupdate_.htm",l:-1,t:"Updating Records in a Database (lkt_dbrecupdate)",i:0.000326466278465388,a:"The lkt_dbrecupdate command combines the functionality of lkt_dbrecadd, lkt_dbrecreplace and lkt_dbrecdelete. If a simple record is passed to the command, it adds the record if a record with the same key does not exist; if a record with the same key exists, the existing record is replaced with the ..."},"221":{y:0,u:"../programmers-guide/Looking_Up_Records_in_a_Database__lkt_dbrecget_.htm",l:-1,t:"Looking Up Records in a Database (lkt_dbrecget)",i:0.000354964221252386,a:"The following command retrieves (without modifying or deleting) one or more records from a database. dvkerr_t lkt_dbrecget(lpar_t host, lpar_t dbname, lpar_t reckeylist,                         lpar_t params, lpar_t *reclist ); Input host (optional) This is used to identify the server. For more ..."},"222":{y:0,u:"../programmers-guide/Scanning_Records_in_a_Table.htm",l:-1,t:"Scanning Records in a Table",i:0.000254387859382893,a:"Scanning Records in a Table The following command is provided for scanning through records of a table: lkt_dbrecnext - scans through records using a cursor position token"},"223":{y:0,u:"../programmers-guide/Scanning_Records_Using_a_Cursor__lkt_dbrecnext_.htm",l:-1,t:"Scanning Records Using a Cursor (lkt_dbrecnext)",i:0.000254387859382893,a:"This function is used to retrieve all records, or a subset of records in a table. int cursor_at_EOT(lpar_t next_pt); int cursor_skipped_records(lpar_t next_pt); dvkerr_t lkt_dbrecnext(lpar_t host, lpar_t dbname, lpar_t tran,                         lpar_t start_pt,lpar_t params,                      ..."},"224":{y:0,u:"../programmers-guide/Checkpointing_and_Restoring_a_Database.htm",l:-1,t:"Checkpointing and Restoring a Database",i:0.000491074658135928,a:"With TIBCO Patterns server, you can write any or all of its in-memory data objects (database tables, thesauri, Learn Models, and custom character maps) to a permanent data store. The manual version of this process is called checkpointing. The saved objects can be restored at a later time. This ..."},"225":{y:0,u:"../programmers-guide/Checkpoint__lkt_checkpoint_.htm",l:-1,t:"Checkpoint (lkt_checkpoint)",i:0.000362505488006635,a:"Use the following functions to checkpoint all, or a selected set of, in-memory objects: dvkerr_t lkt_checkpoint(lpar_t host, lpar_t names, lpar_t *dblist); dvkerr_t lkt_checkpointT(lpar_t host, lpar_t names, lpar_t tran,                           lpar_t options, lpar_t *dblist); If a checkpoint of ..."},"226":{y:0,u:"../programmers-guide/Restore__lkt_restore_.htm",l:-1,t:"Restore (lkt_restore)",i:0.000254387859382893,a:"Use the following functions to restore all, or a selected set of, in-memory objects: dvkerr_t lkt_restore(lpar_t host, lpar_t names, lpar_t *dblist); dvkerr_t lkt_restoreT(lpar_t host, lpar_t names, lpar_t tran, lpar_t *dblist); If a restore of multiple objects is requested all objects that can be ..."},"227":{y:0,u:"../programmers-guide/Checking_Server_Status.htm",l:-1,t:"Checking Server Status",i:0.000254387859382893,a:"These functions are used to query or control the state of the server process itself. When sent to a gateway these operations act only on the gateway itself, they don\u0027t change or reflect the status of any nodes controlled by the gateway. For more information on gateways and nodes see  Federated ..."},"228":{y:0,u:"../programmers-guide/Checking_Server_Status__lkt_svrnoop_.htm",l:-1,t:"Checking Server Status (lkt_svrnoop)",i:0.000254387859382893,a:"The server noop command literally does nothing. If the server is alive, it always returns success. This can be used to test connectivity. dvkerr_t lkt_svrnoop( lpar_t host); Input host (required) For more information, see  Communicating with TIBCO Patterns Servers . Error codes and items returned by ..."},"229":{y:0,u:"../programmers-guide/Getting_TIBCO_Patterns___Search_Servers_Version_Information__lkt_svrvers.htm",l:-1,t:"Getting TIBCO Patterns Servers Version Information (lkt_svrversion)",i:0.000254387859382893,a:"The following command is used to get the server version and configuration information: dvkerr_t lkt_svrversion( lpar_t host, lpar_t *version ); lkt_svrversion returns information that can identify the particular version of the server that is running and information on its current configuration. ..."},"230":{y:0,u:"../programmers-guide/Getting_command_performance_statistics__lkt_svrcmdstats_.htm",l:-1,t:"Getting command performance statistics (lkt_svrcmdstats)",i:0.000254387859382893,a:"This command is used to retrieve summary reports on performance statistics for one or more commands. It is also used to reset the statistics back to a zero state, that is, delete all existing statistics history for one or more commands. dvkerr_t lkt_svrcmdstats( lpar_t host, lpar_t iargs,            ..."},"231":{y:0,u:"../programmers-guide/Server_Shutdown.htm",l:-1,t:"Server Shutdown",i:0.000254387859382893,a:"The following function shuts down the server.    dvkerr_t lkt_svrshutdown( lpar_t host ); It is normally not necessary to use this command. A client should not shut down the server as a normal part of disconnecting. Input host (required) For more information, see  Communicating with TIBCO Patterns ..."},"232":{y:0,u:"../programmers-guide/Server_Logging_On.htm",l:-1,t:"Server Logging On",i:0.000254387859382893,a:"The following function turns on server query logging and/or alters the log format being used.  dvkerr_t lkt_svrlogon( lpar_t hostc, lpar_t format ); In order for this command to have any effect, the server must have been started with the −l command line option to specify the name of the query log ..."},"233":{y:0,u:"../programmers-guide/Server_Logging_Off.htm",l:-1,t:"Server Logging Off",i:0.000254387859382893,a:"Server Logging Off This function turns off server query logging. dvkerr_t lkt_svrlogoff( lpar_t host ); Input host (required) For more information, see  Communicating with TIBCO Patterns Servers . Error codes and items returned by lkt_svrlogoff "},"234":{y:0,u:"../programmers-guide/Scoring_a_Set_of_Records__lkt_scorerecords_.htm",l:-1,t:"Scoring a Set of Records (lkt_scorerecords)",i:0.000254387859382893,a:"This command is similar to the lkt_dbsearch command except that it applies the query to a given set of records instead of to an in-memory table of records. dvkerr_t lkt_scorerecords( lpar_t host, lpar_t rec_def,                             lpar_t querypar, lpar_t srchpars,                            ..."},"235":{y:0,u:"../programmers-guide/Query_Construction.htm",l:-1,t:"Query Construction",i:0.00077034199314303,a:"With the advent of version 4.1 of the TIBCO Patterns servers, query construction has simplified dramatically. This section outlines the type of construction that is now suggested and is supported in the future. A query consists of a tree of \"score generators\" and \"score combiners.\" A score generator ..."},"236":{y:0,u:"../programmers-guide/Simple_Query.htm",l:-1,t:"Simple Query",i:0.000402194402293332,a:"A simple query is a comparison of an input query string and one or more fields in the table. The TIBCO Patterns servers\u0027 intelligent string matching algorithm is used to score the comparison and tolerate errors. This is the most common score generator and the TIBCO Patterns servers raison d\u0027etre. A ..."},"237":{y:0,u:"../programmers-guide/Cognate_Query.htm",l:-1,t:"Cognate Query",i:0.000708609356900314,a:"A cognate query is a more complex version of a simple query. It uses the same string comparison algorithm but performs the match with multiple query strings. For instance, a first and last name can be searched against the first and last name fields of the database. This aids in finding transposed ..."},"238":{y:0,u:"../programmers-guide/Attributes_Query.htm",l:-1,t:"Attributes Query",i:0.000254387859382893,a:"An attributes query is a comparison of a set of input query strings against a set of attribute values. This query is analogous to an AND of simple queries, each simple query being a comparison of one value against one attribute. It is provided as a shortcut convenience when querying a set of ..."},"239":{y:0,u:"../programmers-guide/Predicate_Query.htm",l:-1,t:"Predicate Query",i:0.000254387859382893,a:"The predicate is evaluated on the record and the result used as the score assigned by this score generator. Generally, the Boolean tests are used, in which case if it\u0027s true the score is 1.0, if it\u0027s false the score is 0.0. It is possible to have the predicate return a double value, which is used ..."},"240":{y:0,u:"../programmers-guide/Query_Combiners.htm",l:-1,t:"Query Combiners",i:0.000470623116630378,a:"Query combiners, also known as query expressions, are used to combine multiple input scores into a single score. LKT_QEXPR_AND takes the simple average of the input scores, LKT_QEXPR_OR takes the maximum score, and LKT_QEXPR_RLINK performs a much more sophisticated weighted combination under the ..."},"241":{y:0,u:"../programmers-guide/MatchCase_Score_Combiner_.htm",l:-1,t:"MatchCase Score Combiner ",i:0.000387735215546953,a:" A MatchCase query combiner, like other combiners, merges a set of scores into a single output score. Like all other combiners, it can appear as any non-leaf node in a query tree. There is one important subtle difference between the MatchCase combiner and other combiners. Other combiners output a ..."},"242":{y:0,u:"../programmers-guide/First_Valid_Score_Combiner.htm",l:-1,t:"First Valid Score Combiner",i:0.000470623116630378,a:"The First Valid score combiner is used in conjunction with the RLINK score combiner (see  TIBCO Patterns Machine Learning Platform  and  Using a Learn Model in a Search ). It is used to select a querylet based on its confidence value. For more information on the use cases for this score combiner, ..."},"243":{y:0,u:"../programmers-guide/Named_Querylets_.htm",l:-1,t:"Named Querylets ",i:0.000254387859382893,a:" Complex query trees can be constructed using the score generator and score combiner querylets described in the  Query Combiners  section. By default only the scores from the top level querylet are returned. Usually this is all that is needed, but in some cases you might need to know the score ..."},"244":{y:0,u:"../programmers-guide/Querylet_References.htm",l:-1,t:"Querylet References",i:0.000254387859382893,a:"In some complex query situations, the identical querylet must be repeated two or more times at different locations in the query tree. The example in the Match Case score combiner section shows one of these queries. In this example the querylets for each category are repeated twice, one time for each ..."},"245":{y:0,u:"../programmers-guide/Old_style_Query_Construction.htm",l:-1,t:"Old-style Query Construction",i:0.000362505488006635,a:"This style of query construction is deprecated as of version 4.1. It remains only for the sake of reverse compatibility and to document functionality which previous users might still be using. See  Query Construction  for more information on the currently recommended query formulation. Note that not ..."},"246":{y:0,u:"../programmers-guide/Predicate_Expressions.htm",l:-1,t:"Predicate Expressions",i:0.0010453080344561,a:"Predicate expressions are used in two contexts: to filter records from a database while doing a search or to generate scores when evaluating the match strength of a record. For example, if each record has a field which contains a date, and you only want to search records with dates after a certain ..."},"247":{y:0,u:"../programmers-guide/Predicate_lpar_Expressions.htm",l:-1,t:"Predicate lpar Expressions",i:0.000736932831366932,a:"The list-type lpar LPAR_LST_PREDICATE contains a predicate expression consisting of one, two, or three elements. Single-element predicates consist solely of a predicate component, which is either a fixed value, a reference to a record field, or another (nested) predicate expression. The following ..."},"248":{y:0,u:"../programmers-guide/Predicate_Functions_and_Argument_Lists.htm",l:-1,t:"Predicate Functions and Argument Lists",i:0.000567637374188964,a:"As described in the previous section, Predicate lpar Expressions , predicate expressions consist of constant or field values, unary operators, and binary operators. There are some operations that need more than just one or two inputs. Consider determining the distance between two points on the ..."},"249":{y:0,u:"../programmers-guide/Controlling_Predicate_Error_Handling.htm",l:-1,t:"Controlling Predicate Error Handling",i:0.000313075040677594,a:"To be used as a filtering predicate in a search a predicate expression must evaluate to a Boolean value (true or false). For a query predicate the requirements are much more lenient, the predicate value need only be convertible to a Double. This includes Boolean values (by far the most common case) ..."},"250":{y:0,u:"../programmers-guide/Predicate_String_Expressions.htm",l:-1,t:"Predicate String Expressions",i:0.000254387859382893,a:"For predicates constructed on the fly the LPAR form described in the previous section might be appropriate, but the string format described here might be more convenient to use and easier understand in other cases. The string form is passed in using the string type lpars LPAR_STR_PREDICATE or block ..."},"251":{y:0,u:"../programmers-guide/Predicate_Value_Data_type_Conversions.htm",l:-1,t:"Predicate Value Data-type Conversions",i:0.000254387859382893,a:"Predicates do not support implicit data-type conversions. You must perform an explicit conversion while performing a binary operation with operands of different types. For example, if the DOB field is of type DATETTIME then the predicate expression  DATE \\\"2001/01/01\\\" \u003c= $\\\"DOB\\ produces a PARAMVAL ..."},"252":{y:0,u:"../programmers-guide/Weighting_Fields.htm",l:-1,t:"Weighting Fields",i:0.000254387859382893,a:"Field weights allow you to alter the importance of fields in a record or querylet. Field weights can be attached to an LPAR_LST_SIMPLEQUERY, LPAR_LST_COGQUERY, LPAR_LST_ATTRQUERY or LPAR_LST_QUERYLET inside an old style multiquery. These field weights, contained in an LPAR_DBLARR_QFIELDWEIGHTS, are ..."},"253":{y:0,u:"../programmers-guide/Character_Mapping.htm",l:-1,t:"Character Mapping",i:0.000617112830057485,a:"Character maps are used to normalize text data before comparisons are performed. Normalization consists of one or more of: Fold letter case:This applies the Unicode Consortium defined rules for letter case folding to map all alphabetic characters to a common letter case. Fold diacritics:This applies ..."},"254":{y:0,u:"../programmers-guide/Creating_a_Custom_Character_Map__lkt_create_charmap_.htm",l:-1,t:"Creating a Custom Character Map (lkt_create_charmap)",i:0.000254387859382893,a:"The following functions create a new custom character map. Character maps created under a user transaction might not be used in table creation outside that transaction until the transaction is committed. dvkerr_t lkt_create_charmap(lpar_t host, lpar_t mapname, lpar_t mapdef ); dvkerr_t ..."},"255":{y:0,u:"../programmers-guide/Checking_the_Status_of_Character_Maps__lkt_charmap_list_.htm",l:-1,t:"Checking the Status of Character Maps (lkt_charmap_list)",i:0.000254387859382893,a:"The following command returns a list of the names of all existing character maps or checks for the existence of a particular character map or maps. dvkerr_t lkt_charmap_list(lpar_t host, lpar_t names, lpar_t *ret_stats ); Input names (optional) is a single character map name (LPAR_STR_CHARMAP) or a ..."},"256":{y:0,u:"../programmers-guide/Creating_a_Custom_Character_Map__Example.htm",l:-1,t:"Creating a Custom Character Map: Example",i:0.000254387859382893,a:"The following code sample creates a character map similar to the standard character map except that the characters ’\u0026’ and ’#’ are not mapped, the dash character ’-’ is deleted and the default case folding for the letter ’I’ is changed to that for Turkish. We start by checking to see if our ..."},"257":{y:0,u:"../programmers-guide/Thesaurus_Matching.htm",l:-1,t:"Thesaurus Matching",i:0.000707449630226492,a:"The TIBCO Patterns string matching algorithm does an excellent job of finding similar strings, but sometimes it\u0027s desirable to equate strings which are textually dissimilar. For example, a computer hardware vendor might want customers searching for notebook to be able to find items listed under ..."},"258":{y:0,u:"../programmers-guide/Creating_a_Thesaurus__lkt_create_thesaurus_.htm",l:-1,t:"Creating a Thesaurus (lkt_create_thesaurus)",i:0.000254387859382893,a:"The following command is used to create a thesaurus either locally or on a remote server. dvkerr_t lkt_create_thesaurus(lpar_t host, lpar_t thesaurus_options,                                 lpar_t thesaurus_data ); dvkerr_t lkt_create_thesaurusT(lpar_t host, lpar_t thesaurus_options,                ..."},"259":{y:0,u:"../programmers-guide/Checking_the_Status_of_Loaded_Thesauri__lkt_thlist_.htm",l:-1,t:"Checking the Status of Loaded Thesauri (lkt_thlist)",i:0.000254387859382893,a:"The following command returns a list of lists of thesaurus statistics - one list per thesaurus - specified. dvkerr_t lkt_thlist(lpar_t host, lpar_t names, lpar_t *thstatlists ); At this time only the thesaurus name, type and number of unique terms is returned. Input host (optional) This is used to ..."},"260":{y:0,u:"../programmers-guide/Deleting_Thesauri__lkt_delete_thesaurus_.htm",l:-1,t:"Deleting Thesauri (lkt_delete_thesaurus)",i:0.000254387859382893,a:"This function deletes one thesaurus, a list of thesauri, or all thesauri.  dvkerr_t lkt_delete_thesaurus(lpar_t host, lpar_t names); dvkerr_t lkt_delete_thesaurusT(lpar_t host, lpar_t names, lpar_t tran); If a delete of multiple thesauri is requested all thesauri that can be deleted are deleted even ..."},"261":{y:0,u:"../programmers-guide/Using_a_Thesaurus_in_a_Search.htm",l:-1,t:"Using a Thesaurus in a Search",i:0.000254387859382893,a:"To use a thesaurus in a search, simply pass an LPAR_STR_THESAURUSNAME as one of the search parameters (using the srchpars argument to lkt_dbsearch). A different thesaurus can be specified per querylet by adding an LPAR_STR_THESAURUSNAME to each LPAR_LST_SIMPLEQUERY, LPAR_LST_COGQUERY or ..."},"262":{y:0,u:"../programmers-guide/Ephemeral_Thesauri.htm",l:-1,t:"Ephemeral Thesauri",i:0.000707449630226492,a:"As an alternative to passing an LPAR_STR_THESAURUSNAME argument specifying a thesaurus previously created with the lkt_create_thesaurus command an LPAR_LST_THESAURUS can be passed in the search options, in the LPAR_LST_SIMPLEQUERY or in the LPAR_LST_COGQUERY (but not in the old style ..."},"263":{y:0,u:"../programmers-guide/Match_Visualization.htm",l:-1,t:"Match Visualization",i:0.000313075040677594,a:"In most cases, users of TIBCO Patterns servers profit greatly from the ability to see which portions of a matching record matched the query, and with what intensity. We call this match visualization. Typically, different colors and/or type sizes are used to highlight characters of matching records ..."},"264":{y:0,u:"../programmers-guide/Multithreaded_Programming_With_the_DevKit.htm",l:-1,t:"Multithreaded Programming With the DevKit",i:0.000382957029512186,a:"The DevKit is designed to be used in a multithreaded environment. It takes care of ensuring that all of the in-memory data objects are accessed and updated in thread safe manner. Applications using the DevKit need not worry about controlling access to these objects. However, it might be useful to ..."},"265":{y:0,u:"../programmers-guide/Transactions.htm",l:-1,t:"Transactions",i:0.000254387859382893,a:"A transaction is a group of write operations that can be committed or rolled back as a unit. A write operation is any operation that changes the existence or content of data on the Patterns  server. The following is a complete list of write operations:  \tTable load, delete, move, checkpoint, and ..."},"266":{y:0,u:"../programmers-guide/Transactions_Usage.htm",l:-1,t:"Transactions Usage",i:0.000254387859382893,a:"To use transactions, do the following: Create a transaction on the server using lkt_tran_create. Perform operations under the transaction using the lkt_xxxT functions, passing the transaction parameters created in step 1. Commit or roll back the transaction using lkt_tran_commit or lkt_tran_abort. ..."},"267":{y:0,u:"../programmers-guide/Creating_a_New_Transaction__lkt_tran_create_.htm",l:-1,t:"Creating a New Transaction (lkt_tran_create)",i:0.000254387859382893,a:"The command initiates a new transaction on the TIBCO Patterns server. The current limit to the number of open transactions on a TIBCO Patterns server is 255.   dvkerr_t lkt_tran_create(lpar_t host, lpar_t options,                           lpar_t *tran_lpar ); Input host    (optional) For more ..."},"268":{y:0,u:"../programmers-guide/Committing_a_Transaction__lkt_tran_commit_.htm",l:-1,t:"Committing a Transaction (lkt_tran_commit)",i:0.000254387859382893,a:"The following command commits all the work done under the specified transaction. dvkerr_t lkt_tran_commit( lpar_t host, lpar_t tran_lpar,                            lpar_t options ); Input host    (optional) For more information, see  Communicating with TIBCO Patterns Servers . tran_lpar (required) ..."},"269":{y:0,u:"../programmers-guide/Rolling_Back_a_Transaction__lkt_tran_abort_.htm",l:-1,t:"Rolling Back a Transaction (lkt_tran_abort)",i:0.000254387859382893,a:"The following command rolls back all the work done under the specified transaction.   dvkerr_t lkt_tran_abort( lpar_t host, lpar_t tran_lpar,                           lpar_t options ); Input host    (optional) For more information, see  Communicating with TIBCO Patterns Servers . tran_lpar ..."},"270":{y:0,u:"../programmers-guide/List_Transactions__lkt_tran_list_.htm",l:-1,t:"List Transactions (lkt_tran_list)",i:0.000254387859382893,a:"The following command returns statistics for transactions on the Patterns server.   dvkerr_t lkt_tran_list(lpar_t host, lpar_t tran_list,                         lpar_t options, lpar_t *tran_stats ); Only transactions that have been created but not committed or rolled back are reported. The listing ..."},"271":{y:0,u:"../programmers-guide/Transactions_Example.htm",l:-1,t:"Transactions Example",i:0.000254387859382893,a:"Create a character map and a table, and commit or roll them back together.   lpar_t   tran ;   /* the transaction id parameters. */ dvkerr_t err ;    /* return status of Devkit function calls */ /* parameters for character map creation */ lpar_t host ; lpar_t mapname ; lpar_t mapdef ; /* parameters ..."},"272":{y:0,u:"../programmers-guide/The_TIBCO_Patterns___Search_Machine_Learning_Platform.htm",l:-1,t:"The TIBCO Patterns Machine Learning Platform",i:0.000254387859382893,a:"The TIBCO Patterns Machine Learning Platform You can combine individual scores in an intelligent way using TIBCO Patterns Machine Learning Platform."},"273":{y:0,u:"../programmers-guide/TIBCO_Patterns___Search_Machine_Learning_Platform.htm",l:-1,t:"TIBCO Patterns Machine Learning Platform",i:0.000454408893628983,a:"The TIBCO Patterns Machine Learning Platform maximizes the difference between a match (good set of scores) and a non-match (bad set of scores). It does this using a Learn model that has been created and trained for the particular application. A model can be created and trained using the Learn UI ..."},"274":{y:0,u:"../programmers-guide/Loading_a_Learn_Model__lkt_create_rlmodel_.htm",l:-1,t:"Loading a Learn Model (lkt_create_rlmodel)",i:0.000254387859382893,a:"Using the following command you can load a TIBCO Patterns Learn Model either locally or on a remote server.   dvkerr_t lkt_create_rlmodel(lpar_t host, lpar_t name, lpar_t model ); dvkerr_t lkt_create_rlmodelT(lpar_t host, lpar_t name, lpar_t tran,                               lpar_t model ); ..."},"275":{y:0,u:"../programmers-guide/Checking_the_Status_of_Loaded_Learn_Models__lkt_rllist_.htm",l:-1,t:"Checking the Status of Loaded Learn Models (lkt_rllist)",i:0.000254387859382893,a:"The following command returns a list of lists of TIBCO Patterns Learn Model information, one list per model specified.  dvkerr_t lkt_rllist(lpar_t host, lpar_t names, lpar_t *rlstatlists ); The information returned includes the name of the model, the metadata associated with the model and the number ..."},"276":{y:0,u:"../programmers-guide/Deleting_Learn_Models__lkt_delete_rlmodel_.htm",l:-1,t:"Deleting Learn Models (lkt_delete_rlmodel)",i:0.000254387859382893,a:"The following function deletes one Learn model, a list of models, or all models. dvkerr_t lkt_delete_rlmodel(lpar_t host, lpar_t names); dvkerr_t lkt_delete_rlmodelT(lpar_t host, lpar_t names, lpar_t tran);  If a delete of multiple models is requested, all models that can be deleted are deleted, ..."},"277":{y:0,u:"../programmers-guide/Evaluating_Feature_Scores_Using_a_Learn_Model__lkt_rleval_.htm",l:-1,t:"Evaluating Feature Scores Using a Learn Model (lkt_rleval)",i:0.000254387859382893,a:"The following command is used to evaluate a feature vector on a TIBCO Patterns Learn Model. dvkerr_t lkt_rleval(lpar_t host, lpar_t modelname, lpar_t indata,                       lpar_t *outdata ); Input host (optional) This is used to identify the server. For more information, see  Communicating ..."},"278":{y:0,u:"../programmers-guide/Using_a_Learn_Model_in_a_Search.htm",l:-1,t:"Using a Learn Model in a Search",i:0.000513096074923685,a:"To use a trained Learn model in a search query use the LKT_QEXPR_RLINK query combiner. The name of the TIBCO Patterns Learn model to be used should be passed as an LPAR_STR_RLMODELNAME parameter to the LPAR_LST_QEXPR.  For a cutoff to be employed, the cutoff threshold can be encoded in the TIBCO ..."},"279":{y:0,u:"../programmers-guide/Table_of_DevKit_Error_Codes_and_Strings.htm",l:-1,t:"Table of DevKit Error Codes and Strings",i:0.000633386660076203,a:"This appendix includes the following error codes from the devkit.h header file: 1.    DVK_ERR_PARTIAL - Partial search results (sort of success) 2.    DVK_ERR_NOSYSINIT - System not initialized 3.    DVK_ERR_SYSINIT - System already initialized 4.    DVK_ERR_FEATURESET - Feature not present 5.    ..."},"280":{y:0,u:"../programmers-guide/Punctuation_Code_Points_Mapped_by_Built_in_Character_Maps.htm",l:-1,t:"Punctuation and Whitespace Code Points Mapped by Built-in Character Maps",i:0.000778987007107766,a:"This appendix includes the following DVK_CMP_STDNAME maps several punctuation code points to the blank character (0x20): Values (hexadecimal) above the ASCII range: Decimal Value Hex Value Unicode Character Name 894          0x037E       GREEK QUESTION MARK 903          0x0387       GREEK ANO TELEIA ..."},"281":{y:0,u:"../programmers-guide/FAQs.htm",l:-1,t:"Frequently Asked Questions",i:0.000254387859382893,a:"Frequently asked questions are listed questions and answers that are supposed to be commonly asked when using TIBCO Patterns. Is TIBCO Patterns accessible from Node.js? You can access TIBCO® Patterns  from Node.js™ using npm™. Node.js is a development tool for creating web applications and services ..."},"282":{y:0,u:"../security/Introduction.htm",l:-1,t:"Introduction",i:0.000254387859382893,a:"This document describes guidelines to ensure security within the various components of TIBCO® Patterns. It also provides additional security-related guidance and recommendations for other aspects of internal and external communication. In particular, this document provides details of product ..."},"283":{y:0,u:"../security/Product_Connectivity.htm",l:-1,t:"Product Connectivity",i:0.000254387859382893,a:"Overview of Network Communications TIBCO Patterns supports encrypting network communications to ensure security. The communication between the components of TIBCO Patterns standalone server and a cluster of servers is demonstrated in the following images: Standalone Server Cluster of Servers ..."},"284":{y:0,u:"../security/Data_Storage.htm",l:-1,t:"Data Storage",i:0.000254387859382893,a:"Data Persistence Directories To use the Checkpoint /Restore feature, or Data-Durability feature, a separate directory must be allocated for each running TIBCO Patterns server. The server must have full permission to add and delete files in this directory. The data for the checkpoint/restore and ..."},"285":{y:0,u:"../security/Configuring_Security_Options.htm",l:-1,t:"Configuring Security Options",i:0.000254387859382893,a:"With TIBCO® Patterns, you can secure data by configuring security options in the server and APIs. For more information, see the \"Running the TIBCO Patterns Server\" section in TIBCO® Patterns Installation guide.\n For more information about APIs, see the following documentation: The \"NetricsConMgr\" or ..."},"286":{y:0,u:"../Patterns_Data_Transfer_Tool.htm",l:-1,t:"Patterns Data Transfer Tool - Overview",i:0.000254387859382893,a:"This section describes the process of using Patterns Data transfer tool. TIBCO® Patterns stores multiple types of data while performing its role as an inexact matching engine. Transferring this data between Patterns installations can be difficult, particularly if the installation architectures are ..."},"287":{y:0,u:"../PDS_users-guide/Patterns-data-synchroniser.htm",l:-1,t:"Patterns Data Synchronizer - Overview",i:0.000254387859382893,a:"TIBCO® Patterns stores data tables while performing its role as an inexact matching engine. For some installations, these tables must be synchronized with tables stored in another database system. The Patterns Data Synchronizer (PDS) provides a basic solution for performing synchronization to ..."},"288":{y:0,u:"../PDS_users-guide/Prerequisites.htm",l:-1,t:"Prerequisites",i:0.000254387859382893,a:"Before using Patterns Data Synchronizer, familiarize yourself with the following information: Editing YAML  files. Apache™ JDBC, which PDS uses to communicate with the source database. Before you begin, see the database vendor’s documentation for the following details: -\tFormatting a JDBC connection ..."},"289":{y:0,u:"../PDS_users-guide/Source_Database_Change_log.htm",l:-1,t:"Source Database: Change-log and State Tables",i:0.000254387859382893,a:"PDS accesses a change-log table and a state table in the database.  Your application must create these in the source database. Change-log Table The  change-log table can have any table name that is valid in the source database. This name is entered in the PDS configuration file. Your application ..."},"290":{y:0,u:"../PDS_users-guide/Command_Line_Usage.htm",l:-1,t:"Command-Line Usage",i:0.000254387859382893,a:"The PDS command line is as follows: java [jvm_options] -jar  TIB_tps_datasyncer.jar config-file-name Example: java –jar TIB_tps_datasyncer.jar  names_table_PDS_settings.yaml An example of a shell-script for three joined tables: persons (parent table) and address and phone (child tables). nohup java ..."},"291":{y:0,u:"../PDS_users-guide/Logging.htm",l:-1,t:"Logging",i:0.000254387859382893,a:"Logging When PDS performs logging using Apache™ log4j2, the following events occur:  The PDS log-level defaults to INFO.  All other log4j2 defaults are unchanged. \n For more information about how to configure logging, see the Apache log4j2 documentation.\n"},"292":{y:0,u:"../PDS_users-guide/Limitations.htm",l:-1,t:"Limitations",i:0.000254387859382893,a:"PDS only synchronizes in one direction: from the source database to Patterns.   PDS has limited throughput, typically a few thousand records per second. Loading an excessive volume of records can take considerable time. PDS has the tradeoff of latency versus resource-consumption typical of polling ..."},"293":{y:0,u:"../PDS_users-guide/Configuration_File.htm",l:-1,t:"Configuration File",i:0.000254387859382893,a:"The PDS configuration file contains the following settings: Connection settings for the source database Connection settings for the Patterns Server A map of source-database table columns to Patterns table columns. Tuning options A fully-commented sample configuration file has the following contents: ..."},"294":{y:0,u:"../PDS_users-guide/JDBC-support.htm",l:-1,t:"JDBC Support",i:0.000254387859382893,a:"Data Synchronizer bundles two common JDBC drivers: PostgreSQL JDBC Connector, version 42.5.1 Microsoft JDBC Driver For SQL Server, version 11.2.3.jre8 To use a JDBC driver that is not in the above list: 1. place the driver jar, and any jars it depends on, at the start of the JVM classpath 2. ..."},"295":{y:0,u:"../PDS_users-guide/Advanced_Scenarios.htm",l:-1,t:"Many-To-One Synchronization",i:0.000254387859382893,a:"Advanced Scenarios Many-To-One Synchronization A single Patterns table can be updated from multiple sources by using multiple PDS commands, one per source.  Ensure that the keys from different sources do not overlap and each key must come from one and only one source. Overlapping keys can lead to ..."},"296":{y:0,u:"../nsc/NSC_Overview.htm",l:-1,t:"NSC Overview",i:0.000254387859382893,a:"  The NSC is a command line utility used to interact with the TIBCO® Patterns  server.  Commands can be issued one at a time or from a batch file.  NSC can be used to create, update, remove, view objects on the matching engine, or perform searches.  NSC serves as both a potentially useful tool in ..."},"297":{y:0,u:"../nsc/NSC_Configuration_Arguments.htm",l:-1,t:"NSC Configuration Arguments",i:0.000254387859382893,a:"Configuration arguments are optional and defaults are used if arguments are not specified. The configuration arguments are only valid on the initial execution of NSC.  Issuing –host or –port on a secondary line in a batch file has  no effect since the secondary commands are already inside the ..."},"298":{y:0,u:"../nsc/NSC_Commands.htm",l:-1,t:"NSC Commands",i:0.000254387859382893,a:"Command -cmd All NSC commands are prefaced by the -cmd parameter. Command line switches that follow the specified cmd parameter are arguments to the command. Batch Command The NSC can accept a series of commands as follows: The commands should reside in a file. Each command in the file will start on ..."},"299":{y:0,u:"../nsc/Table_Commands.htm",l:-1,t:"tbllist",i:0.000254387859382893,a:"Table Commands The following commands are used to interact with the data tables on the matching engine. tbllist The ‘tbllist’ command returns a list of all tables loaded in the matching engine. Example output: List: GENERIC\n    DBDESCRIPTOR: std\n    LAYOUT: \n    CHECKPOINT_STATUS: Never ..."},"300":{y:0,u:"../nsc/Table_Statistics_Command.htm",l:-1,t:"tblstats –table \u003cname\u003e",i:0.000254387859382893,a:"Table Statistics Command tblstats –table \u003cname\u003e The tblstats command returns various statistical information about the specified table. Example of output against a table called ‘names’.\n \n-- Table Statistics: names\nThe status of any checkpoint for this table: Never Checkpointed\nThe total size of the ..."},"301":{y:0,u:"../nsc/Thesaurus_Commands.htm",l:-1,t:"thlist",i:0.000254387859382893,a:"Thesaurus Commands thlist The thlist command returns a list of all the thesauri loaded in the matching engine. thcreate  -thesaurus \u003cname\u003e -file \u003cfile\u003e[-local] The thcreate command is used to create a thesaurus in the matching engine.  file is the name of a standard thesaurus definition file. See ..."},"302":{y:0,u:"../nsc/Record_Commands.htm",l:-1,t:"recget –table \u003cname\u003e -keys \u003ckey1,key2,...\u003e",i:0.000254387859382893,a:"Record Commands recget –table \u003cname\u003e -keys \u003ckey1,key2,...\u003e The recget command will retrieve each of the records with the specified key(s) and display them to the standard out. recdelete –table \u003cname\u003e -keys \u003ckey1,key2,...\u003e [-domaxwork] The recdelete command will delete each of the records with the ..."},"303":{y:0,u:"../nsc/Character_Map_Commands.htm",l:-1,t:"maplist",i:0.000254387859382893,a:"Character Map Commands maplist The maplist command will return a list of all the character maps loaded in the matching engine. mapcreate –mapname \u003cname\u003e [-mapchars \u003cmap-file\u003e] [-foldcase] [-folddiacritics]  [-punctuation \u003cc\u003e]  [-whitespace \u003cc\u003e]  The mapcreate command will create a character map in ..."},"304":{y:0,u:"../nsc/Index_Command.htm",l:-1,t:"idxlist –tables \u003ctable1,table2,...\u003e",i:0.000254387859382893,a:"Index-List Command idxlist –tables \u003ctable1,table2,...\u003e Use the idxlist command to list all the indexes associated with the specified table(s)."},"305":{y:0,u:"../nsc/Query_Commands.htm",l:-1,t:"search  -query \u003cquery-str\u003e -table \u003cname\u003e [-fields \u003cfield1,field2,...\u003e]",i:0.000254387859382893,a:"Query Commands search  -query \u003cquery-str\u003e -table \u003cname\u003e [-fields \u003cfield1,field2,...\u003e] The search command allows you to run a simple query against an existing table.   querygen The querygen command is a search query generation tool that creates a sample Java class file. The class file produced will ..."},"306":{y:0,u:"../nsc/Model_Commands.htm",l:-1,t:"rlcreate –modelname \u003cname\u003e -file \u003cmodel-file\u003e",i:0.000254387859382893,a:"Model Commands rlcreate –modelname \u003cname\u003e -file \u003cmodel-file\u003e The rlcreate command loads an TIBCO® Patterns machine learning model contained in the file  model-file into the Matching Engine. The model is named  name.  rldelete –modellist \u003cmodel1,model2,…\u003e  The rllist returns a list of all the models ..."},"307":{y:0,u:"../nsc/Checkpoint_Commands.htm",l:-1,t:"getcheckpointstatus –table \u003cname\u003e",i:0.000254387859382893,a:"Checkpoint Commands getcheckpointstatus –table \u003cname\u003e Use the getcheckpointstatus command to return the checkpoint status of the named file.  If the table has been checkpointed the time of the last checkpoint is given. checkpoint –tables  \u003ctable1,table2,...\u003e Use the checkpoint command to write a ..."},"308":{y:0,u:"../nsc/Server_Interface_Control_Commands.htm",l:-1,t:"debuggingon",i:0.000254387859382893,a:"Server Interface Control Commands debuggingon Use the debugginon command in batch commands to turn debug tracing of all interactions with the TIBCO® Patterns  server. debuggingoff Use the debugginoff  command in batch commands to turn debug tracing off. getconnectionpoolingpolicy Use the ..."},"309":{y:0,u:"../nsc/Server_Status_and_Control_Commands.htm",l:-1,t:"isdecisionengine",i:0.000254387859382893,a:"Server Status and Control Commands isdecisionengine Use the isdecisionengine command to determine if the server is a TIBCO® Patterns Matching Platform server with the machine learning features. isgipenabled Use the isgipenabled command to determine if the GIP prefilter for performance optimization ..."},"310":{y:0,u:"../online-ref/online-references.htm",l:-1,t:"Online References",i:0.000254387859382893,a:"Online References Click the following links to access available online references: .NET API Reference Java API Reference Learn API Documentation JAVA Example Tools Deduplication Library Deduplication Sample Program Grouping Library Query Builder Platform"},"311":{y:0,u:"../_templates/TIBCO-Documentation-and-Support-Services.htm",l:-1,t:"TIBCO Documentation and Support Services",i:0.000254387859382893,a:"For information about this product, you can read the documentation, contact TIBCO Support, and join TIBCO Community. How to Access TIBCO Documentation  Documentation for TIBCO products is available on the  Product Documentation website , mainly in HTML and PDF formats. \n\t   The  Product ..."},"312":{y:0,u:"../_templates/Legal-and-Third-Party-Notices.htm",l:-1,t:"Legal and Third-Party Notices",i:0.000254387859382893,a:"SOME CLOUD SOFTWARE GROUP, INC. (“CLOUD SG”) SOFTWARE AND CLOUD SERVICES EMBED, BUNDLE, OR OTHERWISE INCLUDE OTHER SOFTWARE, INCLUDING OTHER CLOUD SG SOFTWARE (COLLECTIVELY, “INCLUDED SOFTWARE”). USE OF INCLUDED SOFTWARE IS SOLELY TO ENABLE THE FUNCTIONALITY (OR PROVIDE LIMITED ADD-ON FUNCTIONALITY) ..."},"313":{y:0,u:"../api/learn/lib/com/tibco/patterns/learn/training/VectorExample.html",l:-1,t:"VectorExample",i:0.00166492161483011,a:"VectorExample (ibi Patterns Learn Library Documentation)"},"314":{y:0,u:"../tools/deduplication/lib/com/tibco/patterns/deduplication/NetricsRecQuerySource.html",l:-1,t:"NetricsRecQuerySource",i:0.00120209847912807,a:"NetricsRecQuerySource (TIBCO Patterns - Search Deduplication Library)"},"315":{y:0,u:"../api/java/lib/com/netrics/likeit/NetricsBaseRecSrc.html",l:-1,t:"NetricsBaseRecSrc",i:0.00108949727467436,a:"NetricsBaseRecSrc (ibi Patterns - Search Java API)"},"316":{y:0,u:"../tools/deduplication/lib/com/tibco/patterns/deduplication/Log4jLogger.html",l:-1,t:"Log4jLogger",i:0.000976888011578547,a:"Log4jLogger (TIBCO Patterns - Search Deduplication Library)"},"317":{y:0,u:"../tools/query_builder/lib/com/tibco/patterns/qbp/DfltLoaderMgr.html",l:-1,t:"DfltLoaderMgr",i:0.00091745948052228,a:"DfltLoaderMgr (TIBCO Patterns - Search Query Builder Platform Documentation)"},"318":{y:0,u:"../tools/deduplication/lib/com/tibco/patterns/dedupe_utils/package-tree.html",l:-1,t:"package-tree",i:0.00103912490323747,a:"com.tibco.patterns.dedupe_utils Class Hierarchy (TIBCO Patterns - Search Deduplication Library)"},"319":{y:0,u:"../api/dotnet/lib/functions_b.html",l:-1,t:"ibi Patterns .NET API: Class Members",i:0.000254387859382893,a:"\n/* @license magnet:?xt=urn:btih:d3d9a9a6595521f9666a5e94cc830dab83b65699\u0026dn=expat.txt MIT */\nvar searchBox = new SearchBox(\"searchBox\", \"search/\",\u0027.html\u0027);\n/* @license-end */\n \n/* @license magnet:?xt=urn:btih:d3d9a9a6595521f9666a5e94cc830dab83b65699\u0026dn=expat.txt MIT */\n$(function() {\n  ..."},"320":{y:0,u:"../api/dotnet/lib/namespacemembers.html",l:-1,t:"ibi Patterns .NET API: Namespace Members",i:0.000254387859382893,a:"\n/* @license magnet:?xt=urn:btih:d3d9a9a6595521f9666a5e94cc830dab83b65699\u0026dn=expat.txt MIT */\nvar searchBox = new SearchBox(\"searchBox\", \"search/\",\u0027.html\u0027);\n/* @license-end */\n \n/* @license magnet:?xt=urn:btih:d3d9a9a6595521f9666a5e94cc830dab83b65699\u0026dn=expat.txt MIT */\n$(function() {\n  ..."},"321":{y:0,u:"../tools/query_builder/lib/com/tibco/patterns/qbp/SimpleQueryDef.html",l:-1,t:"SimpleQueryDef",i:0.00100878037031823,a:"SimpleQueryDef (TIBCO Patterns - Search Query Builder Platform Documentation)"},"322":{y:0,u:"../api/java/lib/com/netrics/likeit/NetricsCharmapStats.html",l:-1,t:"NetricsCharmapStats",i:0.000916981268693661,a:"NetricsCharmapStats (ibi Patterns - Search Java API)"},"323":{y:0,u:"../api/learn/lib/com/tibco/patterns/learn/api/project/package-tree.html",l:-1,t:"package-tree",i:0.00148966105376421,a:"com.tibco.patterns.learn.api.project Class Hierarchy (ibi Patterns Learn Library Documentation)"},"324":{y:0,u:"../api/learn/lib/com/tibco/patterns/learn/api/hint/HintReviewMislabeled.html",l:-1,t:"HintReviewMislabeled",i:0.000941079455966351,a:"HintReviewMislabeled (ibi Patterns Learn Library Documentation)"},"325":{y:0,u:"../api/java/lib/com/netrics/likeit/NetricsCompoundRecord.html",l:-1,t:"NetricsCompoundRecord",i:0.00121861322923683,a:"NetricsCompoundRecord (ibi Patterns - Search Java API)"},"326":{y:0,u:"../api/learn/lib/com/tibco/patterns/learn/training/COIterationCount.html",l:-1,t:"COIterationCount",i:0.00113750613092051,a:"COIterationCount (ibi Patterns Learn Library Documentation)"},"327":{y:0,u:"../tools/deduplication/lib/allpackages-index.html",l:-1,t:"allpackages-index",i:0.00039172238711911,a:"All Packages (TIBCO Patterns - Search Deduplication Library)"},"328":{y:0,u:"../api/dotnet/lib/functions_func_w.html",l:-1,t:"ibi Patterns .NET API: Class Members - Functions",i:0.000254387859382893,a:"\n/* @license magnet:?xt=urn:btih:d3d9a9a6595521f9666a5e94cc830dab83b65699\u0026dn=expat.txt MIT */\nvar searchBox = new SearchBox(\"searchBox\", \"search/\",\u0027.html\u0027);\n/* @license-end */\n \n/* @license magnet:?xt=urn:btih:d3d9a9a6595521f9666a5e94cc830dab83b65699\u0026dn=expat.txt MIT */\n$(function() {\n  ..."},"329":{y:0,u:"../api/java/sample/overview-tree.html",l:-1,t:"overview-tree",i:0.00144285679782853,a:"Class Hierarchy (ibi Patterns - Search Java API Examples)"},"330":{y:0,u:"../tools/deduplication/sample/package-summary.html",l:-1,t:"package-summary",i:0.00284449717376261,a:"Unnamed"},"331":{y:0,u:"../api/dotnet/lib/class_netrics_server_interface_1_1_netrics_server_stats.html",l:-1,t:"ibi Patterns .NET API: NetricsServerInterface.NetricsServerStats Class Reference",i:0.00351548699941634,a:"\n/* @license magnet:?xt=urn:btih:d3d9a9a6595521f9666a5e94cc830dab83b65699\u0026dn=expat.txt MIT */\nvar searchBox = new SearchBox(\"searchBox\", \"search/\",\u0027.html\u0027);\n/* @license-end */\n \n/* @license magnet:?xt=urn:btih:d3d9a9a6595521f9666a5e94cc830dab83b65699\u0026dn=expat.txt MIT */\n$(function() {\n  ..."},"332":{y:0,u:"../tools/query_builder/lib/com/tibco/patterns/qbp/DateQueryDef.html",l:-1,t:"DateQueryDef",i:0.00113416554756264,a:"DateQueryDef (TIBCO Patterns - Search Query Builder Platform Documentation)"},"333":{y:0,u:"../api/java/lib/com/netrics/likeit/NetricsCSVRecSrc.html",l:-1,t:"NetricsCSVRecSrc",i:0.000896518493195819,a:"NetricsCSVRecSrc (ibi Patterns - Search Java API)"},"334":{y:0,u:"../api/dotnet/lib/class_netrics_server_interface_1_1_confidence_qlt.html",l:-1,t:"ibi Patterns .NET API: NetricsServerInterface.ConfidenceQlt Class Reference",i:0.00240598324812234,a:"\n/* @license magnet:?xt=urn:btih:d3d9a9a6595521f9666a5e94cc830dab83b65699\u0026dn=expat.txt MIT */\nvar searchBox = new SearchBox(\"searchBox\", \"search/\",\u0027.html\u0027);\n/* @license-end */\n \n/* @license magnet:?xt=urn:btih:d3d9a9a6595521f9666a5e94cc830dab83b65699\u0026dn=expat.txt MIT */\n$(function() {\n  ..."},"335":{y:0,u:"../api/dotnet/lib/class_netrics_server_interface_1_1_netrics_table_cursor.html",l:-1,t:"ibi Patterns .NET API: NetricsServerInterface.NetricsTableCursor Class Reference",i:0.00343970375099171,a:"\n/* @license magnet:?xt=urn:btih:d3d9a9a6595521f9666a5e94cc830dab83b65699\u0026dn=expat.txt MIT */\nvar searchBox = new SearchBox(\"searchBox\", \"search/\",\u0027.html\u0027);\n/* @license-end */\n \n/* @license magnet:?xt=urn:btih:d3d9a9a6595521f9666a5e94cc830dab83b65699\u0026dn=expat.txt MIT */\n$(function() {\n  ..."},"336":{y:0,u:"../api/dotnet/lib/class_netrics_server_interface_1_1_netrics_array_rec_op_src.html",l:-1,t:"ibi Patterns .NET API: NetricsServerInterface.NetricsArrayRecOpSrc Class Reference",i:0.00231559889914736,a:"\n/* @license magnet:?xt=urn:btih:d3d9a9a6595521f9666a5e94cc830dab83b65699\u0026dn=expat.txt MIT */\nvar searchBox = new SearchBox(\"searchBox\", \"search/\",\u0027.html\u0027);\n/* @license-end */\n \n/* @license magnet:?xt=urn:btih:d3d9a9a6595521f9666a5e94cc830dab83b65699\u0026dn=expat.txt MIT */\n$(function() {\n  ..."},"337":{y:0,u:"../api/learn/lib/com/tibco/patterns/learn/api/feature/GenericFeature.html",l:-1,t:"GenericFeature",i:0.000905875229458048,a:"GenericFeature (ibi Patterns Learn Library Documentation)"},"338":{y:0,u:"../api/dotnet/lib/functions_func_h.html",l:-1,t:"ibi Patterns .NET API: Class Members - Functions",i:0.000254387859382893,a:"\n/* @license magnet:?xt=urn:btih:d3d9a9a6595521f9666a5e94cc830dab83b65699\u0026dn=expat.txt MIT */\nvar searchBox = new SearchBox(\"searchBox\", \"search/\",\u0027.html\u0027);\n/* @license-end */\n \n/* @license magnet:?xt=urn:btih:d3d9a9a6595521f9666a5e94cc830dab83b65699\u0026dn=expat.txt MIT */\n$(function() {\n  ..."},"339":{y:0,u:"../api/dotnet/lib/class_netrics_server_interface_1_1_netrics_c_s_v_reader-members.html",l:-1,t:"ibi Patterns .NET API: Member List",i:0.000912765254194301,a:"\n/* @license magnet:?xt=urn:btih:d3d9a9a6595521f9666a5e94cc830dab83b65699\u0026dn=expat.txt MIT */\nvar searchBox = new SearchBox(\"searchBox\", \"search/\",\u0027.html\u0027);\n/* @license-end */\n \n/* @license magnet:?xt=urn:btih:d3d9a9a6595521f9666a5e94cc830dab83b65699\u0026dn=expat.txt MIT */\n$(function() {\n  ..."},"340":{y:0,u:"../api/dotnet/lib/class_netrics_server_interface_1_1_netrics_thes_stats.html",l:-1,t:"class_netrics_server_interface_1_1_netrics_thes_stats",i:0.00160449893932813,a:"ibi Patterns .NET API: NetricsServerInterface.NetricsThesStats Class Reference"},"341":{y:0,u:"../api/learn/lib/com/tibco/patterns/learn/api/project/RecPairMap.html",l:-1,t:"RecPairMap",i:0.00098180778564277,a:"RecPairMap (ibi Patterns Learn Library Documentation)"},"342":{y:0,u:"../tools/deduplication/lib/constant-values.html",l:-1,t:"constant-values",i:0.00103328729537935,a:"Constant Field Values (TIBCO Patterns - Search Deduplication Library)"},});